/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.viewers.tooling.ui.views.tabs;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.viatra.addon.viewers.tooling.ui.views.tabs.IViewerSandboxTab;

public abstract class AbstractViewerSandboxTab
implements IViewerSandboxTab {
    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.getViewer().addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.getViewer().removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        Viewer viewer = this.getViewer();
        if (viewer != null && !viewer.getControl().isDisposed()) {
            try {
                viewer.setSelection(selection);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public ISelection getSelection() {
        Viewer viewer = this.getViewer();
        if (viewer != null && !viewer.getControl().isDisposed()) {
            return viewer.getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    @Override
    public void createPartControl(CTabFolder folder) {
        CTabItem tab = new CTabItem(folder, 0);
        tab.setText(this.getTabTitle());
        Viewer viewer = this.createViewer((Composite)folder);
        tab.setControl(viewer.getControl());
    }

    @Override
    public void dispose() {
    }

    protected abstract Viewer getViewer();

    protected abstract Viewer createViewer(Composite var1);
}

