/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.boundary;

import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContext;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.rete.boundary.Disconnectable;
import org.eclipse.viatra.query.runtime.rete.boundary.InputConnector;
import org.eclipse.viatra.query.runtime.rete.matcher.ReteEngine;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.single.FilterNode;

public class ExternalInputStatelessFilterNode
extends FilterNode
implements Disconnectable {
    IQueryRuntimeContext context = null;
    IInputKey inputKey;
    private InputConnector inputConnector;
    private TupleMask mask;

    public ExternalInputStatelessFilterNode(ReteContainer reteContainer, TupleMask mask) {
        super(reteContainer);
        this.mask = mask;
        this.inputConnector = reteContainer.getNetwork().getInputConnector();
    }

    @Override
    public boolean check(Tuple ps) {
        if (this.mask != null) {
            ps = this.mask.transform(ps);
        }
        return this.context.containsTuple(this.inputKey, ps);
    }

    public void connectThroughContext(ReteEngine engine, IInputKey inputKey) {
        this.inputKey = inputKey;
        this.setTag(inputKey);
        IQueryRuntimeContext context = engine.getRuntimeContext();
        if (!context.getMetaContext().isStateless(inputKey)) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getSimpleName()) + " only applicable for stateless input keys; received instead " + inputKey);
        }
        this.context = context;
        engine.addDisconnectable(this);
    }

    @Override
    public void disconnect() {
        this.context = null;
    }
}

