/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.network;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import org.eclipse.viatra.query.runtime.base.itc.alg.incscc.IncSCCAlg;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.topsort.TopologicalSorting;
import org.eclipse.viatra.query.runtime.base.itc.graphimpl.Graph;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IGraphDataSource;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.rete.aggregation.IAggregatorNode;
import org.eclipse.viatra.query.runtime.rete.boundary.ExternalInputEnumeratorNode;
import org.eclipse.viatra.query.runtime.rete.index.DualInputNode;
import org.eclipse.viatra.query.runtime.rete.index.ExistenceNode;
import org.eclipse.viatra.query.runtime.rete.index.Indexer;
import org.eclipse.viatra.query.runtime.rete.index.IterableIndexer;
import org.eclipse.viatra.query.runtime.rete.network.CommunicationGroup;
import org.eclipse.viatra.query.runtime.rete.network.DefaultMailbox;
import org.eclipse.viatra.query.runtime.rete.network.Mailbox;
import org.eclipse.viatra.query.runtime.rete.network.MessageKind;
import org.eclipse.viatra.query.runtime.rete.network.Node;
import org.eclipse.viatra.query.runtime.rete.network.Receiver;
import org.eclipse.viatra.query.runtime.rete.network.RederivableNode;
import org.eclipse.viatra.query.runtime.rete.single.DefaultProductionNode;
import org.eclipse.viatra.query.runtime.rete.single.TransitiveClosureNode;
import org.eclipse.viatra.query.runtime.rete.single.TrimmerNode;

public final class CommunicationTracker {
    private int minGroupId;
    private int maxGroupId;
    private final Graph<Node> dependencyGraph = new Graph();
    private final IncSCCAlg<Node> sccInformationProvider = new IncSCCAlg(this.dependencyGraph);
    private final Map<Node, CommunicationGroup> groupMap;
    private final Queue<CommunicationGroup> groupQueue = new PriorityQueue<CommunicationGroup>();

    public CommunicationTracker() {
        this.groupMap = new HashMap<Node, CommunicationGroup>();
    }

    private void precomputeGroups() {
        this.groupMap.clear();
        Graph reducedGraph = this.sccInformationProvider.getReducedGraph();
        List representatives = TopologicalSorting.compute((IGraphDataSource)reducedGraph);
        int i = 0;
        while (i < representatives.size()) {
            Iterator representative = (Node)representatives.get(i);
            this.createAndStoreGroup((Node)((Object)representative), i);
            ++i;
        }
        this.minGroupId = 0;
        this.maxGroupId = representatives.size() - 1;
        for (Node node : this.dependencyGraph.getAllNodes()) {
            Node representative = (Node)this.sccInformationProvider.getRepresentative((Object)node);
            CommunicationGroup group = this.groupMap.get(representative);
            if (representative == node) continue;
            this.groupMap.put(node, group);
        }
        for (Node node : this.dependencyGraph.getAllNodes()) {
            this.precomputeFallThroughFlag(node);
        }
        if (!this.groupQueue.isEmpty()) {
            HashSet<CommunicationGroup> immediatelyActiveGroups = new HashSet<CommunicationGroup>();
            for (CommunicationGroup oldGroup : this.groupQueue) {
                for (Map.Entry<MessageKind, Collection<Mailbox>> entry : oldGroup.getMailboxes().entrySet()) {
                    for (Mailbox mailbox : entry.getValue()) {
                        CommunicationGroup newGroup = this.groupMap.get(mailbox.getReceiver());
                        newGroup.notifyHasMessage(mailbox, entry.getKey());
                        immediatelyActiveGroups.add(newGroup);
                    }
                }
                for (RederivableNode node : oldGroup.getRederivables()) {
                    CommunicationGroup newGroup = this.groupMap.get(node);
                    newGroup.addRederivable(node);
                    immediatelyActiveGroups.add(newGroup);
                }
                oldGroup.isEnqueued = false;
            }
            this.groupQueue.clear();
            for (CommunicationGroup group : immediatelyActiveGroups) {
                this.activate(group);
            }
        }
    }

    private void precomputeFallThroughFlag(Node node) {
        Mailbox mailbox;
        CommunicationGroup group = this.groupMap.get(node);
        if (node instanceof Receiver && (mailbox = ((Receiver)node).getMailbox()) instanceof DefaultMailbox) {
            boolean fallThrough;
            Set directParents = this.dependencyGraph.getSourceNodes((Object)node).keySet();
            boolean bl = fallThrough = (!(node instanceof DefaultProductionNode) || directParents.size() <= 0 && (directParents.size() != 1 || !this.trueTrimming((Node)directParents.iterator().next()))) && !(node instanceof ExternalInputEnumeratorNode);
            if (fallThrough) {
                block0: for (Node directParent : directParents) {
                    HashSet<Node> parentsToCheck = new HashSet<Node>();
                    parentsToCheck.add(directParent);
                    if (directParent instanceof DualInputNode) {
                        Indexer secondarySlot;
                        if (directParent instanceof ExistenceNode) {
                            fallThrough = false;
                            break;
                        }
                        DualInputNode dualInput = (DualInputNode)directParent;
                        IterableIndexer primarySlot = dualInput.getPrimarySlot();
                        if (primarySlot != null) {
                            parentsToCheck.add(primarySlot.getActiveNode());
                        }
                        if ((secondarySlot = dualInput.getSecondarySlot()) != null) {
                            parentsToCheck.add(secondarySlot.getActiveNode());
                        }
                    }
                    for (Node parent : parentsToCheck) {
                        CommunicationGroup parentGroup = this.groupMap.get(parent);
                        if ((group == parentGroup || !(parentGroup instanceof CommunicationGroup.Recursive)) && (group != parentGroup || !(group instanceof CommunicationGroup.Recursive) || !(parent instanceof TransitiveClosureNode) && !(parent instanceof IAggregatorNode) && !this.trueTrimming(parent))) continue;
                        fallThrough = false;
                        break block0;
                    }
                }
            }
            ((DefaultMailbox)mailbox).setFallThrough(fallThrough);
        }
    }

    private boolean trueTrimming(Node node) {
        if (node instanceof TrimmerNode) {
            TupleMask mask = ((TrimmerNode)node).getMask();
            return mask.indices.length != mask.sourceWidth;
        }
        return false;
    }

    private void activate(CommunicationGroup group) {
        if (!group.isEnqueued) {
            this.groupQueue.add(group);
            group.isEnqueued = true;
        }
    }

    private void deactivate(CommunicationGroup group) {
        this.groupQueue.remove(group);
        group.isEnqueued = false;
    }

    public void addRederivable(RederivableNode node) {
        CommunicationGroup group = this.groupMap.get(node);
        group.addRederivable(node);
        this.activate(group);
    }

    public void removeRederivable(RederivableNode node) {
        CommunicationGroup group = this.groupMap.get(node);
        group.removeRederivable(node);
        if (group.isEmpty()) {
            this.deactivate(group);
        }
    }

    public void notifyHasMessage(Mailbox mailbox, MessageKind kind) {
        Receiver receiver = mailbox.getReceiver();
        CommunicationGroup group = this.groupMap.get(receiver);
        group.notifyHasMessage(mailbox, kind);
        this.activate(group);
    }

    public void notifyLostAllMessages(Mailbox mailbox, MessageKind kind) {
        Receiver receiver = mailbox.getReceiver();
        CommunicationGroup group = this.groupMap.get(receiver);
        group.notifyLostAllMessages(mailbox, kind);
        if (group.isEmpty()) {
            this.deactivate(group);
        }
    }

    public CommunicationGroup getAndRemoveFirstGroup() {
        CommunicationGroup group = this.groupQueue.poll();
        group.isEnqueued = false;
        return group;
    }

    public boolean isEmpty() {
        return this.groupQueue.isEmpty();
    }

    protected CommunicationGroup createAndStoreGroup(Node representative, int index) {
        boolean isSingleton = this.sccInformationProvider.sccs.getPartition((Object)representative).size() == 1;
        boolean isReceiver = representative instanceof Receiver;
        boolean isDefault = isReceiver && ((Receiver)representative).getMailbox() instanceof DefaultMailbox;
        CommunicationGroup group = null;
        group = isSingleton && (isDefault || !isReceiver) ? new CommunicationGroup.Singleton(representative, index) : new CommunicationGroup.Recursive(representative, index);
        this.groupMap.put(representative, group);
        return group;
    }

    public void registerDependency(Node source, Node target) {
        int targetIndex;
        this.dependencyGraph.insertNode((Object)source);
        this.dependencyGraph.insertNode((Object)target);
        Node sourceRepresentative = (Node)this.sccInformationProvider.getRepresentative((Object)source);
        Node targetRepresentative = (Node)this.sccInformationProvider.getRepresentative((Object)target);
        boolean hadOutgoingEdges = this.sccInformationProvider.hasOutgoingEdges((Object)targetRepresentative);
        this.dependencyGraph.insertEdge((Object)source, (Object)target);
        CommunicationGroup sourceGroup = this.groupMap.get(sourceRepresentative);
        if (sourceGroup == null) {
            sourceGroup = this.createAndStoreGroup(sourceRepresentative, --this.minGroupId);
        }
        int sourceIndex = sourceGroup.identifier;
        CommunicationGroup targetGroup = this.groupMap.get(targetRepresentative);
        if (targetGroup == null) {
            targetGroup = this.createAndStoreGroup(targetRepresentative, ++this.maxGroupId);
        }
        if (sourceIndex <= (targetIndex = targetGroup.identifier)) {
            this.refreshFallThroughFlag(target);
        } else if (sourceIndex > targetIndex && !hadOutgoingEdges) {
            boolean wasEnqueued = targetGroup.isEnqueued;
            if (wasEnqueued) {
                this.groupQueue.remove(targetGroup);
            }
            targetGroup.identifier = ++this.maxGroupId;
            if (wasEnqueued) {
                this.groupQueue.add(targetGroup);
            }
            this.refreshFallThroughFlag(target);
        } else {
            this.precomputeGroups();
        }
    }

    public void unregisterDependency(Node source, Node target) {
        this.dependencyGraph.deleteEdge((Object)source, (Object)target);
        Node sourceRepresentative = (Node)this.sccInformationProvider.getRepresentative((Object)source);
        Node targetRepresentative = (Node)this.sccInformationProvider.getRepresentative((Object)target);
        if (sourceRepresentative.equals(targetRepresentative)) {
            this.refreshFallThroughFlag(target);
        } else {
            this.precomputeGroups();
        }
    }

    private void refreshFallThroughFlag(Node target) {
        this.precomputeFallThroughFlag(target);
        if (target instanceof DualInputNode) {
            for (Node indirectTarget : this.dependencyGraph.getTargetNodes((Object)target).keySet()) {
                this.precomputeFallThroughFlag(indirectTarget);
            }
        }
    }
}

