/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.localsearch.ui.debugger;

import com.google.common.collect.BiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ILocalSearchAdaptable;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ILocalSearchAdapter;
import org.eclipse.viatra.query.runtime.localsearch.matcher.LocalSearchMatcher;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.plan.SearchPlanExecutor;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.viewelement.SearchOperationViewerNode;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.viewelement.SearchPlanViewModel;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.views.LocalSearchDebugView;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.views.internal.BreakPointListener;

public class LocalSearchDebugger
implements ILocalSearchAdapter {
    public static volatile Object notifier = new Object();
    private LocalSearchDebugView localSearchDebugView;
    private Deque<LocalSearchMatcher> runningMatchers;
    private Deque<SearchPlanExecutor> runningExecutors;
    private List<ILocalSearchAdaptable> adaptedElements = Lists.newArrayList();
    private boolean startHandlerCalled = false;
    private boolean isDisposed = false;
    private boolean hasFinished = false;
    private boolean halted = true;
    private SearchPlanViewModel viewModel;
    private boolean shouldSelectOtherTab = false;

    public LocalSearchDebugView getLocalSearchDebugView() throws PartInitException {
        if (this.localSearchDebugView == null) {
            this.localSearchDebugView = (LocalSearchDebugView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.viatra.query.tooling.localsearch.ui.LocalSearchDebugView");
        }
        return this.localSearchDebugView;
    }

    public boolean isStartHandlerCalled() {
        return this.startHandlerCalled;
    }

    public void setStartHandlerCalled(boolean startHandlerCalled) {
        this.startHandlerCalled = startHandlerCalled;
    }

    public void patternMatchingStarted(final LocalSearchMatcher lsMatcher) {
        if (this.isDisposed) {
            return;
        }
        if (this.startHandlerCalled) {
            this.startHandlerCalled = false;
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        LocalSearchDebugger.this.getLocalSearchDebugView();
                        BreakPointListener breakPointListener = new BreakPointListener(LocalSearchDebugger.this);
                        TreeViewer operationListViewer = LocalSearchDebugger.this.localSearchDebugView.getOperationListViewer();
                        operationListViewer.addDoubleClickListener((IDoubleClickListener)breakPointListener);
                        LocalSearchDebugger.this.localSearchDebugView.setDebugger(LocalSearchDebugger.this);
                        LocalSearchDebugger.this.runningMatchers = Queues.newArrayDeque();
                        LocalSearchDebugger.this.runningExecutors = Queues.newArrayDeque();
                        TableViewer matchesViewer = LocalSearchDebugger.this.localSearchDebugView.getMatchesViewer(lsMatcher.getQuerySpecification());
                        List storedFrames = (List)matchesViewer.getData("key");
                        storedFrames.clear();
                        LocalSearchDebugger.this.localSearchDebugView.refreshView();
                    }
                    catch (PartInitException e) {
                        ViatraQueryLoggingUtil.getDefaultLogger().log((Priority)Level.ERROR, (Object)("A part init exception occured while executing pattern matcher started handler" + e.getMessage()), (Throwable)e);
                    }
                }
            });
        }
        this.runningMatchers.push(lsMatcher);
    }

    public void patternMatchingFinished(LocalSearchMatcher matcher) {
        if (this.isDisposed) {
            return;
        }
        LocalSearchMatcher removedMatcher = this.runningMatchers.pop();
        if (this.runningMatchers.size() == 0) {
            this.halted = true;
            this.hasFinished = true;
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    LocalSearchDebugger.this.localSearchDebugView.getMatchesTabFolder().setSelection(0);
                    LocalSearchDebugger.this.localSearchDebugView.getOperationListViewer().collapseAll();
                }
            });
            this.localSearchDebugView.refreshView();
        } else {
            TableViewer matchesViewer = this.localSearchDebugView.getMatchesViewer(removedMatcher.getQuerySpecification());
            List storedFrames = (List)matchesViewer.getData("key");
            storedFrames.clear();
            this.shouldSelectOtherTab = true;
        }
    }

    public void planChanged(SearchPlanExecutor oldPlanExecutor, final SearchPlanExecutor newPlanExecutor) {
        if (this.isDisposed) {
            return;
        }
        if (oldPlanExecutor != null) {
            this.runningExecutors.pop();
        }
        if (newPlanExecutor != null) {
            this.runningExecutors.push(newPlanExecutor);
        }
        if (this.runningMatchers.size() == 1 && newPlanExecutor != null) {
            this.viewModel = new SearchPlanViewModel(this.createOperationsListFromExecutor(newPlanExecutor));
            this.viewModel.setDebugger(this);
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    LocalSearchDebugger.this.localSearchDebugView.getOperationListViewer().setInput((Object)LocalSearchDebugger.this.viewModel);
                }
            });
        } else if (newPlanExecutor != null) {
            this.viewModel.insertForCurrent(this.createOperationsListFromExecutor(newPlanExecutor));
        }
        PQuery querySpecification = this.runningMatchers.peek().getQuerySpecification();
        final int keySize = querySpecification.getParameters().size();
        final TableViewer matchesViewer = this.localSearchDebugView.getMatchesViewer(querySpecification);
        List storedFrames = (List)matchesViewer.getData("key");
        if (!storedFrames.isEmpty()) {
            storedFrames.remove(storedFrames.size() - 1);
        }
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                BiMap variableMapping = newPlanExecutor.getVariableMapping();
                ArrayList columnNames = Lists.newArrayList();
                int i = 0;
                while (i < variableMapping.size()) {
                    columnNames.add(((PVariable)variableMapping.get((Object)i)).getName());
                    ++i;
                }
                LocalSearchDebugger.this.localSearchDebugView.recreateColumns(columnNames, keySize, matchesViewer);
            }
        });
    }

    public void executorInitializing(SearchPlanExecutor searchPlanExecutor, MatchingFrame frame) {
        if (this.isDisposed) {
            return;
        }
        TableViewer matchesViewer = this.localSearchDebugView.getMatchesViewer(this.runningMatchers.peek().getQuerySpecification());
        List storedFrames = (List)matchesViewer.getData("key");
        if (!storedFrames.contains(frame)) {
            storedFrames.add(frame);
        }
    }

    public void operationSelected(SearchPlanExecutor planExecutor, MatchingFrame frame) {
        if (this.isDisposed) {
            return;
        }
        this.viewModel.stepInto();
        this.checkForBreakPoint();
    }

    public void operationExecuted(SearchPlanExecutor planExecutor, MatchingFrame frame) {
        if (this.isDisposed) {
            return;
        }
        if (this.halted) {
            this.localSearchDebugView.refreshView();
            if (this.shouldSelectOtherTab) {
                this.shouldSelectOtherTab = false;
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        LocalSearchDebugger.this.localSearchDebugView.getMatchesTabFolder().setSelection(LocalSearchDebugger.this.runningMatchers.size() - 1);
                    }
                });
            }
        }
    }

    public void matchFound(SearchPlanExecutor planExecutor, MatchingFrame frame) {
        if (this.isDisposed) {
            return;
        }
        MatchingFrame frameToStore = new MatchingFrame(frame);
        TableViewer matchesViewer = this.localSearchDebugView.getMatchesViewer(this.runningMatchers.peek().getQuerySpecification());
        List storedFrames = (List)matchesViewer.getData("key");
        storedFrames.add(storedFrames.size() - 1, frameToStore);
    }

    public void setHalted(boolean halted) {
        this.halted = halted;
    }

    public boolean isPatternMatchingRunning() {
        return !this.hasFinished;
    }

    private List<SearchOperationViewerNode> createOperationsListFromExecutor(SearchPlanExecutor planExecutor) {
        ArrayList nodes = Lists.newArrayList();
        List plan = planExecutor.getSearchPlan().getOperations();
        for (ISearchOperation operation : plan) {
            nodes.add(new SearchOperationViewerNode(operation, planExecutor));
        }
        nodes.add(new SearchOperationViewerNode(planExecutor));
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForBreakPoint() {
        if (this.localSearchDebugView != null && this.halted) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (LocalSearchDebugger.this.shouldSelectOtherTab) {
                        LocalSearchDebugger.this.shouldSelectOtherTab = false;
                        LocalSearchDebugger.this.localSearchDebugView.getMatchesTabFolder().setSelection(LocalSearchDebugger.this.runningMatchers.size() - 1);
                    }
                    SearchOperationViewerNode lastSelected = LocalSearchDebugger.this.viewModel.getLastSelected();
                    LocalSearchDebugger.this.localSearchDebugView.getOperationListViewer().collapseAll();
                    LocalSearchDebugger.this.localSearchDebugView.getOperationListViewer().expandToLevel((Object)lastSelected, 0);
                }
            });
            this.localSearchDebugView.refreshView();
            Object object = notifier;
            synchronized (object) {
                try {
                    notifier.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public void adapterRegistered(ILocalSearchAdaptable adaptable) {
        if (this.isDisposed) {
            return;
        }
        this.adaptedElements.add(adaptable);
    }

    public void adapterUnregistered(ILocalSearchAdaptable adaptable) {
        if (this.isDisposed) {
            return;
        }
        this.adaptedElements.remove(adaptable);
    }

    public void dispose() {
        this.isDisposed = true;
        for (ILocalSearchAdaptable adaptable : this.adaptedElements) {
            adaptable.removeAdapter((ILocalSearchAdapter)this);
        }
    }
}

