/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.viewelement;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.viatra.query.runtime.localsearch.operations.IMatcherBasedOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.NACOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.CountOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.ExtendOperation;
import org.eclipse.viatra.query.runtime.localsearch.plan.SearchPlanExecutor;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.viewelement.OperationKind;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.viewelement.OperationStatus;

public class SearchOperationViewerNode {
    private OperationKind operationKind;
    private OperationStatus operationStatus;
    private boolean breakpoint;
    private List<SearchOperationViewerNode> children;
    private SearchOperationViewerNode parent;
    private String labelText;
    private ISearchOperation searchOperation;
    private SearchPlanExecutor planExecutor;
    private boolean matcherBased;

    public SearchOperationViewerNode(SearchPlanExecutor planExecutor) {
        this.planExecutor = planExecutor;
        this.operationKind = OperationKind.MATCH;
        this.setup();
    }

    public SearchOperationViewerNode(ISearchOperation searchOperation, SearchPlanExecutor planExecutor) {
        this.searchOperation = searchOperation;
        this.planExecutor = planExecutor;
        this.operationKind = searchOperation instanceof ExtendOperation ? OperationKind.EXTEND : (searchOperation instanceof NACOperation ? OperationKind.NAC : (searchOperation instanceof CountOperation ? OperationKind.COUNT : OperationKind.CHECK));
        this.setup();
    }

    private void setup() {
        this.matcherBased = this.searchOperation == null ? false : this.searchOperation instanceof IMatcherBasedOperation;
        this.operationStatus = OperationStatus.QUEUED;
        this.children = Lists.newArrayList();
        try {
            if (this.searchOperation != null) {
                this.labelText = this.searchOperation.toString();
                this.labelText = String.valueOf(this.labelText) + "(";
                BiMap variableMapping = this.planExecutor.getVariableMapping();
                List variablePositions = this.searchOperation.getVariablePositions();
                int i = 0;
                while (i < variablePositions.size()) {
                    PVariable pVariable = (PVariable)variableMapping.get(variablePositions.get(i));
                    this.labelText = String.valueOf(this.labelText) + pVariable.getName();
                    if (i != variablePositions.size() - 1) {
                        this.labelText = String.valueOf(this.labelText) + ", ";
                    }
                    ++i;
                }
                this.labelText = String.valueOf(this.labelText) + ")";
            } else {
                this.labelText = "Match found";
            }
        }
        catch (Exception e) {
            this.labelText = "Error while calculating label: " + e.getMessage() + "(" + e.getClass().getSimpleName() + ")";
        }
    }

    public OperationKind getOperationKind() {
        return this.operationKind;
    }

    public OperationStatus getOperationStatus() {
        return this.operationStatus;
    }

    public void setOperationStatus(OperationStatus operationStatus) {
        this.operationStatus = operationStatus;
    }

    public boolean isBreakpoint() {
        return this.breakpoint;
    }

    public void setBreakpoint(boolean breakpoint) {
        this.breakpoint = breakpoint;
    }

    public ImmutableList<SearchOperationViewerNode> getChildren() {
        return ImmutableList.copyOf(this.children);
    }

    public void addChild(SearchOperationViewerNode child) {
        this.children.add(child);
        child.parent = this;
    }

    public void addChildren(List<SearchOperationViewerNode> children) {
        this.children.addAll(children);
        for (SearchOperationViewerNode child : children) {
            child.parent = this;
        }
    }

    public void setChildren(List<SearchOperationViewerNode> children) {
        this.children = children;
        for (SearchOperationViewerNode child : children) {
            child.parent = this;
        }
    }

    public SearchOperationViewerNode getParent() {
        return this.parent;
    }

    public void setParent(SearchOperationViewerNode parent) {
        this.parent = parent;
        parent.addChild(this);
    }

    public String getLabelText() {
        return this.labelText;
    }

    public void setLabelText(String labelText) {
        this.labelText = labelText;
    }

    public ISearchOperation getSearchOperation() {
        return this.searchOperation;
    }

    public SearchPlanExecutor getPlanExecutor() {
        return this.planExecutor;
    }

    public boolean isMatcherBased() {
        return this.matcherBased;
    }
}

