/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryresult.properties;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.celleditor.ExtendedComboBoxCellEditor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.api.scope.IBaseIndex;
import org.eclipse.viatra.query.runtime.base.api.IndexingLevel;
import org.eclipse.viatra.query.runtime.base.api.NavigationHelper;
import org.eclipse.viatra.query.runtime.emf.EMFBaseIndexWrapper;
import org.eclipse.viatra.query.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.emf.types.EDataTypeInSlotsKey;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.context.common.JavaTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeMatcher;
import org.eclipse.viatra.query.tooling.ui.queryresult.util.QueryResultViewUtil;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
public class MatchParameterPropertyDescriptor
implements IPropertyDescriptor {
    private String category = "Filters";
    private final PParameter parameter;
    private final QueryResultTreeMatcher matcher;
    private final AdapterFactory adapterFactory = QueryResultViewUtil.getGenericAdapterFactory();
    private final AdapterFactoryItemDelegator adapterFactoryItemDelegator = new AdapterFactoryItemDelegator(this.adapterFactory);
    private final AdapterFactoryLabelProvider adapterFactoryLabelProvider = new AdapterFactoryLabelProvider(this.adapterFactory);
    private final LabelProvider labelProvider = new LabelProvider(){

        public String getText(Object element) {
            return MatchParameterPropertyDescriptor.this.adapterFactoryItemDelegator.getText(element);
        }

        public Image getImage(Object element) {
            Object _image = MatchParameterPropertyDescriptor.this.adapterFactoryItemDelegator.getImage(element);
            return ExtendedImageRegistry.INSTANCE.getImage(_image);
        }
    };

    public CellEditor createPropertyEditor(Composite parent) {
        IInputKey typeKey = this.parameter.getDeclaredUnaryType();
        if (typeKey != null) {
            CellEditor result = this.prepareEditorForDeclaredType(parent, typeKey);
            return result;
        }
        return this.prepareEditorForUnknownType(parent);
    }

    protected CellEditor prepareEditorForDeclaredType(Composite parent, IInputKey typeKey) {
        ExtendedComboBoxCellEditor _xblockexpression;
        ExtendedComboBoxCellEditor _switchResult = null;
        boolean _matched = false;
        if (!_matched && typeKey instanceof JavaTransitiveInstancesKey) {
            _matched = true;
            return this.prepareEditorForUnknownType(parent);
        }
        if (!_matched && typeKey instanceof EClassTransitiveInstancesKey) {
            _matched = true;
            _xblockexpression = null;
            EClass eClass = (EClass)((EClassTransitiveInstancesKey)typeKey).getEmfKey();
            ArrayList<EObject> choiceOfValues = this.getChoiceOfValues(eClass);
            ArrayList<EObject> _arrayList = new ArrayList<EObject>(choiceOfValues);
            _switchResult = _xblockexpression = new ExtendedComboBoxCellEditor(parent, _arrayList, (ILabelProvider)this.labelProvider, true);
        }
        if (!_matched && typeKey instanceof EDataTypeInSlotsKey) {
            _matched = true;
            _xblockexpression = null;
            EDataType dataType = (EDataType)((EDataTypeInSlotsKey)typeKey).getEmfKey();
            PropertyDescriptor.EDataTypeCellEditor _xifexpression = null;
            if (dataType instanceof EEnum) {
                ExtendedComboBoxCellEditor _xblockexpression_1 = null;
                EList _eLiterals = ((EEnum)dataType).getELiterals();
                Functions.Function1<EEnumLiteral, Enumerator> _function = new Functions.Function1<EEnumLiteral, Enumerator>(){

                    public Enumerator apply(EEnumLiteral it) {
                        return it.getInstance();
                    }
                };
                List choiceOfValues = ListExtensions.map((List)_eLiterals, (Functions.Function1)_function);
                ArrayList _arrayList = new ArrayList(choiceOfValues);
                _xblockexpression_1 = new ExtendedComboBoxCellEditor(parent, _arrayList, (ILabelProvider)this.labelProvider, false);
                _xifexpression = _xblockexpression_1;
            } else {
                PropertyDescriptor.EDataTypeCellEditor _xifexpression_1 = null;
                boolean _or = false;
                Class _instanceClass = dataType.getInstanceClass();
                boolean _equals = Objects.equal((Object)_instanceClass, Boolean.class);
                if (_equals) {
                    _or = true;
                } else {
                    boolean _equals_1;
                    Class _instanceClass_1 = dataType.getInstanceClass();
                    _or = _equals_1 = Objects.equal((Object)_instanceClass_1, Boolean.TYPE);
                }
                if (_or) {
                    List<Boolean> _asList = Arrays.asList(Boolean.FALSE, Boolean.TRUE);
                    _xifexpression_1 = new ExtendedComboBoxCellEditor(parent, _asList, (ILabelProvider)this.labelProvider, true);
                } else {
                    _xifexpression_1 = new PropertyDescriptor.EDataTypeCellEditor(dataType, parent);
                }
                _xifexpression = _xifexpression_1;
            }
            _switchResult = _xblockexpression = _xifexpression;
        }
        if (!_matched) {
            String _name;
            ExtendedComboBoxCellEditor _xifexpression = null;
            String _typeName = this.parameter.getTypeName();
            boolean _equals = Objects.equal((Object)_typeName, (Object)(_name = Boolean.class.getName()));
            if (_equals) {
                List<Boolean> _asList = Arrays.asList(Boolean.FALSE, Boolean.TRUE);
                _xifexpression = new ExtendedComboBoxCellEditor(parent, _asList, (ILabelProvider)this.labelProvider, true);
            } else {
                _xifexpression = null;
            }
            _switchResult = _xifexpression;
        }
        ExtendedComboBoxCellEditor result = _switchResult;
        return result;
    }

    protected ExtendedComboBoxCellEditor prepareEditorForUnknownType(Composite parent) {
        ViatraQueryMatcher _matcher = this.matcher.getMatcher();
        String _name = this.parameter.getName();
        Set choiceOfValues = _matcher.getAllValues(_name);
        ArrayList _arrayList = new ArrayList(choiceOfValues);
        ExtendedComboBoxCellEditor editor = new ExtendedComboBoxCellEditor(parent, _arrayList, (ILabelProvider)this.labelProvider, false);
        return editor;
    }

    protected ArrayList<EObject> getChoiceOfValues(EClass eClass) {
        try {
            ArrayList choiceOfValues = CollectionLiterals.newArrayList((Object[])new EObject[0]);
            ViatraQueryMatcher _matcher = this.matcher.getMatcher();
            ViatraQueryEngine _engine = _matcher.getEngine();
            IBaseIndex _baseIndex = _engine.getBaseIndex();
            EMFBaseIndexWrapper emfBaseIndex = (EMFBaseIndexWrapper)_baseIndex;
            NavigationHelper navigationHelper = emfBaseIndex.getNavigationHelper();
            boolean _or = false;
            boolean _isInWildcardMode = navigationHelper.isInWildcardMode();
            if (_isInWildcardMode) {
                _or = true;
            } else {
                boolean _equals;
                IndexingLevel _indexingLevel = navigationHelper.getIndexingLevel(eClass);
                _or = _equals = Objects.equal((Object)_indexingLevel, (Object)IndexingLevel.FULL);
            }
            if (_or) {
                Set allInstances = navigationHelper.getAllInstances(eClass);
                Iterables.addAll((Collection)choiceOfValues, (Iterable)allInstances);
            } else {
                ViatraQueryMatcher _matcher_1 = this.matcher.getMatcher();
                String _name = this.parameter.getName();
                Set _allValues = _matcher_1.getAllValues(_name);
                Iterables.addAll((Collection)choiceOfValues, (Iterable)_allValues);
            }
            return choiceOfValues;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected ArrayList<Object> getChoiceOfValues(EDataType eDataType) {
        try {
            ArrayList choiceOfValues = CollectionLiterals.newArrayList((Object[])new Object[0]);
            ViatraQueryMatcher _matcher = this.matcher.getMatcher();
            ViatraQueryEngine _engine = _matcher.getEngine();
            IBaseIndex _baseIndex = _engine.getBaseIndex();
            EMFBaseIndexWrapper emfBaseIndex = (EMFBaseIndexWrapper)_baseIndex;
            NavigationHelper navigationHelper = emfBaseIndex.getNavigationHelper();
            boolean _or = false;
            boolean _isInWildcardMode = navigationHelper.isInWildcardMode();
            if (_isInWildcardMode) {
                _or = true;
            } else {
                boolean _equals;
                IndexingLevel _indexingLevel = navigationHelper.getIndexingLevel(eDataType);
                _or = _equals = Objects.equal((Object)_indexingLevel, (Object)IndexingLevel.FULL);
            }
            if (_or) {
                Set allInstances = navigationHelper.getDataTypeInstances(eDataType);
                Iterables.addAll((Collection)choiceOfValues, (Iterable)allInstances);
            } else {
                ViatraQueryMatcher _matcher_1 = this.matcher.getMatcher();
                String _name = this.parameter.getName();
                Set _allValues = _matcher_1.getAllValues(_name);
                Iterables.addAll((Collection)choiceOfValues, (Iterable)_allValues);
            }
            return choiceOfValues;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public String getCategory() {
        return this.category;
    }

    public String getDescription() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"Filter for parameter ");
        String _name = this.parameter.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" with type ");
        IInputKey _declaredUnaryType = this.parameter.getDeclaredUnaryType();
        _builder.append((Object)_declaredUnaryType, "");
        return _builder.toString();
    }

    public String getDisplayName() {
        return this.parameter.getName();
    }

    public String[] getFilterFlags() {
        return null;
    }

    public Object getHelpContextIds() {
        return null;
    }

    public Object getId() {
        return this.parameter;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public boolean isCompatibleWith(IPropertyDescriptor anotherProperty) {
        return false;
    }

    public MatchParameterPropertyDescriptor(PParameter parameter, QueryResultTreeMatcher matcher) {
        this.parameter = parameter;
        this.matcher = matcher;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    @Pure
    public PParameter getParameter() {
        return this.parameter;
    }

    @Pure
    public QueryResultTreeMatcher getMatcher() {
        return this.matcher;
    }

    @Pure
    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    @Pure
    public AdapterFactoryItemDelegator getAdapterFactoryItemDelegator() {
        return this.adapterFactoryItemDelegator;
    }

    @Pure
    public AdapterFactoryLabelProvider getAdapterFactoryLabelProvider() {
        return this.adapterFactoryLabelProvider;
    }
}

