/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.actions.TeamAction;
import org.eclipse.team.internal.ui.wizards.ConfigureProjectWizard;

public class ConfigureProjectAction
extends TeamAction {
    @Override
    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    if (!ConfigureProjectAction.this.isEnabled()) {
                        return;
                    }
                    IProject[] projects = ConfigureProjectAction.this.getSelectedProjects();
                    ConfigureProjectWizard.shareProjects(ConfigureProjectAction.this.getShell(), projects);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
        }, TeamUIMessages.ConfigureProjectAction_configureProject, 2);
    }

    public boolean isEnabled() {
        IProject[] selectedProjects = this.getSelectedProjects();
        int i = 0;
        while (i < selectedProjects.length) {
            IProject project = selectedProjects[i];
            if (!project.isAccessible()) {
                return false;
            }
            if (RepositoryProvider.isShared((IProject)project)) {
                return false;
            }
            ++i;
        }
        return selectedProjects.length > 0;
    }
}

