/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.builder;

import com.google.common.collect.HashMultimap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.xtend.core.macro.declaration.IResourceChangeRegistry;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.builder.impl.BuildScheduler;
import org.eclipse.xtext.builder.impl.IBuildFlag;
import org.eclipse.xtext.builder.impl.QueuedBuildData;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

@Singleton
public class UIResourceChangeRegistry
implements IResourceChangeListener,
IResourceChangeRegistry,
IResourceDeltaVisitor {
    private static final Logger logger = Logger.getLogger(UIResourceChangeRegistry.class);
    @Inject
    private QueuedBuildData queue;
    @Inject
    private BuildScheduler scheduler;
    @Inject
    private AbstractUIPlugin uiPlugin;
    private IWorkspace workspace;
    @Accessors
    private final HashMultimap<String, URI> existsListeners = HashMultimap.create();
    @Accessors
    private final HashMultimap<String, URI> charsetListeners = HashMultimap.create();
    @Accessors
    private final HashMultimap<String, URI> childrenListeners = HashMultimap.create();
    @Accessors
    private final HashMultimap<String, URI> contentsListeners = HashMultimap.create();
    @Accessors
    private final HashMultimap<String, URI> changesNotRelevantListeners = HashMultimap.create();
    private static int HAS_CONTENTS_CHANGED_FLAGS = 3408128;

    public synchronized void registerExists(String path, URI uri) {
        boolean _not;
        boolean _containsEntry = this.changesNotRelevantListeners.containsEntry((Object)path, (Object)uri);
        boolean bl = _not = !_containsEntry;
        if (_not) {
            this.existsListeners.put((Object)path, (Object)uri);
        }
    }

    public synchronized void registerGetCharset(String path, URI uri) {
        boolean _not;
        boolean _containsEntry = this.changesNotRelevantListeners.containsEntry((Object)path, (Object)uri);
        boolean bl = _not = !_containsEntry;
        if (_not) {
            this.charsetListeners.put((Object)path, (Object)uri);
        }
    }

    public synchronized void registerGetChildren(String path, URI uri) {
        boolean _not;
        boolean _containsEntry = this.changesNotRelevantListeners.containsEntry((Object)path, (Object)uri);
        boolean bl = _not = !_containsEntry;
        if (_not) {
            this.childrenListeners.put((Object)path, (Object)uri);
        }
    }

    public synchronized void registerGetContents(String path, URI uri) {
        boolean _not;
        boolean _containsEntry = this.changesNotRelevantListeners.containsEntry((Object)path, (Object)uri);
        boolean bl = _not = !_containsEntry;
        if (_not) {
            this.contentsListeners.put((Object)path, (Object)uri);
        }
    }

    public synchronized void registerCreateOrModify(String string, URI uri) {
        this.existsListeners.remove((Object)string, (Object)uri);
        this.charsetListeners.remove((Object)string, (Object)uri);
        this.childrenListeners.remove((Object)string, (Object)uri);
        this.contentsListeners.remove((Object)string, (Object)uri);
        this.changesNotRelevantListeners.put((Object)string, (Object)uri);
    }

    public synchronized void discardCreateOrModifyInformation(URI uri) {
        Collection _values = this.changesNotRelevantListeners.values();
        Set<URI> _singleton = Collections.singleton(uri);
        _values.removeAll(_singleton);
    }

    public synchronized void resourceChanged(IResourceChangeEvent event) {
        try {
            IResourceDelta _delta = event.getDelta();
            _delta.accept((IResourceDeltaVisitor)this);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        if (!this.existsListeners.isEmpty() && this.hasExistsChanged(delta)) {
            boolean _not;
            IResource _resource = delta.getResource();
            IPath _fullPath = _resource.getFullPath();
            String _string = _fullPath.toString();
            Set interestedFiles = this.existsListeners.removeAll((Object)_string);
            boolean _isEmpty = interestedFiles.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                this.queueURIs(interestedFiles);
            }
        }
        if (!this.childrenListeners.isEmpty() && (this.hasExistsChanged(delta) || this.hasChildrenChanged(delta))) {
            boolean _not_1;
            IResource _resource_1 = delta.getResource();
            IPath _fullPath_1 = _resource_1.getFullPath();
            String _string_1 = _fullPath_1.toString();
            Set interestedFiles_1 = this.childrenListeners.removeAll((Object)_string_1);
            boolean _isEmpty_1 = interestedFiles_1.isEmpty();
            boolean bl = _not_1 = !_isEmpty_1;
            if (_not_1) {
                this.queueURIs(interestedFiles_1);
            }
        }
        if (!this.charsetListeners.isEmpty() && (this.hasExistsChanged(delta) || this.hasCharsetChanged(delta))) {
            boolean _not_2;
            IResource _resource_2 = delta.getResource();
            IPath _fullPath_2 = _resource_2.getFullPath();
            String _string_2 = _fullPath_2.toString();
            Set interestedFiles_2 = this.charsetListeners.removeAll((Object)_string_2);
            boolean _isEmpty_2 = interestedFiles_2.isEmpty();
            boolean bl = _not_2 = !_isEmpty_2;
            if (_not_2) {
                this.queueURIs(interestedFiles_2);
            }
        }
        if (!this.contentsListeners.isEmpty() && (this.hasExistsChanged(delta) || this.hasContentsChanged(delta))) {
            boolean _not_3;
            IResource _resource_3 = delta.getResource();
            IPath _fullPath_3 = _resource_3.getFullPath();
            String _string_3 = _fullPath_3.toString();
            Set interestedFiles_3 = this.contentsListeners.removeAll((Object)_string_3);
            boolean _isEmpty_3 = interestedFiles_3.isEmpty();
            boolean bl = _not_3 = !_isEmpty_3;
            if (_not_3) {
                this.queueURIs(interestedFiles_3);
            }
        }
        return true;
    }

    protected void queueURIs(Set<URI> interestedFiles) {
        this.queue.queueURIs(interestedFiles);
    }

    private boolean hasExistsChanged(IResourceDelta delta) {
        return delta.getKind() == 1 || delta.getKind() == 2;
    }

    private boolean hasChildrenChanged(IResourceDelta delta) {
        IResource _resource = delta.getResource();
        if (_resource instanceof IFolder) {
            IResourceDelta[] _affectedChildren;
            IResourceDelta[] iResourceDeltaArray = _affectedChildren = delta.getAffectedChildren();
            int n = _affectedChildren.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta c = iResourceDeltaArray[n2];
                boolean _hasExistsChanged = this.hasExistsChanged(c);
                if (_hasExistsChanged) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean hasCharsetChanged(IResourceDelta delta) {
        return delta.getKind() == 4 && (delta.getFlags() & 0x100000) != 0;
    }

    private boolean hasContentsChanged(IResourceDelta delta) {
        boolean _equals;
        int _kind = delta.getKind();
        boolean bl = _equals = _kind == 4;
        if (_equals) {
            int _flags = delta.getFlags();
            int _bitwiseAnd = _flags & HAS_CONTENTS_CHANGED_FLAGS;
            return _bitwiseAnd != 0;
        }
        return false;
    }

    @Inject
    public void init(IWorkspace workspace) {
        try {
            this.workspace = workspace;
            this.load();
            workspace.addSaveParticipant((Plugin)this.uiPlugin, new ISaveParticipant(){

                public void saving(ISaveContext context) throws CoreException {
                    UIResourceChangeRegistry.this.save();
                }

                public void doneSaving(ISaveContext context) {
                }

                public void prepareToSave(ISaveContext context) throws CoreException {
                }

                public void rollback(ISaveContext context) {
                }
            });
            workspace.addResourceChangeListener((IResourceChangeListener)this, 1);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private synchronized void load() {
        try {
            boolean _not;
            File location = this.getRegistryStateLocation();
            boolean _exists = location.exists();
            boolean bl = _not = !_exists;
            if (_not) {
                this.forgetBuildState();
                return;
            }
            FileInputStream _fileInputStream = new FileInputStream(location);
            BufferedInputStream in = new BufferedInputStream(_fileInputStream);
            try {
                this.readState(in);
            }
            finally {
                in.close();
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                logger.warn((Object)"Could not load resource listener registry, scheduling a full build", (Throwable)e);
                this.forgetBuildState();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public void readState(InputStream in) {
        try {
            DataInputStream reader = new DataInputStream(in);
            for (HashMultimap map : Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new HashMultimap[]{this.existsListeners, this.charsetListeners, this.childrenListeners, this.contentsListeners}))) {
                int urisForExists = reader.readInt();
                int i = 0;
                while (i < urisForExists) {
                    String path = reader.readUTF();
                    String uri = reader.readUTF();
                    URI _createURI = URI.createURI((String)uri);
                    map.put((Object)path, (Object)_createURI);
                    ++i;
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private synchronized void save() {
        try {
            File location = this.getRegistryStateLocation();
            FileOutputStream _fileOutputStream = new FileOutputStream(location);
            BufferedOutputStream out = new BufferedOutputStream(_fileOutputStream);
            try {
                this.writeState(out);
            }
            finally {
                out.close();
            }
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                logger.warn((Object)"Could not save resource listener registry", (Throwable)e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public void writeState(OutputStream out) {
        try {
            DataOutputStream writer = new DataOutputStream(out);
            for (HashMultimap map : Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new HashMultimap[]{this.existsListeners, this.charsetListeners, this.childrenListeners, this.contentsListeners}))) {
                Set entries = map.entries();
                int _size = entries.size();
                writer.writeInt(_size);
                for (Map.Entry entry : entries) {
                    String _key = (String)entry.getKey();
                    writer.writeUTF(_key);
                    URI _value = (URI)entry.getValue();
                    String _string = _value.toString();
                    writer.writeUTF(_string);
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private File getRegistryStateLocation() {
        IPath _stateLocation = this.uiPlugin.getStateLocation();
        IPath _append = _stateLocation.append("resource.change.registry");
        return _append.toFile();
    }

    private void forgetBuildState() {
        IWorkspaceRoot _root = this.workspace.getRoot();
        IProject[] _projects = _root.getProjects();
        Functions.Function1<IProject, Boolean> _function = new Functions.Function1<IProject, Boolean>(){

            public Boolean apply(IProject it) {
                try {
                    return it.isAccessible() && it.hasNature("org.eclipse.xtext.ui.shared.xtextNature") && it.hasNature("org.eclipse.jdt.core.javanature");
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        Iterable projects = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_projects)), (Functions.Function1)_function);
        this.scheduler.scheduleBuildIfNecessary(projects, new IBuildFlag[]{IBuildFlag.FORGET_BUILD_STATE_ONLY});
    }

    @Pure
    public HashMultimap<String, URI> getExistsListeners() {
        return this.existsListeners;
    }

    @Pure
    public HashMultimap<String, URI> getCharsetListeners() {
        return this.charsetListeners;
    }

    @Pure
    public HashMultimap<String, URI> getChildrenListeners() {
        return this.childrenListeners;
    }

    @Pure
    public HashMultimap<String, URI> getContentsListeners() {
        return this.contentsListeners;
    }

    @Pure
    public HashMultimap<String, URI> getChangesNotRelevantListeners() {
        return this.changesNotRelevantListeners;
    }
}

