/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.psystem.rewriters;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExpressionEvaluation;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.IConstraintFilter;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.IVariableRenamer;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.PBodyCopier;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.VariableMappingExpressionEvaluatorWrapper;

class FlattenerCopier
extends PBodyCopier {
    private Map<PositivePatternCall, PBody> callsToFlatten;
    private Table<PositivePatternCall, PVariable, PVariable> variableCopyTable = HashBasedTable.create();

    protected void copyVariable(PositivePatternCall contextPatternCall, PVariable variable, String newName) {
        PVariable newPVariable = this.body.getOrCreateVariableByName(newName);
        this.variableCopyTable.put((Object)contextPatternCall, (Object)variable, (Object)newPVariable);
        this.variableMapping.put(variable, newPVariable);
    }

    public void mergeBody(PositivePatternCall contextPatternCall, IVariableRenamer namingTool, IConstraintFilter filter) {
        PBody sourceBody = this.callsToFlatten.get(contextPatternCall);
        Set<PVariable> allVariables = sourceBody.getAllVariables();
        for (PVariable pVariable : allVariables) {
            if (!pVariable.isUnique()) continue;
            this.copyVariable(contextPatternCall, pVariable, namingTool.createVariableName(pVariable, sourceBody.getPattern()));
        }
        Set<PConstraint> constraints = sourceBody.getConstraints();
        for (PConstraint pConstraint : constraints) {
            if (pConstraint instanceof ExportedParameter || filter.filter(pConstraint)) continue;
            this.copyConstraint(pConstraint);
        }
    }

    public FlattenerCopier(PQuery query, Map<PositivePatternCall, PBody> callsToFlatten) {
        super(query);
        this.callsToFlatten = callsToFlatten;
    }

    @Override
    protected void copyPositivePatternCallConstraint(PositivePatternCall positivePatternCall) {
        if (!this.callsToFlatten.containsKey(positivePatternCall)) {
            super.copyPositivePatternCallConstraint(positivePatternCall);
        } else {
            PBody calledBody = this.callsToFlatten.get(positivePatternCall);
            Preconditions.checkNotNull((Object)calledBody);
            Preconditions.checkArgument((boolean)positivePatternCall.getReferredQuery().equals(calledBody.getPattern()));
            List<PVariable> symbolicParameters = calledBody.getSymbolicParameterVariables();
            Object[] elements = positivePatternCall.getVariablesTuple().getElements();
            int i = 0;
            while (i < elements.length) {
                this.createEqualityConstraint((PVariable)elements[i], symbolicParameters.get(i), positivePatternCall);
                ++i;
            }
        }
    }

    private void createEqualityConstraint(PVariable pVariable1, PVariable pVariable2, PositivePatternCall contextPatternCall) {
        PVariable who = (PVariable)this.variableMapping.get(pVariable1);
        PVariable withWhom = (PVariable)this.variableCopyTable.get((Object)contextPatternCall, (Object)pVariable2);
        this.addTrace(contextPatternCall, new Equality(this.body, who, withWhom));
    }

    @Override
    protected void copyExpressionEvaluationConstraint(final ExpressionEvaluation expressionEvaluation) {
        Map variableMapping = Maps.filterEntries((Map)this.variableMapping, (Predicate)new Predicate<Map.Entry<PVariable, PVariable>>(){

            public boolean apply(Map.Entry<PVariable, PVariable> input) {
                return expressionEvaluation.getPSystem().getAllVariables().contains(input.getKey());
            }
        });
        PVariable mappedOutputVariable = (PVariable)variableMapping.get(expressionEvaluation.getOutputVariable());
        this.addTrace(expressionEvaluation, new ExpressionEvaluation(this.body, new VariableMappingExpressionEvaluatorWrapper(expressionEvaluation.getEvaluator(), variableMapping), mappedOutputVariable));
    }
}

