/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.util;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.util.ICache;
import org.eclipse.viatra.query.runtime.matchers.util.IProvider;

public class PurgableCache
implements ICache {
    Map<Object, Object> storage = new HashMap<Object, Object>();

    @Override
    public <T> T getValue(Object key, Class<? extends T> clazz, IProvider<T> valueProvider) {
        if (this.storage.containsKey(key)) {
            Object value = this.storage.get(key);
            Preconditions.checkState((boolean)clazz.isInstance(value), (String)"Cache stores for key %s a value of %s that is incompatible with the requested type %s", (Object[])new Object[]{key, value, clazz});
            return (T)value;
        }
        T value = valueProvider.get();
        this.storage.put(key, value);
        return value;
    }

    public void purge() {
        this.storage.clear();
    }
}

