/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.apps.admin.web.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.Properties;

public final class AdminConsoleUtil {
    private final String version = this.readServerVersion("lib/.version");

    public String getServerVersion() {
        return this.version;
    }

    public String getOperatingSystem() {
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        return String.format("%s(%s) - %s", os.getName(), os.getArch(), os.getVersion());
    }

    public String getVMDesc() {
        RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
        return String.format("%s(%s) - %s", rt.getVmVendor(), rt.getVmName(), rt.getVmVersion());
    }

    public String getJavaDesc() {
        String vendor = System.getProperty("java.vendor");
        String version = System.getProperty("java.version");
        return String.format("%s - %s", vendor, version);
    }

    public String getUserTimeZone() {
        String timeZone = System.getProperty("user.timezone");
        if (timeZone == null || "".equals(timeZone)) {
            timeZone = "Unavaliable";
        }
        return timeZone;
    }

    private final String readServerVersion(String path) {
        String readVersion;
        File versionFile = new File(path);
        Properties versions = new Properties();
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(versionFile);
            versions.load(stream);
            readVersion = versions.getProperty("virgo.server.version");
            ((InputStream)stream).close();
        }
        catch (IOException iOException) {
            readVersion = "";
            try {
                if (stream != null) {
                    ((InputStream)stream).close();
                }
            }
            catch (IOException iOException2) {}
        }
        return readVersion;
    }
}

