/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth;

import java.io.IOException;
import java.security.KeyPair;
import java.security.interfaces.RSAPublicKey;
import org.apache.sshd.client.UserAuth;
import org.apache.sshd.client.session.ClientSessionImpl;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.Signature;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.util.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAuthPublicKey
implements UserAuth {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public UserAuthPublicKey(ClientSessionImpl session, String username, KeyPair key) throws IOException {
        try {
            this.log.info("Send SSH_MSG_USERAUTH_REQUEST for publickey");
            Buffer buffer = session.createBuffer(SshConstants.Message.SSH_MSG_USERAUTH_REQUEST, 0);
            int pos1 = buffer.wpos() - 1;
            buffer.putString(username);
            buffer.putString("ssh-connection");
            buffer.putString("publickey");
            buffer.putByte((byte)1);
            buffer.putString(key.getPublic() instanceof RSAPublicKey ? "ssh-rsa" : "ssh-dss");
            int pos2 = buffer.wpos();
            buffer.putPublicKey(key.getPublic());
            Signature verif = (Signature)NamedFactory.Utils.create(session.getFactoryManager().getSignatureFactories(), key.getPublic() instanceof RSAPublicKey ? "ssh-rsa" : "ssh-dss");
            verif.init(key.getPublic(), key.getPrivate());
            Buffer bs = new Buffer();
            bs.putString(session.getKex().getH());
            bs.putCommand(SshConstants.Message.SSH_MSG_USERAUTH_REQUEST);
            bs.putString(username);
            bs.putString("ssh-connection");
            bs.putString("publickey");
            bs.putByte((byte)1);
            bs.putString(key.getPublic() instanceof RSAPublicKey ? "ssh-rsa" : "ssh-dss");
            bs.putPublicKey(key.getPublic());
            verif.update(bs.array(), bs.rpos(), bs.available());
            bs = new Buffer();
            bs.putString(key.getPublic() instanceof RSAPublicKey ? "ssh-rsa" : "ssh-dss");
            bs.putBytes(verif.sign());
            buffer.putBytes(bs.array(), bs.rpos(), bs.available());
            session.writePacket(buffer);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw (IOException)new IOException("Error performing public key authentication").initCause(e);
        }
    }

    public UserAuth.Result next(Buffer buffer) throws IOException {
        SshConstants.Message cmd = buffer.getCommand();
        this.log.info("Received {}", (Object)cmd);
        if (cmd == SshConstants.Message.SSH_MSG_USERAUTH_SUCCESS) {
            return UserAuth.Result.Success;
        }
        if (cmd == SshConstants.Message.SSH_MSG_USERAUTH_FAILURE) {
            return UserAuth.Result.Failure;
        }
        return UserAuth.Result.Continued;
    }
}

