/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ajp;

import java.io.IOException;
import org.eclipse.jetty.ajp.Ajp13Connection;
import org.eclipse.jetty.ajp.Ajp13Request;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class Ajp13SocketConnector
extends SocketConnector {
    private static final Logger LOG = Log.getLogger(Ajp13SocketConnector.class);
    static String __secretWord = null;
    static boolean __allowShutdown = false;

    public Ajp13SocketConnector() {
        super.setRequestHeaderSize(8192);
        super.setResponseHeaderSize(8192);
        super.setRequestBufferSize(8192);
        super.setResponseBufferSize(8192);
        super.setMaxIdleTime(0);
    }

    protected void doStart() throws Exception {
        super.doStart();
        LOG.info("AJP13 is not a secure protocol. Please protect port {}", new Object[]{Integer.toString(this.getLocalPort())});
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        super.customize(endpoint, request);
        if (request.isSecure()) {
            request.setScheme("https");
        }
    }

    protected Connection newConnection(EndPoint endpoint) {
        return new Ajp13Connection((Connector)this, endpoint, this.getServer());
    }

    public boolean isConfidential(Request request) {
        return ((Ajp13Request)request).isSslSecure();
    }

    public boolean isIntegral(Request request) {
        return ((Ajp13Request)request).isSslSecure();
    }

    @Deprecated
    public void setHeaderBufferSize(int headerBufferSize) {
        LOG.debug("IGNORED ", new Object[0]);
    }

    public void setRequestBufferSize(int requestBufferSize) {
        LOG.debug("IGNORED ", new Object[0]);
    }

    public void setResponseBufferSize(int responseBufferSize) {
        LOG.debug("IGNORED ", new Object[0]);
    }

    public void setAllowShutdown(boolean allowShutdown) {
        LOG.warn("AJP13: Shutdown Request is: " + allowShutdown, new Object[0]);
        __allowShutdown = allowShutdown;
    }

    public void setSecretWord(String secretWord) {
        LOG.warn("AJP13: Shutdown Request secret word is : " + secretWord, new Object[0]);
        __secretWord = secretWord;
    }
}

