/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import org.eclipse.jetty.client.AbstractHttpConnection;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.AsyncConnection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class AsyncHttpConnection
extends AbstractHttpConnection
implements AsyncConnection {
    private static final Logger LOG = Log.getLogger(AsyncHttpConnection.class);
    private boolean _requestComplete;
    private Buffer _requestContentChunk;
    private final AsyncEndPoint _asyncEndp;

    AsyncHttpConnection(Buffers requestBuffers, Buffers responseBuffers, EndPoint endp) {
        super(requestBuffers, responseBuffers, endp);
        this._asyncEndp = (AsyncEndPoint)endp;
    }

    @Override
    protected void reset() throws IOException {
        this._requestComplete = false;
        super.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Connection handle() throws IOException {
        connection = this;
        progress = true;
        try {
            failed = false;
            while (progress && connection == this) {
                AsyncHttpConnection.LOG.debug("while open={} more={} progress={}", new Object[]{this._endp.isOpen(), this._parser.isMoreInBuffer(), progress});
                progress = false;
                exchange = this._exchange;
                AsyncHttpConnection.LOG.debug("exchange {} on {}", new Object[]{exchange, this});
                try {
                    if (!this._generator.isCommitted() && exchange != null && exchange.getStatus() == 2) {
                        AsyncHttpConnection.LOG.debug("commit {}", new Object[]{exchange});
                        progress = true;
                        this.commitRequest();
                    }
                    if (this._generator.isCommitted() && !this._generator.isComplete()) {
                        if (this._generator.flushBuffer() > 0) {
                            AsyncHttpConnection.LOG.debug("flushed", new Object[0]);
                            progress = true;
                        }
                        if (this._generator.isState(2)) {
                            if (this._requestContentChunk == null) {
                                this._requestContentChunk = exchange.getRequestContentChunk(null);
                            }
                            if (this._requestContentChunk == null) {
                                AsyncHttpConnection.LOG.debug("complete {}", new Object[]{exchange});
                                progress = true;
                                this._generator.complete();
                            } else if (this._generator.isEmpty()) {
                                AsyncHttpConnection.LOG.debug("addChunk", new Object[0]);
                                progress = true;
                                chunk = this._requestContentChunk;
                                this._requestContentChunk = exchange.getRequestContentChunk(null);
                                this._generator.addContent(chunk, this._requestContentChunk == null);
                            }
                        }
                    }
                    if (this._generator.isComplete() && !this._requestComplete) {
                        AsyncHttpConnection.LOG.debug("requestComplete {}", new Object[]{exchange});
                        progress = true;
                        this._requestComplete = true;
                        exchange.getEventListener().onRequestComplete();
                    }
                    if (!this._parser.isComplete() && this._parser.parseAvailable()) {
                        AsyncHttpConnection.LOG.debug("parsed {}", new Object[]{exchange});
                        progress = true;
                    }
                    this._endp.flush();
                    if (this._asyncEndp.hasProgressed()) {
                        AsyncHttpConnection.LOG.debug("hasProgressed {}", new Object[]{exchange});
                        progress = true;
                    }
                    ** GOTO lbl98
                }
                catch (Throwable e) {
                    try {
                        AsyncHttpConnection.LOG.debug("Failure on " + this._exchange, e);
                        failed = true;
                        persistent = this;
                        synchronized (persistent) {
                            if (exchange != null) {
                                if (exchange.getStatus() != 10 && exchange.getStatus() != 11 && !exchange.isDone() && exchange.setStatus(9)) {
                                    exchange.getEventListener().onException(e);
                                }
                            } else {
                                if (e instanceof IOException) {
                                    throw (IOException)e;
                                }
                                if (e instanceof Error) {
                                    throw (Error)e;
                                }
                                if (e instanceof RuntimeException == false) throw new RuntimeException(e);
                                throw (RuntimeException)e;
                            }
                        }
                    }
                    catch (Throwable var12_13) {
                        AsyncHttpConnection.LOG.debug("finally {} on {} progress={} {}", new Object[]{exchange, this, progress, this._endp});
                        complete = failed != false || this._generator.isComplete() != false && this._parser.isComplete() != false;
                        if (complete == false) throw var12_13;
                        persistent = failed == false && this._parser.isPersistent() != false && this._generator.isPersistent() != false;
                        this._generator.setPersistent(persistent);
                        this.reset();
                        if (persistent) {
                            this._endp.setMaxIdleTime((int)this._destination.getHttpClient().getIdleTimeout());
                        }
                        var15_16 = this;
                        synchronized (var15_16) {
                            exchange = this._exchange;
                            this._exchange = null;
                            if (exchange != null) {
                                exchange.cancelTimeout(this._destination.getHttpClient());
                            }
                            if (this._status == 101) {
                                switched = exchange.onSwitchProtocol(this._endp);
                                if (switched != null) {
                                    connection = switched;
                                }
                                this._pipeline = null;
                                if (this._pipeline != null) {
                                    this._destination.send(this._pipeline);
                                }
                                this._pipeline = null;
                                connection = switched;
                            }
                            if (this._pipeline != null) {
                                if (!persistent || connection != this) {
                                    this._destination.send(this._pipeline);
                                } else {
                                    this._exchange = this._pipeline;
                                }
                                this._pipeline = null;
                            }
                            if (this._exchange != null) throw var12_13;
                            if (this.isReserved() != false) throw var12_13;
                            this._destination.returnConnection(this, persistent == false);
                            throw var12_13;
                        }
                    }
lbl98:
                    // 1 sources

                    AsyncHttpConnection.LOG.debug("finally {} on {} progress={} {}", new Object[]{exchange, this, progress, this._endp});
                    complete = failed != false || this._generator.isComplete() != false && this._parser.isComplete() != false;
                    if (!complete) continue;
                    persistent = failed == false && this._parser.isPersistent() != false && this._generator.isPersistent() != false;
                    this._generator.setPersistent(persistent);
                    this.reset();
                    if (persistent) {
                        this._endp.setMaxIdleTime((int)this._destination.getHttpClient().getIdleTimeout());
                    }
                    var7_11 = this;
                    synchronized (var7_11) {
                        exchange = this._exchange;
                        this._exchange = null;
                        if (exchange != null) {
                            exchange.cancelTimeout(this._destination.getHttpClient());
                        }
                        if (this._status == 101) {
                            switched = exchange.onSwitchProtocol(this._endp);
                            if (switched != null) {
                                connection = switched;
                            }
                            this._pipeline = null;
                            if (this._pipeline != null) {
                                this._destination.send(this._pipeline);
                            }
                            this._pipeline = null;
                            connection = switched;
                        }
                        if (this._pipeline != null) {
                            if (!persistent || connection != this) {
                                this._destination.send(this._pipeline);
                            } else {
                                this._exchange = this._pipeline;
                            }
                            this._pipeline = null;
                        }
                        if (this._exchange == null && !this.isReserved()) {
                            this._destination.returnConnection(this, persistent == false);
                        }
                        continue;
                    }
                    AsyncHttpConnection.LOG.debug("finally {} on {} progress={} {}", new Object[]{exchange, this, progress, this._endp});
                    complete = failed != false || this._generator.isComplete() != false && this._parser.isComplete() != false;
                    if (!complete) continue;
                    persistent = failed == false && this._parser.isPersistent() != false && this._generator.isPersistent() != false;
                    this._generator.setPersistent(persistent);
                    this.reset();
                    if (persistent) {
                        this._endp.setMaxIdleTime((int)this._destination.getHttpClient().getIdleTimeout());
                    }
                    var7_11 = this;
                    synchronized (var7_11) {
                        exchange = this._exchange;
                        this._exchange = null;
                        if (exchange != null) {
                            exchange.cancelTimeout(this._destination.getHttpClient());
                        }
                        if (this._status == 101) {
                            switched = exchange.onSwitchProtocol(this._endp);
                            if (switched != null) {
                                connection = switched;
                            }
                            this._pipeline = null;
                            if (this._pipeline != null) {
                                this._destination.send(this._pipeline);
                            }
                            this._pipeline = null;
                            connection = switched;
                        }
                        if (this._pipeline != null) {
                            if (!persistent || connection != this) {
                                this._destination.send(this._pipeline);
                            } else {
                                this._exchange = this._pipeline;
                            }
                            this._pipeline = null;
                        }
                        if (this._exchange == null && !this.isReserved()) {
                            this._destination.returnConnection(this, persistent == false);
                        }
                    }
                }
            }
        }
        catch (Throwable var18_18) {
            this._parser.returnBuffers();
            this._generator.returnBuffers();
            AsyncHttpConnection.LOG.debug("unhandle {} on {}", new Object[]{this._exchange, this._endp});
            throw var18_18;
        }
        this._parser.returnBuffers();
        this._generator.returnBuffers();
        AsyncHttpConnection.LOG.debug("unhandle {} on {}", new Object[]{this._exchange, this._endp});
        return connection;
    }

    public void onInputShutdown() throws IOException {
        if (this._generator.isIdle()) {
            this._endp.shutdownOutput();
        }
    }

    @Override
    public boolean send(HttpExchange ex) throws IOException {
        boolean sent = super.send(ex);
        if (sent) {
            this._asyncEndp.asyncDispatch();
        }
        return sent;
    }
}

