/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.converter.json;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.jolokia.request.ValueFaultHandler;

class ObjectSerializationContext {
    private static final Set<Class> SIMPLE_TYPES = new HashSet<Class>(Arrays.asList(String.class, Number.class, Long.class, Integer.class, Boolean.class, Date.class));
    private Set objectsInCallStack = new HashSet();
    private Stack callStack = new Stack();
    private Integer maxDepth;
    private Integer maxCollectionSize;
    private Integer maxObjects;
    private int objectCount = 0;
    private ValueFaultHandler valueFaultHandler;

    ObjectSerializationContext(Integer pMaxDepth, Integer pMaxCollectionSize, Integer pMaxObjects, ValueFaultHandler pValueFaultHandler) {
        this.maxDepth = pMaxDepth;
        this.maxCollectionSize = pMaxCollectionSize;
        this.maxObjects = pMaxObjects;
        this.valueFaultHandler = pValueFaultHandler;
    }

    boolean alreadyVisited(Object object) {
        return this.objectsInCallStack.contains(object);
    }

    public boolean exceededMaxDepth() {
        return this.maxDepth != null && this.objectsInCallStack.size() > this.maxDepth;
    }

    public boolean exceededMaxObjects() {
        return this.maxObjects != null && this.objectCount > this.maxObjects;
    }

    public Integer getMaxCollectionSize() {
        return this.maxCollectionSize;
    }

    public ValueFaultHandler getValueFaultHandler() {
        return this.valueFaultHandler;
    }

    void push(Object object) {
        this.callStack.push(object);
        if (object != null && !SIMPLE_TYPES.contains(object.getClass())) {
            this.objectsInCallStack.add(object);
        }
        ++this.objectCount;
    }

    Object pop() {
        Object ret = this.callStack.pop();
        if (ret != null && !SIMPLE_TYPES.contains(ret.getClass())) {
            this.objectsInCallStack.remove(ret);
        }
        return ret;
    }
}

