/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee;

import java.lang.reflect.Method;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.openejb.jee.MethodParams;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="named-methodType", propOrder={"methodName", "methodParams"})
public class NamedMethod {
    @XmlElement(name="method-name", required=true)
    protected String methodName;
    @XmlElement(name="method-params")
    protected MethodParams methodParams;
    @XmlTransient
    protected String className;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    protected String id;

    public NamedMethod() {
    }

    public NamedMethod(Method method) {
        this.className = method.getDeclaringClass().getName();
        this.methodName = method.getName();
        MethodParams methodParams = new MethodParams();
        for (Class<?> type : method.getParameterTypes()) {
            methodParams.getMethodParam().add(type.getCanonicalName());
        }
        this.methodParams = methodParams;
    }

    public NamedMethod(String methodName, String ... parameters) {
        this.methodName = methodName;
        if (parameters.length > 0) {
            MethodParams params = new MethodParams();
            for (String paramName : parameters) {
                params.getMethodParam().add(paramName);
            }
            this.methodParams = params;
        }
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String value) {
        this.methodName = value;
    }

    public MethodParams getMethodParams() {
        return this.methodParams;
    }

    public void setMethodParams(MethodParams value) {
        this.methodParams = value;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedMethod that = (NamedMethod)o;
        if (this.methodName != null ? !this.methodName.equals(that.methodName) : that.methodName != null) {
            return false;
        }
        if (this.nullOrEmpty(this.methodParams) && this.nullOrEmpty(that.methodParams)) {
            return true;
        }
        return !(this.methodParams != null ? !this.methodParams.equals(that.methodParams) : that.methodParams != null);
    }

    private boolean nullOrEmpty(MethodParams methodParams) {
        return methodParams == null || methodParams.getMethodParam().size() == 0;
    }

    public int hashCode() {
        int result = this.methodName != null ? this.methodName.hashCode() : 0;
        result = 29 * result + (this.methodParams != null ? this.methodParams.hashCode() : 0);
        return result;
    }
}

