/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.log.internal;

import java.security.Permission;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.log.LogPermission;
import org.eclipse.equinox.log.internal.ExtendedLogReaderServiceFactory;
import org.eclipse.equinox.log.internal.ExtendedLogServiceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public class ExtendedLogServiceFactory
implements ServiceFactory,
BundleListener {
    private final Permission logPermission = new LogPermission("*", "log");
    private final ExtendedLogReaderServiceFactory logReaderServiceFactory;
    private Map logServices = new HashMap();

    public ExtendedLogServiceFactory(ExtendedLogReaderServiceFactory logReaderServiceFactory) {
        this.logReaderServiceFactory = logReaderServiceFactory;
    }

    public Object getService(Bundle bundle, ServiceRegistration registration) {
        return this.getLogService(bundle);
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 16) {
            this.removeLogService(event.getBundle());
        }
    }

    protected synchronized ExtendedLogServiceImpl getLogService(Bundle bundle) {
        if (this.logServices == null) {
            throw new IllegalStateException("LogService is shutdown.");
        }
        ExtendedLogServiceImpl logService = (ExtendedLogServiceImpl)this.logServices.get(bundle);
        if (logService == null) {
            logService = new ExtendedLogServiceImpl(this, bundle);
            if (bundle.getState() != 1) {
                this.logServices.put(bundle, logService);
            }
        }
        return logService;
    }

    protected synchronized void shutdown() {
        if (this.logServices != null) {
            this.logServices.clear();
            this.logServices = null;
        }
    }

    private synchronized void removeLogService(Bundle bundle) {
        if (this.logServices != null) {
            this.logServices.remove(bundle);
        }
    }

    protected boolean isLoggable(Bundle bundle, String name, int level) {
        return this.logReaderServiceFactory.isLoggable(bundle, name, level);
    }

    protected void log(Bundle bundle, String name, Object context, int level, String message, Throwable exception) {
        this.logReaderServiceFactory.log(bundle, name, context, level, message, exception);
    }

    protected void checkLogPermission() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(this.logPermission);
        }
    }
}

