/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import javax.validation.ConstraintDefinitionException;
import org.apache.bval.jsr303.ConstraintAnnotationAttributes;
import org.apache.bval.jsr303.util.SecureActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintDefinitionValidator {
    public static void validateConstraintDefinition(Annotation annotation) {
        ConstraintAnnotationAttributes.GROUPS.validateOn(annotation.annotationType());
        ConstraintAnnotationAttributes.PAYLOAD.validateOn(annotation.annotationType());
        ConstraintAnnotationAttributes.MESSAGE.validateOn(annotation.annotationType());
        ConstraintDefinitionValidator.validAttributes(annotation);
    }

    private static void validAttributes(Annotation annotation) {
        Method[] methods;
        for (Method method : methods = ConstraintDefinitionValidator.run(SecureActions.getDeclaredMethods(annotation.annotationType()))) {
            if (!method.getName().toLowerCase(Locale.ENGLISH).startsWith("valid")) continue;
            throw new ConstraintDefinitionException("A constraint annotation cannot have methods which start with 'valid'");
        }
    }

    private static <T> T run(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return action.run();
    }
}

