/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.medic.management;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.eclipse.virgo.medic.dump.DumpGenerator;
import org.eclipse.virgo.medic.impl.config.ConfigurationProvider;
import org.eclipse.virgo.medic.management.FileSystemDumpInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MedicMBeanExporter {
    private final Logger logger = LoggerFactory.getLogger(MedicMBeanExporter.class);
    private static final String DOMAIN = "org.eclipse.virgo.kernel";
    private final MBeanServer server = ManagementFactory.getPlatformMBeanServer();
    private ObjectInstance registeredMBean;

    public MedicMBeanExporter(ConfigurationProvider configurationProvider, DumpGenerator dumpGenerator) {
        try {
            ObjectName dumpMBeanName = new ObjectName(String.format("%s:type=Medic,name=DumpInspector", DOMAIN));
            this.registeredMBean = this.server.registerMBean(new FileSystemDumpInspector(dumpGenerator, configurationProvider), dumpMBeanName);
        }
        catch (Exception e) {
            this.logger.error("Unable to register the DumpInspectorMBean", (Throwable)e);
        }
    }

    public void close() {
        ObjectInstance localRegisteredMBean = this.registeredMBean;
        if (localRegisteredMBean != null) {
            try {
                this.server.unregisterMBean(localRegisteredMBean.getObjectName());
                this.registeredMBean = null;
            }
            catch (Exception e) {
                this.logger.error("Unable to unregister MBean", (Throwable)e);
            }
        }
    }
}

