/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.converter.json;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.Stack;
import javax.management.AttributeNotFoundException;
import org.jolokia.converter.json.Extractor;
import org.jolokia.converter.json.ObjectToJsonConverter;
import org.jolokia.converter.object.StringToObjectConverter;
import org.json.simple.JSONArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayExtractor
implements Extractor {
    @Override
    public Class getType() {
        return null;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pValue, Stack<String> pExtraArgs, boolean jsonify) throws AttributeNotFoundException {
        int length = pConverter.getCollectionLength(Array.getLength(pValue));
        if (!pExtraArgs.isEmpty()) {
            Object obj = Array.get(pValue, Integer.parseInt(pExtraArgs.pop()));
            return pConverter.extractObject(obj, pExtraArgs, jsonify);
        }
        if (jsonify) {
            JSONArray ret = new JSONArray();
            for (int i = 0; i < length; ++i) {
                Object obj = Array.get(pValue, i);
                ret.add(pConverter.extractObject(obj, pExtraArgs, jsonify));
            }
            return ret;
        }
        return pValue;
    }

    @Override
    public Object setObjectValue(StringToObjectConverter pConverter, Object pInner, String pIndex, Object pValue) throws IllegalAccessException, InvocationTargetException {
        int idx;
        Class<?> clazz = pInner.getClass();
        if (!clazz.isArray()) {
            throw new IllegalArgumentException("Not an array to set a value, but " + clazz + ". (index = " + pIndex + ", value = " + pValue + ")");
        }
        try {
            idx = Integer.parseInt(pIndex);
        }
        catch (NumberFormatException exp) {
            throw new IllegalArgumentException("Non-numeric index for accessing array " + pInner + ". (index = " + pIndex + ", value to set = " + pValue + ")", exp);
        }
        Class<?> type = clazz.getComponentType();
        Object value = pConverter.prepareValue(type.getName(), pValue);
        Object oldValue = Array.get(pInner, idx);
        Array.set(pInner, idx, value);
        return oldValue;
    }

    @Override
    public boolean canSetValue() {
        return true;
    }
}

