/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.handler;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.xml.namespace.QName;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.context.PortletContextAware;

public class SimplePortletPostProcessor
implements DestructionAwareBeanPostProcessor,
PortletContextAware,
PortletConfigAware {
    private boolean useSharedPortletConfig = true;
    private PortletContext portletContext;
    private PortletConfig portletConfig;

    public void setUseSharedPortletConfig(boolean useSharedPortletConfig) {
        this.useSharedPortletConfig = useSharedPortletConfig;
    }

    @Override
    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }

    @Override
    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof Portlet) {
            PortletConfig config = this.portletConfig;
            if (config == null || !this.useSharedPortletConfig) {
                config = new DelegatingPortletConfig(beanName, this.portletContext, this.portletConfig);
            }
            try {
                ((Portlet)bean).init(config);
            }
            catch (PortletException ex) {
                throw new BeanInitializationException("Portlet.init threw exception", (Throwable)ex);
            }
        }
        return bean;
    }

    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
        if (bean instanceof Portlet) {
            ((Portlet)bean).destroy();
        }
    }

    private static class DelegatingPortletConfig
    implements PortletConfig {
        private final String portletName;
        private final PortletContext portletContext;
        private final PortletConfig portletConfig;

        public DelegatingPortletConfig(String portletName, PortletContext portletContext, PortletConfig portletConfig) {
            this.portletName = portletName;
            this.portletContext = portletContext;
            this.portletConfig = portletConfig;
        }

        public String getPortletName() {
            return this.portletName;
        }

        public PortletContext getPortletContext() {
            return this.portletContext;
        }

        public String getInitParameter(String paramName) {
            return null;
        }

        public Enumeration<String> getInitParameterNames() {
            return Collections.enumeration(new HashSet());
        }

        public ResourceBundle getResourceBundle(Locale locale) {
            return this.portletConfig != null ? this.portletConfig.getResourceBundle(locale) : null;
        }

        public Enumeration<String> getPublicRenderParameterNames() {
            return Collections.enumeration(new HashSet());
        }

        public String getDefaultNamespace() {
            return "";
        }

        public Enumeration<QName> getPublishingEventQNames() {
            return Collections.enumeration(new HashSet());
        }

        public Enumeration<QName> getProcessingEventQNames() {
            return Collections.enumeration(new HashSet());
        }

        public Enumeration<Locale> getSupportedLocales() {
            return Collections.enumeration(new HashSet());
        }

        public Map<String, String[]> getContainerRuntimeOptions() {
            return this.portletConfig != null ? this.portletConfig.getContainerRuntimeOptions() : null;
        }
    }
}

