/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.management.console;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.virgo.management.console.Activator;
import org.eclipse.virgo.management.console.internal.ContentURLFetcher;
import org.eclipse.virgo.management.console.internal.GZIPResponseStream;
import org.eclipse.virgo.management.console.internal.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(ContentServlet.class);
    private static final long serialVersionUID = 1L;
    private static final String HTTP_CONTENT_LENGTH_HEADER = "Content-Length";
    private static final String HTTP_LAST_MODIFIED_HEADER = "Last-Modified";
    private static final String HTTP_EXPIRES_HEADER = "Expires";
    private static final String HTTP_CACHE_CONTROL_HEADER = "Cache-Control";
    protected static final String CONTENT_SERVLET_PREFIX = "prefix";
    protected static final String CONTENT_SERVLET_SUFFIX = "suffix";
    private final MBeanServer server = ManagementFactory.getPlatformMBeanServer();
    private boolean gzipEnabled = true;
    private int cacheTimeout = 60;
    private ContentURLFetcher urlFetcher;
    private Map<String, String> defaultMimeTypes = new HashMap();
    private Set<String> compressedMimeTypes;

    public ContentServlet() {
        this.defaultMimeTypes.put(".html", "text/html");
        this.defaultMimeTypes.put(".htm", "text/html");
        this.defaultMimeTypes.put(".xhtml", "text/html");
        this.compressedMimeTypes = new HashSet();
        this.compressedMimeTypes.add("text/.*");
        this.compressedMimeTypes.add(".*/xhtml.xml");
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String prefix = config.getInitParameter(CONTENT_SERVLET_PREFIX);
        String suffix = config.getInitParameter(CONTENT_SERVLET_SUFFIX);
        this.urlFetcher = new ContentURLFetcher(config.getServletContext(), prefix, suffix);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        URL resource;
        String rawRequestPath = this.getRequestPath(request);
        if (log.isDebugEnabled()) {
            log.debug("Attempting to GET content: " + rawRequestPath);
        }
        if ((resource = this.urlFetcher.getRequestedContentURL(rawRequestPath)) == null) {
            if (log.isDebugEnabled()) {
                log.debug("Content not found: " + rawRequestPath);
            }
            response.sendError(404);
            return;
        }
        this.prepareContentResponse(response, resource);
        PrintWriter out = this.selectOutputStream(request, response, resource);
        URLConnection resourceConn = resource.openConnection();
        try (InputStream in = resourceConn.getInputStream();){
            HashMap pageContext = new HashMap();
            this.preparePageContext(pageContext, rawRequestPath);
            new Parser(out, this.urlFetcher, pageContext).parse(in);
        }
        finally {
            out.close();
        }
    }

    private PrintWriter selectOutputStream(HttpServletRequest request, HttpServletResponse response, URL resource) throws IOException {
        String mimeType;
        String acceptEncoding = request.getHeader("Accept-Encoding");
        try {
            mimeType = response.getContentType();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            mimeType = this.getResponseMimeType(resource);
        }
        if (this.gzipEnabled && acceptEncoding != null && acceptEncoding.indexOf("gzip") > -1 && this.matchesCompressedMimeTypes(mimeType)) {
            log.debug("Enabling GZIP compression for the current response.");
            return new PrintWriter((OutputStream)new GZIPResponseStream(response));
        }
        return response.getWriter();
    }

    private boolean matchesCompressedMimeTypes(String mimeType) {
        for (String compressedMimeType : this.compressedMimeTypes) {
            if (!mimeType.matches(compressedMimeType)) continue;
            return true;
        }
        return false;
    }

    private void prepareContentResponse(HttpServletResponse response, URL resource) throws IOException {
        URLConnection resourceConn = resource.openConnection();
        response.setContentType(this.getResponseMimeType(resource));
        response.setHeader(HTTP_CONTENT_LENGTH_HEADER, Long.toString(resourceConn.getContentLength()));
        response.setDateHeader(HTTP_LAST_MODIFIED_HEADER, resourceConn.getLastModified());
        if (this.cacheTimeout > 0) {
            this.configureCaching(response, this.cacheTimeout);
        }
    }

    private String getResponseMimeType(URL resource) {
        String extension = resource.getPath().substring(resource.getPath().lastIndexOf(46));
        String mimeType = (String)this.defaultMimeTypes.get(extension);
        if (mimeType == null) {
            mimeType = this.getServletContext().getMimeType(resource.getPath());
        }
        return mimeType;
    }

    private void preparePageContext(Map<String, String> pageContext, String rawRequestPath) {
        String viewName = rawRequestPath;
        if ('/' == viewName.charAt(0)) {
            viewName = viewName.substring(1);
        }
        ArrayList menuItems = new ArrayList();
        this.addIfMbeanPresent(menuItems, "artifacts", "org.eclipse.virgo.kernel:type=ArtifactModel,artifact-type=*,*");
        this.addIfMbeanPresent(menuItems, "repositories", "org.eclipse.virgo.kernel:type=Repository,name=*");
        this.addIfMbeanPresent(menuItems, "wirings", "osgi.core:version=1.0,type=wiringState,region=*");
        this.addIfMbeanPresent(menuItems, "dumps", "org.eclipse.virgo.kernel:type=Medic,name=DumpInspector");
        this.addIfMbeanPresent(menuItems, "configurations", "osgi.compendium:service=cm,version=1.3,region=*");
        this.addIfMbeanPresent(menuItems, "logging", "ch.qos.logback.classic:Name=default,Type=ch.qos.logback.classic.jmx.JMXConfigurator");
        String stringArray = Arrays.toString(menuItems.toArray(new String[menuItems.size()]));
        pageContext.put("menuNames", stringArray.substring(1, stringArray.length() - 1));
        pageContext.put("viewName", viewName);
        ServletContext servletContext = this.getServletContext();
        try {
            if (servletContext.getContextPath().isEmpty()) {
                pageContext.put("contextPath", Activator.contextPath);
                pageContext.put("servletContextName", "Virgo Admin Console");
            } else {
                pageContext.put("contextPath", servletContext.getContextPath());
                pageContext.put("servletContextName", servletContext.getServletContextName());
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            pageContext.put("contextPath", Activator.contextPath);
            pageContext.put("servletContextName", "Virgo Admin Console");
        }
        pageContext.put("servletContainer", servletContext.getServerInfo());
        pageContext.put("virtualMachine", String.format("%s - %s %s (%s)", System.getProperty("java.version"), System.getProperty("java.vm.name"), System.getProperty("java.vm.version"), System.getProperty("java.vm.vendor")));
        pageContext.put("operatingSystem", String.format("%s %s (%s)", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch")));
    }

    private void addIfMbeanPresent(List<String> menuItems, String viewName, String objectName) {
        try {
            ObjectName objectNameImpl = new ObjectName(objectName);
            if (objectNameImpl.isPattern()) {
                Set<ObjectName> queryNames = this.server.queryNames(objectNameImpl, null);
                if (queryNames.size() > 0) {
                    menuItems.add(viewName);
                }
            } else if (this.server.isRegistered(objectNameImpl)) {
                menuItems.add(viewName);
            }
        }
        catch (Exception e) {
            this.log("Error checking for MBean required for Admin Console Page" + objectName, (Throwable)e);
        }
    }

    protected long getLastModified(HttpServletRequest request) {
        URL resource;
        String rawRequestPath = this.getRequestPath(request);
        if (log.isDebugEnabled()) {
            log.debug("Checking last modified of content: " + rawRequestPath);
        }
        try {
            resource = this.urlFetcher.getRequestedContentURL(rawRequestPath);
        }
        catch (MalformedURLException malformedURLException) {
            return -1L;
        }
        if (resource == null) {
            return -1L;
        }
        try {
            return resource.openConnection().getLastModified();
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    private String getRequestPath(HttpServletRequest request) {
        String rawRequestPath = request.getPathInfo();
        if (rawRequestPath == null) {
            rawRequestPath = "/overview";
        }
        return rawRequestPath;
    }

    private void configureCaching(HttpServletResponse response, int seconds) {
        response.setDateHeader(HTTP_EXPIRES_HEADER, System.currentTimeMillis() + (long)seconds * 1000L);
        response.setHeader(HTTP_CACHE_CONTROL_HEADER, "max-age=" + seconds);
    }
}

