/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.model.internal.deployer;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.equinox.region.Region;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.model.ArtifactState;
import org.eclipse.virgo.kernel.model.internal.AbstractArtifact;
import org.eclipse.virgo.nano.core.AbortableSignal;
import org.eclipse.virgo.nano.core.BlockingAbortableSignal;
import org.eclipse.virgo.nano.core.FailureSignalledException;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.nano.serviceability.enforcement.NonNullAssertionEnforcer;
import org.osgi.framework.BundleContext;

class DeployerArtifact
extends AbstractArtifact {
    private final InstallArtifact installArtifact;

    public DeployerArtifact(@NonNull BundleContext bundleContext, @NonNull InstallArtifact installArtifact, Region region) {
        InstallArtifact installArtifact2 = installArtifact;
        BundleContext bundleContext2 = bundleContext;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)bundleContext2);
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_nano_serviceability_enforcement_NonNullAssertionEnforcer$2$ea5bfc82((Object)installArtifact2);
        super(bundleContext, installArtifact.getType(), installArtifact.getName(), installArtifact.getVersion(), region);
        try {
            this.installArtifact = installArtifact;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public final ArtifactState getState() {
        try {
            return this.mapInstallArtifactState(this.installArtifact.getState());
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public final void start() {
        try {
            try {
                BlockingAbortableSignal signal = new BlockingAbortableSignal();
                this.installArtifact.start((AbortableSignal)signal);
                try {
                    if (!signal.awaitCompletion(5L, TimeUnit.MINUTES)) {
                        if (signal.isAborted()) {
                            throw new RuntimeException("Started aborted");
                        }
                        throw new RuntimeException("Started failed");
                    }
                }
                catch (FailureSignalledException fse) {
                    throw new RuntimeException(fse.getCause());
                }
            }
            catch (DeploymentException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public final void stop() {
        try {
            try {
                this.installArtifact.stop();
            }
            catch (DeploymentException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public final void uninstall() {
        try {
            try {
                this.installArtifact.uninstall();
            }
            catch (DeploymentException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public final boolean refresh() {
        try {
            try {
                return this.installArtifact.refresh();
            }
            catch (DeploymentException e) {
                throw new RuntimeException(e);
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public Map<String, String> getProperties() {
        try {
            Set propertyNames = this.installArtifact.getPropertyNames();
            HashMap<String, String> result = new HashMap<String, String>(propertyNames.size());
            for (String propertyName : propertyNames) {
                String propertyValue = this.installArtifact.getProperty(propertyName);
                if (propertyValue == null) continue;
                result.put(propertyName, propertyValue);
            }
            return Collections.unmodifiableMap(result);
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private ArtifactState mapInstallArtifactState(InstallArtifact.State state) {
        try {
            if (InstallArtifact.State.INITIAL == state) {
                return ArtifactState.INITIAL;
            }
            if (InstallArtifact.State.INSTALLING == state) {
                return ArtifactState.INSTALLING;
            }
            if (InstallArtifact.State.INSTALLED == state) {
                return ArtifactState.INSTALLED;
            }
            if (InstallArtifact.State.RESOLVING == state) {
                return ArtifactState.RESOLVING;
            }
            if (InstallArtifact.State.RESOLVED == state) {
                return ArtifactState.RESOLVED;
            }
            if (InstallArtifact.State.STARTING == state) {
                return ArtifactState.STARTING;
            }
            if (InstallArtifact.State.ACTIVE == state) {
                return ArtifactState.ACTIVE;
            }
            if (InstallArtifact.State.STOPPING == state) {
                return ArtifactState.STOPPING;
            }
            if (InstallArtifact.State.UNINSTALLING == state) {
                return ArtifactState.UNINSTALLING;
            }
            return ArtifactState.UNINSTALLED;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }
}

