/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.utils;

import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class EventSender {
    public static final String DEPLOYING_EVENT = "org/osgi/service/web/DEPLOYING";
    public static final String DEPLOYED_EVENT = "org/osgi/service/web/DEPLOYED";
    public static final String UNDEPLOYING_EVENT = "org/osgi/service/web/UNDEPLOYING";
    public static final String UNDEPLOYED_EVENT = "org/osgi/service/web/UNDEPLOYED";
    public static final String FAILED_EVENT = "org/osgi/service/web/FAILED";
    private static final EventSender __instance = new EventSender();
    private Bundle _myBundle = FrameworkUtil.getBundle(EventSender.class);
    private EventAdmin _eventAdmin;

    private EventSender() {
        ServiceReference ref = this._myBundle.getBundleContext().getServiceReference(EventAdmin.class.getName());
        if (ref != null) {
            this._eventAdmin = (EventAdmin)this._myBundle.getBundleContext().getService(ref);
        }
    }

    public static EventSender getInstance() {
        return __instance;
    }

    public void send(String topic, Bundle wab, String contextPath) {
        if (topic == null || wab == null || contextPath == null) {
            return;
        }
        this.send(topic, wab, contextPath, null);
    }

    public void send(String topic, Bundle wab, String contextPath, Exception ex) {
        if (this._eventAdmin == null) {
            return;
        }
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("bundle.symbolicName", wab.getSymbolicName());
        ((Dictionary)props).put("bundle.id", wab.getBundleId());
        ((Dictionary)props).put("bundle", wab);
        ((Dictionary)props).put("bundle.version", wab.getVersion());
        ((Dictionary)props).put("context.path", contextPath);
        ((Dictionary)props).put("timestamp", System.currentTimeMillis());
        ((Dictionary)props).put("extender.bundle", this._myBundle);
        ((Dictionary)props).put("extender.bundle.symbolicName", this._myBundle.getSymbolicName());
        ((Dictionary)props).put("extender.bundle.id", this._myBundle.getBundleId());
        ((Dictionary)props).put("extender.bundle.version", this._myBundle.getVersion());
        if (FAILED_EVENT.equalsIgnoreCase(topic) && ex != null) {
            ((Dictionary)props).put("exception", ex);
        }
        this._eventAdmin.sendEvent(new Event(topic, props));
    }
}

