/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.agent.dm.internal;

import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.virgo.kernel.agent.dm.internal.AgentLogEvents;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

final class DeployerFailureListener
implements EventHandler {
    private static final String FAILURE_TOPIC = "org/osgi/service/blueprint/container/FAILURE";
    private final EventLogger eventLogger;
    private volatile RegionDigraph regionDigraph;
    private volatile Region agentRegion;

    public DeployerFailureListener(EventLogger eventLogger) {
        this.eventLogger = eventLogger;
    }

    public void handleEvent(Event event) {
        if (FAILURE_TOPIC.equals(event.getTopic())) {
            Throwable failure = (Throwable)event.getProperty("exception");
            Bundle bundle = (Bundle)event.getProperty("bundle");
            if (this.inThisRegion(bundle)) {
                this.eventLogger.log((LogEvent)AgentLogEvents.BUNDLE_CONTEXT_FAILED, failure, new Object[]{bundle.getSymbolicName(), bundle.getVersion().toString()});
            }
        }
    }

    private boolean inThisRegion(Bundle bundle) {
        Bundle agentBundle;
        BundleContext bundleContext;
        ServiceReference regionMembershipServiceReference;
        if (this.regionDigraph == null && (regionMembershipServiceReference = (bundleContext = (agentBundle = FrameworkUtil.getBundle(this.getClass())).getBundleContext()).getServiceReference(RegionDigraph.class)) != null) {
            this.regionDigraph = (RegionDigraph)bundleContext.getService(regionMembershipServiceReference);
            this.agentRegion = this.getRegion(agentBundle);
        }
        return this.regionDigraph != null ? this.getRegion(bundle).equals(this.agentRegion) : true;
    }

    private Region getRegion(Bundle bundle) {
        for (Region region : this.regionDigraph) {
            if (!region.contains(bundle)) continue;
            return region;
        }
        return null;
    }
}

