/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component.behavior;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponentBase;
import javax.faces.component.behavior.ClientBehaviorBase;
import javax.faces.component.behavior.ClientBehaviorHint;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxBehavior
extends ClientBehaviorBase {
    public static final String BEHAVIOR_ID = "javax.faces.behavior.Ajax";
    private static final Set<ClientBehaviorHint> HINTS = Collections.unmodifiableSet(EnumSet.of(ClientBehaviorHint.SUBMITTING));
    private String onerror;
    private String onevent;
    private List<String> execute;
    private List<String> render;
    private Boolean disabled;
    private Boolean immediate;
    private Map<String, ValueExpression> bindings;
    private static final String ONEVENT = "onevent";
    private static final String ONERROR = "onerror";
    private static final String IMMEDIATE = "immediate";
    private static final String DISABLED = "disabled";
    private static final String EXECUTE = "execute";
    private static final String RENDER = "render";
    private static String ALL = "@all";
    private static String FORM = "@form";
    private static String THIS = "@this";
    private static String NONE = "@none";
    private static List<String> ALL_LIST = Collections.singletonList("@all");
    private static List<String> FORM_LIST = Collections.singletonList("@form");
    private static List<String> THIS_LIST = Collections.singletonList("@this");
    private static List<String> NONE_LIST = Collections.singletonList("@none");
    private static Pattern SPLIT_PATTERN = Pattern.compile(" ");

    @Override
    public String getRendererType() {
        return BEHAVIOR_ID;
    }

    @Override
    public Set<ClientBehaviorHint> getHints() {
        return HINTS;
    }

    public String getOnerror() {
        return (String)this.eval(ONERROR, this.onerror);
    }

    public void setOnerror(String onerror) {
        this.onerror = onerror;
        this.clearInitialState();
    }

    public String getOnevent() {
        return (String)this.eval(ONEVENT, this.onevent);
    }

    public void setOnevent(String onevent) {
        this.onevent = onevent;
        this.clearInitialState();
    }

    public Collection<String> getExecute() {
        return this.getCollectionValue(EXECUTE, this.execute);
    }

    public void setExecute(Collection<String> execute) {
        this.execute = this.copyToList(execute);
        this.clearInitialState();
    }

    public Collection<String> getRender() {
        return this.getCollectionValue(RENDER, this.render);
    }

    public void setRender(Collection<String> render) {
        this.render = this.copyToList(render);
        this.clearInitialState();
    }

    public boolean isDisabled() {
        Boolean result = (Boolean)this.eval(DISABLED, this.disabled);
        return result != null ? result : false;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
        this.clearInitialState();
    }

    public boolean isImmediate() {
        Boolean result = (Boolean)this.eval(IMMEDIATE, this.immediate);
        return result != null ? result : false;
    }

    public void setImmediate(boolean immediate) {
        this.immediate = immediate;
        this.clearInitialState();
    }

    public boolean isImmediateSet() {
        return this.immediate != null || this.getValueExpression(IMMEDIATE) != null;
    }

    public ValueExpression getValueExpression(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return this.bindings == null ? null : this.bindings.get(name);
    }

    public void setValueExpression(String name, ValueExpression binding) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (binding != null) {
            if (binding.isLiteralText()) {
                this.setLiteralValue(name, binding);
            } else {
                if (this.bindings == null) {
                    this.bindings = new HashMap<String, ValueExpression>(6, 1.0f);
                }
                this.bindings.put(name, binding);
            }
        } else if (this.bindings != null) {
            this.bindings.remove(name);
            if (this.bindings.isEmpty()) {
                this.bindings = null;
            }
        }
        this.clearInitialState();
    }

    public void addAjaxBehaviorListener(AjaxBehaviorListener listener) {
        this.addBehaviorListener(listener);
    }

    public void removeAjaxBehaviorListener(AjaxBehaviorListener listener) {
        this.removeBehaviorListener(listener);
    }

    @Override
    public Object saveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object superState = super.saveState(context);
        Object values = this.initialStateMarked() ? (superState == null ? null : new Object[]{superState}) : new Object[]{superState, this.onerror, this.onevent, this.disabled, this.immediate, AjaxBehavior.saveList(this.execute), AjaxBehavior.saveList(this.render), AjaxBehavior.saveBindings(context, this.bindings)};
        return values;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (state != null) {
            Object[] values = (Object[])state;
            super.restoreState(context, values[0]);
            if (values.length != 1) {
                this.onerror = (String)values[1];
                this.onevent = (String)values[2];
                this.disabled = (Boolean)values[3];
                this.immediate = (Boolean)values[4];
                this.execute = AjaxBehavior.restoreList(EXECUTE, values[5]);
                this.render = AjaxBehavior.restoreList(RENDER, values[6]);
                this.bindings = AjaxBehavior.restoreBindings(context, values[7]);
                this.clearInitialState();
            }
        }
    }

    private static Object saveBindings(FacesContext context, Map<String, ValueExpression> bindings) {
        if (bindings == null) {
            return null;
        }
        Object[] values = new Object[2];
        values[0] = bindings.keySet().toArray(new String[bindings.size()]);
        Object[] bindingValues = bindings.values().toArray();
        for (int i = 0; i < bindingValues.length; ++i) {
            bindingValues[i] = UIComponentBase.saveAttachedState(context, bindingValues[i]);
        }
        values[1] = bindingValues;
        return values;
    }

    private static Map<String, ValueExpression> restoreBindings(FacesContext context, Object state) {
        if (state == null) {
            return null;
        }
        Object[] values = (Object[])state;
        String[] names = (String[])values[0];
        Object[] states = (Object[])values[1];
        HashMap<String, ValueExpression> bindings = new HashMap<String, ValueExpression>(names.length);
        for (int i = 0; i < names.length; ++i) {
            bindings.put(names[i], (ValueExpression)UIComponentBase.restoreAttachedState(context, states[i]));
        }
        return bindings;
    }

    private static Object saveList(List<String> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        int size = list.size();
        if (size == 1) {
            return list.get(0);
        }
        return list.toArray(new String[size]);
    }

    private static List<String> restoreList(String propertyName, Object state) {
        if (state == null) {
            return null;
        }
        List<String> list = null;
        if (state instanceof String) {
            list = AjaxBehavior.toSingletonList(propertyName, (String)state);
        } else if (state instanceof String[]) {
            list = Collections.unmodifiableList(Arrays.asList((String[])state));
        }
        return list;
    }

    private Object eval(String propertyName, Object value) {
        if (value != null) {
            return value;
        }
        ValueExpression expression = this.getValueExpression(propertyName);
        if (expression != null) {
            FacesContext ctx = FacesContext.getCurrentInstance();
            return expression.getValue(ctx.getELContext());
        }
        return null;
    }

    private Collection<String> getCollectionValue(String propertyName, Collection<String> collection) {
        FacesContext ctx;
        Object value;
        if (collection != null) {
            return collection;
        }
        List<String> result = null;
        ValueExpression expression = this.getValueExpression(propertyName);
        if (expression != null && (value = expression.getValue((ctx = FacesContext.getCurrentInstance()).getELContext())) != null) {
            if (value instanceof Collection) {
                return (Collection)value;
            }
            result = AjaxBehavior.toList(propertyName, expression, value);
        }
        return result == null ? Collections.emptyList() : result;
    }

    private void setLiteralValue(String propertyName, ValueExpression expression) {
        Object value;
        assert (expression.isLiteralText());
        ELContext context = FacesContext.getCurrentInstance().getELContext();
        try {
            value = expression.getValue(context);
        }
        catch (ELException ele) {
            throw new FacesException(ele);
        }
        if (ONEVENT.equals(propertyName)) {
            this.onevent = (String)value;
        } else if (ONERROR.equals(propertyName)) {
            this.onerror = (String)value;
        } else if (IMMEDIATE.equals(propertyName)) {
            this.immediate = (Boolean)value;
        } else if (DISABLED.equals(propertyName)) {
            this.disabled = (Boolean)value;
        } else if (EXECUTE.equals(propertyName)) {
            this.execute = AjaxBehavior.toList(propertyName, expression, value);
        } else if (RENDER.equals(propertyName)) {
            this.render = AjaxBehavior.toList(propertyName, expression, value);
        }
    }

    private static List<String> toList(String propertyName, ValueExpression expression, Object value) {
        if (value instanceof String) {
            String strValue = (String)value;
            if (strValue.indexOf(32) == -1) {
                return AjaxBehavior.toSingletonList(propertyName, strValue);
            }
            String[] values = SPLIT_PATTERN.split(strValue);
            if (values == null || values.length == 0) {
                return null;
            }
            return Collections.unmodifiableList(Arrays.asList(values));
        }
        throw new FacesException(expression.toString() + " : '" + propertyName + "' attribute value must be either a String or a Collection");
    }

    private static List<String> toSingletonList(String propertyName, String value) {
        if (null == value || value.length() == 0) {
            return null;
        }
        if (value.charAt(0) == '@') {
            List<String> list;
            if (ALL.equals(value)) {
                list = ALL_LIST;
            } else if (FORM.equals(value)) {
                list = FORM_LIST;
            } else if (THIS.equals(value)) {
                list = THIS_LIST;
            } else if (NONE.equals(value)) {
                list = NONE_LIST;
            } else {
                throw new FacesException(value + " : Invalid id keyword specified for '" + propertyName + "' attribute");
            }
            return list;
        }
        return Collections.singletonList(value);
    }

    private List<String> copyToList(Collection<String> collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        return Collections.unmodifiableList(new ArrayList<String>(collection));
    }
}

