/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm.datasource;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import org.enhydra.jdbc.pool.StandardXAPoolDataSource;
import org.enhydra.jdbc.standard.StandardXADataSource;
import org.objectweb.jotm.Jotm;
import org.objectweb.transaction.jta.TMService;

public class DataSourceFactory
implements ObjectFactory {
    private static Hashtable table = new Hashtable();
    public static TMService jotm;

    public Object getObjectInstance(Object obj, Name n, Context nameCtx, Hashtable environment) throws Exception {
        StandardXAPoolDataSource xads = null;
        StandardXADataSource ds = null;
        try {
            Reference ref = (Reference)obj;
            ds = new StandardXADataSource();
            xads = new StandardXAPoolDataSource(ds);
            Enumeration<RefAddr> addrs = ref.getAll();
            while (addrs.hasMoreElements()) {
                RefAddr addr = addrs.nextElement();
                String name = addr.getType();
                String value = (String)addr.getContent();
                if (name.equals("driverClassName")) {
                    ds.setDriverName(value);
                    continue;
                }
                if (name.equals("url")) {
                    ds.setUrl(value);
                    continue;
                }
                if (name.equals("username")) {
                    xads.user = value;
                    ds.setUser(value);
                    continue;
                }
                if (name.equals("password")) {
                    ds.setPassword(value);
                    xads.password = value;
                    continue;
                }
                if (name.equals("min")) {
                    try {
                        int min = Integer.parseInt(value);
                        xads.setMinSize(min);
                    }
                    catch (NumberFormatException e) {}
                    continue;
                }
                if (name.equals("max")) {
                    try {
                        int max = Integer.parseInt(value);
                        xads.setMaxSize(max);
                    }
                    catch (NumberFormatException e) {}
                    continue;
                }
                if (name.equals("testStmt")) {
                    xads.setJdbcTestStmt(value);
                    continue;
                }
                if (name.equals("checkLevel")) {
                    try {
                        int max = Integer.parseInt(value);
                        xads.setCheckLevelObject(max);
                    }
                    catch (NumberFormatException e) {}
                    continue;
                }
                if (!name.equals("maxWait")) continue;
                try {
                    int max = Integer.parseInt(value);
                    xads.setDeadLockMaxWait((long)max);
                }
                catch (NumberFormatException e) {}
            }
            xads.setTransactionManager((TransactionManager)jotm.getTransactionManager());
            xads.setDataSource((XADataSource)ds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (table.containsKey(ds)) {
            return table.get(ds);
        }
        table.put(ds, xads);
        return xads;
    }

    static {
        try {
            jotm = new Jotm(true, false);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }
}

