/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.bval.model.ValidationContext;
import org.apache.bval.model.ValidationListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationResults
implements ValidationListener,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, List<ValidationListener.Error>> errorsByReason;
    private Map<Object, Map<String, List<ValidationListener.Error>>> errorsByOwner;

    @Override
    public <T extends ValidationListener> void addError(String reason, ValidationContext<T> context) {
        ValidationListener.Error error = this.createError(reason, context.getBean(), context.getPropertyName());
        this.addError(error, context);
    }

    @Override
    public <T extends ValidationListener> void addError(ValidationListener.Error error, ValidationContext<T> context) {
        if (this.errorsByReason == null) {
            this.initialize();
        }
        this.addToReasonBucket(error);
        this.addToOwnerBucket(error);
    }

    public void addError(String reason, Object bean, String propertyName) {
        this.addError(this.createError(reason, bean, propertyName), null);
    }

    protected ValidationListener.Error createError(String reason, Object owner, String propertyName) {
        return new ValidationListener.Error(reason, owner, propertyName);
    }

    protected void initialize() {
        this.errorsByReason = new LinkedHashMap<String, List<ValidationListener.Error>>();
        this.errorsByOwner = new LinkedHashMap<Object, Map<String, List<ValidationListener.Error>>>();
    }

    protected void addToReasonBucket(ValidationListener.Error error) {
        if (error.getReason() == null) {
            return;
        }
        List<ValidationListener.Error> errors = this.errorsByReason.get(error.getReason());
        if (errors == null) {
            errors = new ArrayList<ValidationListener.Error>();
            this.errorsByReason.put(error.getReason(), errors);
        }
        errors.add(error);
    }

    protected void addToOwnerBucket(ValidationListener.Error error) {
        List<ValidationListener.Error> list;
        if (error.getOwner() == null) {
            return;
        }
        Map<String, List<ValidationListener.Error>> errors = this.errorsByOwner.get(error.getOwner());
        if (errors == null) {
            errors = new HashMap<String, List<ValidationListener.Error>>();
            this.errorsByOwner.put(error.getOwner(), errors);
        }
        if ((list = errors.get(error.getPropertyName())) == null) {
            list = new ArrayList<ValidationListener.Error>();
            errors.put(error.getPropertyName(), list);
        }
        list.add(error);
    }

    public Map<String, List<ValidationListener.Error>> getErrorsByReason() {
        if (this.errorsByReason == null) {
            return Collections.emptyMap();
        }
        return this.errorsByReason;
    }

    public Map<Object, Map<String, List<ValidationListener.Error>>> getErrorsByOwner() {
        if (this.errorsByOwner == null) {
            return Collections.emptyMap();
        }
        return this.errorsByOwner;
    }

    public boolean isEmpty() {
        if (this.errorsByReason == null || this.errorsByReason.isEmpty() && this.errorsByOwner.isEmpty()) {
            return true;
        }
        for (List<ValidationListener.Error> list : this.errorsByReason.values()) {
            if (list.isEmpty()) continue;
            return false;
        }
        for (Map map : this.errorsByOwner.values()) {
            for (List list : map.values()) {
                if (list.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean hasErrorForReason(String reason) {
        if (this.errorsByReason == null) {
            return false;
        }
        List<ValidationListener.Error> errors = this.errorsByReason.get(reason);
        return errors != null && !errors.isEmpty();
    }

    public boolean hasError(Object bean, String propertyName) {
        if (this.errorsByOwner == null) {
            return false;
        }
        Map<String, List<ValidationListener.Error>> errors = this.errorsByOwner.get(bean);
        if (errors == null) {
            return false;
        }
        if (propertyName != null) {
            List<ValidationListener.Error> list = errors.get(propertyName);
            return list != null && !list.isEmpty();
        }
        for (List<ValidationListener.Error> list : errors.values()) {
            if (list.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "ValidationResults{" + this.errorsByOwner + "}";
    }
}

