/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.core.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.virgo.web.core.WebApplicationRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StandardWebApplicationRegistry
implements WebApplicationRegistry {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, String> deployedWebAppNames = new ConcurrentHashMap<String, String>();

    StandardWebApplicationRegistry() {
    }

    @Override
    public String getWebApplicationName(String contextPath) {
        return this.deployedWebAppNames.get(contextPath);
    }

    @Override
    public void registerWebApplication(String contextPath, String applicationName) {
        this.logger.debug("Registering web application with context path [{}] and application name [{}].", (Object)contextPath, (Object)applicationName);
        this.deployedWebAppNames.put(contextPath, applicationName);
    }

    @Override
    public void unregisterWebApplication(String contextPath) {
        this.logger.debug("Unregistering web application with context path [{}].", (Object)contextPath);
        this.deployedWebAppNames.remove(contextPath);
    }
}

