/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.internal.webapp;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jetty.osgi.boot.BundleProvider;
import org.eclipse.jetty.osgi.boot.utils.WebappRegistrationCustomizer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;

public class WebBundleTrackerCustomizer
implements BundleTrackerCustomizer {
    private static final Logger LOG = Log.getLogger(WebBundleTrackerCustomizer.class);
    public static Collection<WebappRegistrationCustomizer> JSP_REGISTRATION_HELPERS = new ArrayList<WebappRegistrationCustomizer>();
    public static final String FILTER = "(&(objectclass=" + BundleProvider.class.getName() + ")" + "(" + "managedServerName" + "=" + "defaultJettyServer" + "))";
    private ServiceTracker _serviceTracker;
    private BundleTracker _bundleTracker;

    public WebBundleTrackerCustomizer() throws Exception {
        Bundle myBundle = FrameworkUtil.getBundle(this.getClass());
        this._serviceTracker = new ServiceTracker(myBundle.getBundleContext(), FrameworkUtil.createFilter((String)FILTER), null){

            public Object addingService(ServiceReference reference) {
                Object object = super.addingService(reference);
                LOG.debug("Deployer registered {}", new Object[]{reference});
                WebBundleTrackerCustomizer.this.openBundleTracker();
                return object;
            }
        };
        this._serviceTracker.open();
    }

    public Object addingBundle(Bundle bundle, BundleEvent event) {
        if (bundle.getState() == 32) {
            this.register(bundle);
        } else if (bundle.getState() == 16) {
            this.unregister(bundle);
        }
        return null;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
        if (bundle.getState() == 16 || bundle.getState() == 32) {
            this.unregister(bundle);
        }
        if (bundle.getState() == 32) {
            this.register(bundle);
        }
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        this.unregister(bundle);
    }

    private boolean register(Bundle bundle) {
        if (bundle == null) {
            return false;
        }
        boolean deployed = false;
        Object[] deployers = this._serviceTracker.getServices();
        if (deployers != null) {
            for (int i = 0; !deployed && i < deployers.length; ++i) {
                BundleProvider p = (BundleProvider)deployers[i];
                try {
                    deployed = p.bundleAdded(bundle);
                    continue;
                }
                catch (Exception x) {
                    LOG.warn("Error deploying bundle for jetty context", (Throwable)x);
                }
            }
        }
        return deployed;
    }

    private void unregister(Bundle bundle) {
        Object[] deployers = this._serviceTracker.getServices();
        boolean undeployed = false;
        if (deployers != null) {
            int i = 0;
            while (!undeployed && i < deployers.length) {
                try {
                    undeployed = ((BundleProvider)deployers[i++]).bundleRemoved(bundle);
                }
                catch (Exception x) {
                    LOG.warn("Error undeploying bundle for jetty context", (Throwable)x);
                }
            }
        }
    }

    public void setAndOpenWebBundleTracker(BundleTracker bundleTracker) {
        if (this._bundleTracker == null) {
            this._bundleTracker = bundleTracker;
            LOG.debug("Bundle tracker is set", new Object[0]);
            this.openBundleTracker();
        }
    }

    private void openBundleTracker() {
        if (this._bundleTracker != null && this._serviceTracker.getServices() != null && this._serviceTracker.getServices().length > 0) {
            this._bundleTracker.open();
            LOG.debug("Bundle tracker has been opened", new Object[0]);
        }
    }
}

