/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.util.osgi.manifest.internal;

import org.eclipse.virgo.util.osgi.manifest.BundleSymbolicName;
import org.eclipse.virgo.util.osgi.manifest.internal.BaseParameterised;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderDeclaration;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderParser;

class StandardBundleSymbolicName
extends BaseParameterised
implements BundleSymbolicName {
    StandardBundleSymbolicName(HeaderParser parser) {
        super(parser);
    }

    @Override
    HeaderDeclaration parse(HeaderParser parser, String parseString) {
        return parser.parseBundleSymbolicName(parseString);
    }

    @Override
    public BundleSymbolicName.FragmentAttachment getFragmentAttachment() {
        String value = this.getDirectives().get("fragment-attachment");
        if ("never".equals(value)) {
            return BundleSymbolicName.FragmentAttachment.NEVER;
        }
        if ("resolve-time".equals(value)) {
            return BundleSymbolicName.FragmentAttachment.RESOLVE_TIME;
        }
        return BundleSymbolicName.FragmentAttachment.ALWAYS;
    }

    @Override
    public String getSymbolicName() {
        return this.name;
    }

    @Override
    public boolean isSingleton() {
        return Boolean.valueOf(this.getDirectives().get("singleton"));
    }

    @Override
    public void setFragmentAttachment(BundleSymbolicName.FragmentAttachment fragmentAttachment) {
        switch (fragmentAttachment) {
            case NEVER: {
                this.getDirectives().put("fragment-attachment", "never");
                break;
            }
            case RESOLVE_TIME: {
                this.getDirectives().put("fragment-attachment", "resolve-time");
                break;
            }
            default: {
                this.getDirectives().remove("fragment-attachment");
            }
        }
    }

    @Override
    public void setSingleton(boolean singleton) {
        this.getDirectives().put("singleton", Boolean.toString(singleton));
    }

    @Override
    public void setSymbolicName(String symbolicName) {
        this.name = symbolicName;
    }
}

