/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.management;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class ManagementExporter<T>
implements InitializingBean,
DisposableBean {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MBeanServer server = ManagementFactory.getPlatformMBeanServer();
    private final T object;
    private final ObjectName name;

    public ManagementExporter(T object, String name) {
        this.object = object;
        this.name = this.createObjectName(name);
    }

    private ObjectName createObjectName(String name) {
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Could not convert String '" + name + "' to ObjectName", e);
        }
    }

    public void export() {
        this.afterPropertiesSet();
    }

    public void unExport() {
        this.destroy();
    }

    public void afterPropertiesSet() {
        try {
            this.logger.debug("Registering object {} with name {} for management", this.object, (Object)this.name);
            this.server.registerMBean(this.object, this.name);
        }
        catch (Exception e) {
            this.logger.error("Unable to register object {} with name {} for management", this.object, (Object)this.name);
            throw new RuntimeException(e);
        }
    }

    public void destroy() {
        try {
            this.logger.debug("Unregistering bean {} with name {} from management", this.object, (Object)this.name);
            this.server.unregisterMBean(this.name);
        }
        catch (Exception exception) {
            this.logger.warn("Unable to unregister bean {} with name {} from management", this.object, (Object)this.name);
        }
    }
}

