/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.core.internal;

import java.lang.management.ManagementFactory;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.eclipse.virgo.medic.dump.DumpContributor;
import org.eclipse.virgo.medic.dump.DumpGenerator;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.nano.config.internal.ConfigurationInitialiser;
import org.eclipse.virgo.nano.config.internal.KernelConfiguration;
import org.eclipse.virgo.nano.core.BundleStarter;
import org.eclipse.virgo.nano.core.Shutdown;
import org.eclipse.virgo.nano.core.internal.AsyncShutdownDecorator;
import org.eclipse.virgo.nano.core.internal.BundleStartTracker;
import org.eclipse.virgo.nano.core.internal.ShutdownManager;
import org.eclipse.virgo.nano.core.internal.StandardBundleStarter;
import org.eclipse.virgo.nano.core.internal.StartupTracker;
import org.eclipse.virgo.nano.core.internal.blueprint.ApplicationContextDependencyMonitor;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.nano.serviceability.dump.internal.RegionDigraphDumpContributor;
import org.eclipse.virgo.nano.serviceability.dump.internal.ResolutionDumpContributor;
import org.eclipse.virgo.nano.shim.scope.ScopeFactory;
import org.eclipse.virgo.nano.shim.scope.internal.StandardScopeFactory;
import org.eclipse.virgo.nano.shim.serviceability.TracingService;
import org.eclipse.virgo.nano.shim.serviceability.internal.Slf4jTracingService;
import org.eclipse.virgo.util.osgi.ServiceRegistrationTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.launch.Framework;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.EventHandler;

public class CoreBundleActivator {
    private static final String START_SIGNALLING_THREAD_NAME_PREFIX = "start-signalling-";
    private static final String PROPERTY_NAME_SERVICE_SCOPE = "org.eclipse.virgo.service.scope";
    private static final String SERVICE_SCOPE_GLOBAL = "global";
    private static final String EVENT_TOPIC_BLUEPRINT_CONTAINER = "org/osgi/service/blueprint/container/*";
    private static final String EVENT_TOPIC_REGION = "org/eclipse/virgo/kernel/region/*";
    private static final String MBEAN_VALUE_SHUTDOWN = "Shutdown";
    private static final String MBEAN_KEY_TYPE = "type";
    private final ServiceRegistrationTracker tracker;
    private final ConfigurationInitialiser configurationInitialiser;
    private volatile StartupTracker startupTracker;
    private volatile ObjectInstance shutdownMBean;
    private volatile ApplicationContextDependencyMonitor dependencyMonitor;
    private volatile BundleStartTracker bundleStartTracker;

    public CoreBundleActivator() {
        try {
            this.tracker = new ServiceRegistrationTracker();
            this.configurationInitialiser = new ConfigurationInitialiser();
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void activate(ComponentContext componentContext) throws Exception {
        try {
            BundleContext context = componentContext.getBundleContext();
            EventLogger eventLogger = this.getRequiredService(context, EventLogger.class);
            KernelConfiguration configuration = this.configurationInitialiser.start(context, eventLogger);
            Shutdown shutdown = this.initializeShutdownManager(context, eventLogger, configuration);
            this.bundleStartTracker = this.createAndRegisterBundleStartTracker(context);
            this.createAndRegisterBundleStarter(this.bundleStartTracker, context);
            this.dependencyMonitor = this.createAndRegisterApplicationContextDependencyMonitor(context, eventLogger);
            DumpGenerator dumpGenerator = this.getRequiredService(context, DumpGenerator.class);
            this.createAndRegisterStateDumpContributors(context);
            this.startupTracker = new StartupTracker(context, configuration, configuration.getStartupWaitLimit(), this.bundleStartTracker, shutdown, dumpGenerator);
            this.startupTracker.start();
            this.initShimServices(context, eventLogger);
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void createAndRegisterStateDumpContributors(BundleContext context) {
        try {
            this.tracker.track(context.registerService(DumpContributor.class, (Object)new ResolutionDumpContributor(context), null));
            this.tracker.track(context.registerService(DumpContributor.class, (Object)new RegionDigraphDumpContributor(context), null));
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private ApplicationContextDependencyMonitor createAndRegisterApplicationContextDependencyMonitor(BundleContext context, EventLogger eventLogger) {
        try {
            ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(1, new ThreadFactory(){
                private AtomicLong threadCount;
                {
                    try {
                        try {
                        }
                        catch (RuntimeException runtimeException) {
                            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                            throw runtimeException;
                        }
                        this.threadCount = new AtomicLong(1L);
                        return;
                    }
                    catch (RuntimeException runtimeException) {
                        DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                        throw runtimeException;
                    }
                }

                @Override
                public Thread newThread(Runnable r) {
                    try {
                        String name = "service-monitor-thread-" + this.threadCount.getAndIncrement();
                        return new Thread(r, name);
                    }
                    catch (RuntimeException runtimeException) {
                        DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                        throw runtimeException;
                    }
                }
            });
            ApplicationContextDependencyMonitor dependencyMonitor = new ApplicationContextDependencyMonitor(scheduledExecutor, eventLogger);
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("event.topics", EVENT_TOPIC_BLUEPRINT_CONTAINER);
            this.tracker.track(context.registerService(EventHandler.class.getName(), (Object)dependencyMonitor, properties));
            return dependencyMonitor;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private BundleStartTracker createAndRegisterBundleStartTracker(BundleContext context) {
        try {
            SynchronousQueue<Runnable> q = new SynchronousQueue<Runnable>();
            ThreadPoolExecutor executor = new ThreadPoolExecutor(1, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, q, new PrefixingThreadFactory(START_SIGNALLING_THREAD_NAME_PREFIX), new ThreadPoolExecutor.AbortPolicy());
            BundleStartTracker asynchronousStartTracker = new BundleStartTracker(executor);
            asynchronousStartTracker.initialize(context);
            Hashtable<String, String[]> properties = new Hashtable<String, String[]>();
            ((Dictionary)properties).put("event.topics", new String[]{EVENT_TOPIC_BLUEPRINT_CONTAINER, EVENT_TOPIC_REGION});
            this.tracker.track(context.registerService(new String[]{EventHandler.class.getName()}, (Object)asynchronousStartTracker, properties));
            return asynchronousStartTracker;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private BundleStarter createAndRegisterBundleStarter(BundleStartTracker asynchronousStartTracker, BundleContext bundleContext) {
        try {
            StandardBundleStarter bundleStarter = new StandardBundleStarter(asynchronousStartTracker);
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put(PROPERTY_NAME_SERVICE_SCOPE, SERVICE_SCOPE_GLOBAL);
            this.tracker.track(bundleContext.registerService(new String[]{BundleStarter.class.getName()}, (Object)bundleStarter, properties));
            return bundleStarter;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void deactivate(ComponentContext context) throws Exception {
        try {
            BundleStartTracker bundleStartTracker;
            this.tracker.unregisterAll();
            this.startupTracker.stop();
            this.configurationInitialiser.stop();
            this.unregisterShutdownMBean();
            ApplicationContextDependencyMonitor dependencyMonitor = this.dependencyMonitor;
            if (dependencyMonitor != null) {
                this.dependencyMonitor = null;
                dependencyMonitor.stop();
            }
            if ((bundleStartTracker = this.bundleStartTracker) != null) {
                this.bundleStartTracker = null;
                bundleStartTracker.stop();
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private Shutdown initializeShutdownManager(BundleContext context, EventLogger eventLogger, KernelConfiguration configuration) {
        try {
            Shutdown shutdown = this.createShutdown(context, eventLogger);
            this.tracker.track(context.registerService(Shutdown.class.getName(), (Object)shutdown, null));
            this.registerShutdownMBean(configuration, shutdown);
            return shutdown;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void registerShutdownMBean(KernelConfiguration configuration, Shutdown shutdown) {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            try {
                ObjectName shutdownName = ObjectName.getInstance(configuration.getDomain(), MBEAN_KEY_TYPE, MBEAN_VALUE_SHUTDOWN);
                this.shutdownMBean = server.registerMBean(new AsyncShutdownDecorator(shutdown), shutdownName);
            }
            catch (JMException ex) {
                throw new IllegalStateException("Unable to register Shutdown MBean", ex);
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void unregisterShutdownMBean() throws MBeanRegistrationException, InstanceNotFoundException {
        try {
            ObjectInstance localShutdownMBean = this.shutdownMBean;
            if (localShutdownMBean != null) {
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(localShutdownMBean.getObjectName());
                this.shutdownMBean = null;
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    protected Shutdown createShutdown(BundleContext context, EventLogger eventLogger) {
        try {
            Framework framework = (Framework)context.getBundle(0L);
            Runtime runtime = Runtime.getRuntime();
            ShutdownManager manager = new ShutdownManager(eventLogger, framework, runtime);
            return manager;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void initShimServices(BundleContext context, EventLogger eventLogger) {
        try {
            StandardScopeFactory scopeFactory = new StandardScopeFactory(eventLogger);
            Slf4jTracingService tracingService = new Slf4jTracingService();
            this.tracker.track(context.registerService(ScopeFactory.class.getName(), (Object)scopeFactory, null));
            this.tracker.track(context.registerService(TracingService.class.getName(), (Object)tracingService, null));
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private <T> T getRequiredService(BundleContext context, Class<T> clazz) {
        try {
            Object result = null;
            ServiceReference ref = context.getServiceReference(clazz);
            if (ref != null) {
                result = context.getService(ref);
            }
            if (result == null) {
                throw new IllegalStateException("Unable to access required service of type '" + clazz.getName() + "' from bundle '" + context.getBundle().getSymbolicName() + "'");
            }
            return (T)result;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private class PrefixingThreadFactory
    implements ThreadFactory {
        private int threadCount;
        private final Object threadCountMonitor;
        String prefix;

        public PrefixingThreadFactory(String prefix) {
            try {
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                this.threadCount = 0;
                this.threadCountMonitor = new Object();
                this.prefix = "default-thread-prefix";
                this.prefix = prefix;
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        @Override
        public Thread newThread(Runnable r) {
            try {
                return new Thread(r, this.nextThreadName());
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String nextThreadName() {
            try {
                int threadNumber = 0;
                Object object = this.threadCountMonitor;
                synchronized (object) {
                    ++this.threadCount;
                    threadNumber = this.threadCount;
                }
                return String.valueOf(this.prefix) + threadNumber;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }
    }
}

