/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.core.internal;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.core.Shutdown;
import org.eclipse.virgo.kernel.diagnostics.KernelLogEvents;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.jmx.ExceptionCleaner;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.launch.Framework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ShutdownManager
implements Shutdown {
    private static final Logger LOGGER;
    private static final long SHUTDOWN_TIMEOUT;
    private static final int STATE_RUNNING = 0;
    private static final int STATE_STOPPING = 1;
    private final AtomicInteger state;
    private final EventLogger eventLogger;
    private final Framework framework;
    private final Thread shutdownHook;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

    static {
        Factory factory = new Factory("ShutdownManager.java", Class.forName("org.eclipse.virgo.kernel.core.internal.ShutdownManager"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "shutdown", "org.eclipse.virgo.kernel.core.internal.ShutdownManager", "", "", "", "void"), 84);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "immediateShutdown", "org.eclipse.virgo.kernel.core.internal.ShutdownManager", "", "", "", "void"), 105);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "exitVM", "org.eclipse.virgo.kernel.core.internal.ShutdownManager", "", "", "", "void"), 111);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isSuccessfulStopResponse", "org.eclipse.virgo.kernel.core.internal.ShutdownManager", "org.osgi.framework.FrameworkEvent:", "shutdownResponse:", "", "boolean"), 115);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "removeShutdownHook", "org.eclipse.virgo.kernel.core.internal.ShutdownManager", "", "", "", "void"), 119);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$0", "org.eclipse.virgo.kernel.core.internal.ShutdownManager", "org.eclipse.virgo.kernel.core.internal.ShutdownManager:", "arg0:", "", "java.util.concurrent.atomic.AtomicInteger"), 53);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$1", "org.eclipse.virgo.kernel.core.internal.ShutdownManager", "org.eclipse.virgo.kernel.core.internal.ShutdownManager:", "arg0:", "", "org.osgi.framework.launch.Framework"), 57);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$2", "org.eclipse.virgo.kernel.core.internal.ShutdownManager", "org.eclipse.virgo.kernel.core.internal.ShutdownManager:", "arg0:", "", "org.eclipse.virgo.medic.eventlog.EventLogger"), 55);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$3", "org.eclipse.virgo.kernel.core.internal.ShutdownManager", "org.eclipse.virgo.kernel.core.internal.ShutdownManager:", "arg0:", "", "void"), 119);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.core.internal.ShutdownManager");
        LOGGER = LoggerFactory.getLogger(ShutdownManager.class);
        SHUTDOWN_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    }

    public ShutdownManager(EventLogger eventLogger, Framework framework) {
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.state = new AtomicInteger(0);
            this.shutdownHook = new Thread(new Runnable(){
                private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
                private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
                {
                    try {
                        try {
                        }
                        catch (RuntimeException runtimeException) {
                            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                            throw runtimeException;
                        }
                        return;
                    }
                    catch (RuntimeException runtimeException) {
                        DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                        throw runtimeException;
                    }
                }

                public void run() {
                    try {
                        1.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                        try {
                            try {
                                ShutdownManager.access$0(ShutdownManager.this).set(1);
                                ShutdownManager.this.shutdown();
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                        }
                        catch (RuntimeException runtimeException) {
                            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                            throw runtimeException;
                        }
                        1.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                        return;
                    }
                    catch (Throwable throwable) {
                        1.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                        throw throwable;
                    }
                }

                static {
                    Factory factory = new Factory("ShutdownManager.java", Class.forName("org.eclipse.virgo.kernel.core.internal.ShutdownManager$1"));
                    ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "org.eclipse.virgo.kernel.core.internal.ShutdownManager$1", "", "", "", "void"), 61);
                    ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.core.internal.ShutdownManager$1");
                }
            });
            this.eventLogger = eventLogger;
            this.framework = framework;
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            BundleContext bundleContext = framework.getBundleContext();
            bundleContext.addBundleListener((BundleListener)new ShutdownLoggingListener(this, null));
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void shutdown() {
        try {
            try {
                ShutdownManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                try {
                    FrameworkEvent shutdownResponse = null;
                    try {
                        this.framework.stop();
                        shutdownResponse = this.framework.waitForStop(SHUTDOWN_TIMEOUT);
                    }
                    catch (BundleException ex) {
                        LOGGER.error("Error during shutdown.", (Throwable)ex);
                    }
                    catch (InterruptedException ex) {
                        LOGGER.error("Interrupted during shutdown.", (Throwable)ex);
                    }
                    if (!this.isSuccessfulStopResponse(shutdownResponse)) {
                        this.immediateShutdown();
                    } else {
                        this.removeShutdownHook();
                    }
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                ShutdownManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return;
            }
            catch (Throwable throwable) {
                ShutdownManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            ExceptionCleaner.aspectOf().ajc$afterThrowing$org_eclipse_virgo_util_jmx_ExceptionCleaner$1$f309547b((Object)this, throwable);
            throw throwable;
        }
    }

    public void immediateShutdown() {
        try {
            try {
                ShutdownManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
                try {
                    this.removeShutdownHook();
                    this.eventLogger.log((LogEvent)KernelLogEvents.IMMEDIATE_SHUTDOWN_INITIATED, new Object[0]);
                    this.exitVM();
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                ShutdownManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
                return;
            }
            catch (Throwable throwable) {
                ShutdownManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            ExceptionCleaner.aspectOf().ajc$afterThrowing$org_eclipse_virgo_util_jmx_ExceptionCleaner$1$f309547b((Object)this, throwable);
            throw throwable;
        }
    }

    protected void exitVM() {
        try {
            ShutdownManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            try {
                System.exit(0);
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ShutdownManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return;
        }
        catch (Throwable throwable) {
            ShutdownManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    private boolean isSuccessfulStopResponse(FrameworkEvent shutdownResponse) {
        try {
            boolean bl;
            ShutdownManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
            try {
                bl = shutdownResponse != null && shutdownResponse.getType() == 64;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ShutdownManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
            return bl;
        }
        catch (Throwable throwable) {
            ShutdownManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    private void removeShutdownHook() {
        try {
            ShutdownManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
            try {
                if (this.state.compareAndSet(0, 1)) {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ShutdownManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
            return;
        }
        catch (Throwable throwable) {
            ShutdownManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    static /* synthetic */ AtomicInteger access$0(ShutdownManager arg0) {
        try {
            AtomicInteger atomicInteger;
            ShutdownManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_5);
            try {
                atomicInteger = arg0.state;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ShutdownManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_5);
            return atomicInteger;
        }
        catch (Throwable throwable) {
            ShutdownManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_5);
            throw throwable;
        }
    }

    static /* synthetic */ Framework access$1(ShutdownManager arg0) {
        try {
            Framework framework;
            ShutdownManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_6);
            try {
                framework = arg0.framework;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ShutdownManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_6);
            return framework;
        }
        catch (Throwable throwable) {
            ShutdownManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_6);
            throw throwable;
        }
    }

    static /* synthetic */ EventLogger access$2(ShutdownManager arg0) {
        try {
            EventLogger eventLogger;
            ShutdownManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_7);
            try {
                eventLogger = arg0.eventLogger;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ShutdownManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_7);
            return eventLogger;
        }
        catch (Throwable throwable) {
            ShutdownManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_7);
            throw throwable;
        }
    }

    static /* synthetic */ void access$3(ShutdownManager arg0) {
        try {
            ShutdownManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_8);
            try {
                arg0.removeShutdownHook();
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ShutdownManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_8);
            return;
        }
        catch (Throwable throwable) {
            ShutdownManager.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_8);
            throw throwable;
        }
    }

    private final class ShutdownLoggingListener
    implements SynchronousBundleListener {
        final /* synthetic */ ShutdownManager this$0;
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        private ShutdownLoggingListener(ShutdownManager shutdownManager) {
            this.this$0 = shutdownManager;
            try {
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        public void bundleChanged(BundleEvent event) {
            try {
                ShutdownLoggingListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                try {
                    BundleContext bundleContext = ShutdownManager.access$1(this.this$0).getBundleContext();
                    if (256 == event.getType() && event.getBundle() == bundleContext.getBundle()) {
                        ShutdownManager.access$2(this.this$0).log((LogEvent)KernelLogEvents.SHUTDOWN_INITIATED, new Object[0]);
                        ShutdownManager.access$3(this.this$0);
                    }
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                ShutdownLoggingListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return;
            }
            catch (Throwable throwable) {
                ShutdownLoggingListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }

        /* synthetic */ ShutdownLoggingListener(ShutdownManager shutdownManager, ShutdownLoggingListener shutdownLoggingListener) {
            ShutdownManager shutdownManager2 = shutdownManager;
            ShutdownLoggingListener ajc$aspectInstance = this;
            ajc$aspectInstance.this$0 = shutdownManager2;
            try {
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                try {
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        static {
            Factory factory = new Factory("ShutdownManager.java", Class.forName("org.eclipse.virgo.kernel.core.internal.ShutdownManager$ShutdownLoggingListener"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "bundleChanged", "org.eclipse.virgo.kernel.core.internal.ShutdownManager$ShutdownLoggingListener", "org.osgi.framework.BundleEvent:", "event:", "", "void"), 127);
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.core.internal.ShutdownManager$ShutdownLoggingListener");
        }
    }
}

