/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.deployer.core.internal.uri;

import java.net.URI;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.deployer.core.DeployUriNormaliser;
import org.eclipse.virgo.kernel.deployer.core.DeployerLogEvents;
import org.eclipse.virgo.kernel.deployer.core.DeploymentException;
import org.eclipse.virgo.kernel.serviceability.NonNull;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.kernel.serviceability.enforcement.NonNullAssertionEnforcer;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.repository.ArtifactDescriptor;
import org.eclipse.virgo.repository.Repository;
import org.eclipse.virgo.repository.RepositoryAwareArtifactDescriptor;
import org.eclipse.virgo.util.osgi.VersionRange;
import org.osgi.framework.Version;

final class RepositoryDeployUriNormaliser
implements DeployUriNormaliser {
    private static final String SCHEME_REPOSITORY = "repository";
    private static final int COMPONENTS_MINIMUM = 2;
    private static final int COMPONENTS_MAXIMUM = 3;
    private final Repository repository;
    private final EventLogger eventLogger;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    RepositoryDeployUriNormaliser(@NonNull Repository repository, EventLogger eventLogger) {
        Repository repository2 = repository;
        NonNullAssertionEnforcer.aspectOf().ajc$before$org_eclipse_virgo_kernel_serviceability_enforcement_NonNullAssertionEnforcer$1$7118cd8((Object)repository2);
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.repository = repository;
            this.eventLogger = eventLogger;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public URI normalise(URI uri) throws DeploymentException {
        try {
            try {
                RepositoryDeployUriNormaliser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                URI uRI = SCHEME_REPOSITORY.equals(uri.getScheme()) ? this.normaliseRepositoryUri(uri) : null;
                RepositoryDeployUriNormaliser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return uRI;
            }
            catch (Throwable throwable) {
                RepositoryDeployUriNormaliser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private URI normaliseRepositoryUri(URI uri) throws DeploymentException {
        try {
            try {
                RepositoryDeployUriNormaliser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
                String[] tnv = this.extractTypeNameAndVersion(uri);
                URI normalisedUri = null;
                if (tnv.length >= 2 && tnv.length <= 3) {
                    ArtifactDescriptor artifactDescriptor;
                    String versionString = null;
                    if (tnv.length == 3) {
                        versionString = tnv[2];
                    }
                    if ((artifactDescriptor = this.lookupArtifactDescriptor(tnv[0], tnv[1], versionString, uri)) != null) {
                        normalisedUri = artifactDescriptor.getUri();
                    }
                } else {
                    this.eventLogger.log((LogEvent)DeployerLogEvents.REPOSITORY_DEPLOYMENT_URI_MALFORMED, new Object[]{uri});
                    throw new DeploymentException("The URI '" + uri + "' is malformed");
                }
                URI uRI = normalisedUri;
                RepositoryDeployUriNormaliser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
                return uRI;
            }
            catch (Throwable throwable) {
                RepositoryDeployUriNormaliser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private String[] extractTypeNameAndVersion(URI uri) {
        try {
            try {
                String[] tnvComponents;
                RepositoryDeployUriNormaliser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
                String tnv = uri.getSchemeSpecificPart();
                String[] stringArray = tnvComponents = tnv.split("/");
                RepositoryDeployUriNormaliser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
                return stringArray;
            }
            catch (Throwable throwable) {
                RepositoryDeployUriNormaliser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private ArtifactDescriptor lookupArtifactDescriptor(String type, String name, String versionString, URI uri) throws DeploymentException {
        try {
            try {
                RepositoryAwareArtifactDescriptor repositoryAwareArtifactDescriptor;
                RepositoryDeployUriNormaliser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
                try {
                    VersionRange versionRange;
                    if (versionString == null) {
                        versionRange = VersionRange.NATURAL_NUMBER_RANGE;
                    } else {
                        Version version = new Version(versionString);
                        versionRange = VersionRange.createExactRange((Version)version);
                    }
                    RepositoryAwareArtifactDescriptor artifactDescriptor = this.repository.get(type, name, versionRange);
                    if (artifactDescriptor == null) {
                        this.eventLogger.log((LogEvent)DeployerLogEvents.ARTIFACT_NOT_FOUND, new Object[]{type, name, versionRange, this.repository.getName()});
                        throw new DeploymentException("The URI '" + uri + "' references a non-existent artifact");
                    }
                    repositoryAwareArtifactDescriptor = artifactDescriptor;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.eventLogger.log((LogEvent)DeployerLogEvents.REPOSITORY_DEPLOYMENT_INVALID_VERSION, new Object[]{versionString, uri});
                    throw new DeploymentException("The version '" + versionString + "' is invalid");
                }
                RepositoryDeployUriNormaliser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
                return repositoryAwareArtifactDescriptor;
            }
            catch (Throwable throwable) {
                RepositoryDeployUriNormaliser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static {
        Factory factory = new Factory("RepositoryDeployUriNormaliser.java", Class.forName("org.eclipse.virgo.kernel.deployer.core.internal.uri.RepositoryDeployUriNormaliser"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "normalise", "org.eclipse.virgo.kernel.deployer.core.internal.uri.RepositoryDeployUriNormaliser", "java.net.URI:", "uri:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "java.net.URI"), 58);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "normaliseRepositoryUri", "org.eclipse.virgo.kernel.deployer.core.internal.uri.RepositoryDeployUriNormaliser", "java.net.URI:", "uri:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "java.net.URI"), 65);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "extractTypeNameAndVersion", "org.eclipse.virgo.kernel.deployer.core.internal.uri.RepositoryDeployUriNormaliser", "java.net.URI:", "uri:", "", "[Ljava.lang.String;"), 85);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "lookupArtifactDescriptor", "org.eclipse.virgo.kernel.deployer.core.internal.uri.RepositoryDeployUriNormaliser", "java.lang.String:java.lang.String:java.lang.String:java.net.URI:", "type:name:versionString:uri:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "org.eclipse.virgo.repository.ArtifactDescriptor"), 94);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.deployer.core.internal.uri.RepositoryDeployUriNormaliser");
    }
}

