/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.deployer.core.DeploymentException;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifactLifecycleListenerSupport;
import org.eclipse.virgo.kernel.install.artifact.PlanInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.common.GraphNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AtomicInstallArtifactLifecycleListener
extends InstallArtifactLifecycleListenerSupport {
    private final Logger logger;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    AtomicInstallArtifactLifecycleListener() {
        try {
            this.logger = LoggerFactory.getLogger(this.getClass());
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void onStarting(InstallArtifact installArtifact) throws DeploymentException {
        try {
            try {
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                this.logger.debug("Processing atomic starting event for {}", (Object)installArtifact);
                for (InstallArtifact atomicParent : this.getAtomicParents(installArtifact)) {
                    if (AtomicInstallArtifactLifecycleListener.aChildIsRefreshing(atomicParent)) {
                        this.logger.info("Atomic starting event not propagated from {} as a child of {} is refreshing.", (Object)installArtifact, (Object)atomicParent);
                        continue;
                    }
                    this.logger.info("Propagating atomic starting event from {} to {}", (Object)installArtifact, (Object)atomicParent);
                    atomicParent.start();
                }
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return;
            }
            catch (Throwable throwable) {
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void onStartFailed(InstallArtifact installArtifact, Throwable cause) throws DeploymentException {
        try {
            try {
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
                this.logger.debug("Processing atomic start failed (stop) event for {}", (Object)installArtifact);
                for (InstallArtifact atomicParent : this.getAtomicParents(installArtifact)) {
                    if (AtomicInstallArtifactLifecycleListener.aChildIsRefreshing(atomicParent)) {
                        this.logger.info("Atomic start failed event not propagated from {} as a child of {} is refreshing.", (Object)installArtifact, (Object)atomicParent);
                        continue;
                    }
                    this.logger.info("Propagating atomic start failed (stop) event from {} to {}", (Object)installArtifact, (Object)atomicParent);
                    atomicParent.stop();
                }
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
                return;
            }
            catch (Throwable throwable) {
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void onStopped(InstallArtifact installArtifact) {
        try {
            try {
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_2);
                this.logger.debug("Processing atomic stopped event for {}", (Object)installArtifact);
                for (InstallArtifact atomicParent : this.getAtomicParents(installArtifact)) {
                    if (AtomicInstallArtifactLifecycleListener.aChildIsRefreshing(atomicParent)) {
                        this.logger.info("Atomic stopped event not propagated from {} as a child of {} is refreshing.", (Object)installArtifact, (Object)atomicParent);
                        continue;
                    }
                    this.logger.info("Propagating atomic stopped event from {} to {}", (Object)installArtifact, (Object)atomicParent);
                    try {
                        atomicParent.stop();
                    }
                    catch (DeploymentException e) {
                        this.logger.warn("Unable to propagate stopped event to an atomic root due to an exception", (Throwable)e);
                    }
                }
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_2);
                return;
            }
            catch (Throwable throwable) {
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public void onUninstalled(InstallArtifact installArtifact) throws DeploymentException {
        try {
            try {
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_3);
                this.logger.debug("Processing atomic uninstalled event for {}", (Object)installArtifact);
                for (InstallArtifact atomicParent : this.getAtomicParents(installArtifact)) {
                    if (AtomicInstallArtifactLifecycleListener.aChildIsRefreshing(atomicParent)) {
                        this.logger.info("Atomic uninstalled event not propagated from {} as a child of {} is refreshing.", (Object)installArtifact, (Object)atomicParent);
                        continue;
                    }
                    this.logger.info("Propagating atomic uninstalled event from {} to {}", (Object)installArtifact, (Object)atomicParent);
                    atomicParent.uninstall();
                }
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_3);
                return;
            }
            catch (Throwable throwable) {
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_3);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private Set<InstallArtifact> getAtomicParents(InstallArtifact installArtifact) {
        try {
            HashSet<InstallArtifact> atomicParents = new HashSet<InstallArtifact>();
            for (InstallArtifact parent : AtomicInstallArtifactLifecycleListener.getParentInstallArtifacts(installArtifact)) {
                if (!AtomicInstallArtifactLifecycleListener.isAtomicInstallArtifact(parent)) continue;
                atomicParents.add(parent);
            }
            return atomicParents;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static final boolean isAtomicInstallArtifact(InstallArtifact installArtifact) {
        try {
            try {
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
                boolean bl = installArtifact instanceof PlanInstallArtifact ? ((PlanInstallArtifact)installArtifact).isAtomic() : false;
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
                return bl;
            }
            catch (Throwable throwable) {
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static final Set<InstallArtifact> getParentInstallArtifacts(InstallArtifact installArtifact) {
        try {
            HashSet<InstallArtifact> parentInstallArtifacts = new HashSet<InstallArtifact>();
            GraphNode<InstallArtifact> iaGraph = installArtifact.getGraph();
            if (iaGraph != null) {
                List parents = iaGraph.getParents();
                for (GraphNode parent : parents) {
                    parentInstallArtifacts.add((InstallArtifact)parent.getValue());
                }
            }
            return parentInstallArtifacts;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static boolean aChildIsRefreshing(InstallArtifact atomicParent) {
        try {
            try {
                boolean bl;
                block6: {
                    AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_5);
                    InstallArtifact[] installArtifactArray = AtomicInstallArtifactLifecycleListener.childrenOf(atomicParent);
                    int n = installArtifactArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AbstractInstallArtifact aChild;
                        InstallArtifact child = installArtifactArray[n2];
                        if (child instanceof AbstractInstallArtifact && (aChild = (AbstractInstallArtifact)child).isRefreshing()) {
                            bl = true;
                            break block6;
                        }
                        ++n2;
                    }
                    bl = false;
                }
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_5);
                return bl;
            }
            catch (Throwable throwable) {
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_5);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static InstallArtifact[] childrenOf(InstallArtifact parent) {
        try {
            try {
                GraphNode<InstallArtifact> graph;
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_6);
                ArrayList<InstallArtifact> children = new ArrayList<InstallArtifact>();
                if (parent != null && (graph = parent.getGraph()) != null) {
                    for (GraphNode childBranch : graph.getChildren()) {
                        InstallArtifact child = (InstallArtifact)childBranch.getValue();
                        if (child == null) continue;
                        children.add(child);
                    }
                }
                InstallArtifact[] installArtifactArray = children.toArray(new InstallArtifact[children.size()]);
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_6);
                return installArtifactArray;
            }
            catch (Throwable throwable) {
                AtomicInstallArtifactLifecycleListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_6);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static {
        Factory factory = new Factory("AtomicInstallArtifactLifecycleListener.java", Class.forName("org.eclipse.virgo.kernel.install.artifact.internal.AtomicInstallArtifactLifecycleListener"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onStarting", "org.eclipse.virgo.kernel.install.artifact.internal.AtomicInstallArtifactLifecycleListener", "org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "installArtifact:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 49);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onStartFailed", "org.eclipse.virgo.kernel.install.artifact.internal.AtomicInstallArtifactLifecycleListener", "org.eclipse.virgo.kernel.install.artifact.InstallArtifact:java.lang.Throwable:", "installArtifact:cause:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 66);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onStopped", "org.eclipse.virgo.kernel.install.artifact.internal.AtomicInstallArtifactLifecycleListener", "org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "installArtifact:", "", "void"), 83);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "onUninstalled", "org.eclipse.virgo.kernel.install.artifact.internal.AtomicInstallArtifactLifecycleListener", "org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "installArtifact:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 104);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1a", "isAtomicInstallArtifact", "org.eclipse.virgo.kernel.install.artifact.internal.AtomicInstallArtifactLifecycleListener", "org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "installArtifact:", "", "boolean"), 134);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "aChildIsRefreshing", "org.eclipse.virgo.kernel.install.artifact.internal.AtomicInstallArtifactLifecycleListener", "org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "atomicParent:", "", "boolean"), 167);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "childrenOf", "org.eclipse.virgo.kernel.install.artifact.internal.AtomicInstallArtifactLifecycleListener", "org.eclipse.virgo.kernel.install.artifact.InstallArtifact:", "parent:", "", "[Lorg.eclipse.virgo.kernel.install.artifact.InstallArtifact;"), 183);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.install.artifact.internal.AtomicInstallArtifactLifecycleListener");
    }
}

