/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.shell.internal.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.shell.Command;
import org.eclipse.virgo.kernel.shell.internal.CommandDescriptor;
import org.eclipse.virgo.kernel.shell.internal.CommandRegistry;
import org.eclipse.virgo.kernel.shell.internal.help.HelpAccessor;
import org.eclipse.virgo.medic.log.EntryExitTrace;

@Command(value="help")
final class HelpCommand {
    private final CommandRegistry commandRegistry;
    private final HelpAccessor helpAccessor;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    HelpCommand(CommandRegistry commandRegistry, HelpAccessor helpAccessor) {
        this.commandRegistry = commandRegistry;
        this.helpAccessor = helpAccessor;
    }

    @Command(value="")
    public List<String> summaryHelp() {
        try {
            HelpCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            ArrayList<String> lines = new ArrayList<String>();
            SortedMap<String, CommandDescriptor> topLevelCommands = this.getTopLevelCommands();
            Set<String> sortedCommandNames = topLevelCommands.keySet();
            int width = this.maxWidthOfCommandNames(sortedCommandNames);
            String lineFormatNull = String.format("    %%-%ds", width);
            String lineFormat = String.format("    %%-%ds - %%s", width);
            lines.add("");
            for (String commandName : sortedCommandNames) {
                String commandHelp = this.helpAccessor.getSummaryHelp(((CommandDescriptor)topLevelCommands.get(commandName)).getTarget().getClass());
                if (commandHelp == null) {
                    lines.add(String.format(lineFormatNull, commandName));
                    continue;
                }
                lines.add(String.format(lineFormat, commandName, commandHelp));
            }
            lines.add("");
            ArrayList<String> arrayList = lines;
            HelpCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return arrayList;
        }
        catch (Throwable throwable) {
            HelpCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    private int maxWidthOfCommandNames(Set<String> keySet) {
        try {
            HelpCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
            int result = 0;
            for (String key : keySet) {
                if (result >= key.length()) continue;
                result = key.length();
            }
            int n = result < 8 ? 8 : result;
            HelpCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
            return n;
        }
        catch (Throwable throwable) {
            HelpCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    @Command(value="")
    public List<String> detailedHelp(String command) {
        try {
            List<String> detailedHelp;
            HelpCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_2);
            SortedMap<String, CommandDescriptor> commandMap = this.getTopLevelCommands();
            CommandDescriptor descriptor = (CommandDescriptor)commandMap.get(command);
            List<String> list = descriptor == null ? Arrays.asList(String.format("No help is available as command '%s' is unknown", command)) : ((detailedHelp = this.helpAccessor.getDetailedHelp(descriptor.getTarget().getClass())) == null || detailedHelp.size() == 0 ? Arrays.asList(String.format("No help is available for command '%s'", command)) : detailedHelp);
            HelpCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_2);
            return list;
        }
        catch (Throwable throwable) {
            HelpCommand.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    private SortedMap<String, CommandDescriptor> getTopLevelCommands() {
        TreeMap<String, CommandDescriptor> commandMap = new TreeMap<String, CommandDescriptor>();
        List<CommandDescriptor> commands = this.commandRegistry.getCommandDescriptors();
        for (CommandDescriptor command : commands) {
            commandMap.put(command.getCommandName(), command);
        }
        return commandMap;
    }

    static {
        Factory factory = new Factory("HelpCommand.java", Class.forName("org.eclipse.virgo.kernel.shell.internal.commands.HelpCommand"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "summaryHelp", "org.eclipse.virgo.kernel.shell.internal.commands.HelpCommand", "", "", "", "java.util.List"), 52);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "maxWidthOfCommandNames", "org.eclipse.virgo.kernel.shell.internal.commands.HelpCommand", "java.util.Set:", "keySet:", "", "int"), 78);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "detailedHelp", "org.eclipse.virgo.kernel.shell.internal.commands.HelpCommand", "java.lang.String:", "command:", "", "java.util.List"), 89);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.shell.internal.commands.HelpCommand");
    }
}

