/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.socket.https;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import org.eclipse.equinox.socket.SocketInterface;

public class HttpsSocket
implements SocketInterface {
    protected Socket socket;
    protected boolean closed = false;
    private boolean active = false;
    private InputStream in = null;

    public HttpsSocket(Socket socket) {
        this.socket = socket;
    }

    public void close() throws IOException {
        this.closed = true;
        this.socket.close();
    }

    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException {
        if (this.in == null) {
            HttpsSocket httpsSocket = this;
            synchronized (httpsSocket) {
                if (this.in == null) {
                    this.in = new BufferedInputStream(this.socket.getInputStream());
                }
            }
        }
        return this.in;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.socket.setSoTimeout(timeout);
    }

    public int getSoTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    public String getScheme() {
        return "https";
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isActive() {
        return this.active;
    }

    public void markActive() {
        this.active = true;
    }

    public void markInactive() {
        this.active = false;
    }
}

