/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.blueprint.extender.internal.activator;

import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.gemini.blueprint.context.event.OsgiBundleApplicationContextEventMulticaster;
import org.eclipse.gemini.blueprint.context.event.OsgiBundleApplicationContextListener;
import org.eclipse.gemini.blueprint.extender.internal.activator.ApplicationContextConfigurationFactory;
import org.eclipse.gemini.blueprint.extender.internal.activator.DefaultApplicationContextConfigurationFactory;
import org.eclipse.gemini.blueprint.extender.internal.activator.DefaultVersionMatcher;
import org.eclipse.gemini.blueprint.extender.internal.activator.LifecycleManager;
import org.eclipse.gemini.blueprint.extender.internal.activator.ListListenerAdapter;
import org.eclipse.gemini.blueprint.extender.internal.activator.NoOpOsgiContextProcessor;
import org.eclipse.gemini.blueprint.extender.internal.activator.OsgiContextProcessor;
import org.eclipse.gemini.blueprint.extender.internal.activator.TypeCompatibilityChecker;
import org.eclipse.gemini.blueprint.extender.internal.activator.VersionMatcher;
import org.eclipse.gemini.blueprint.extender.internal.support.ExtenderConfiguration;
import org.eclipse.gemini.blueprint.extender.internal.support.NamespaceManager;
import org.eclipse.gemini.blueprint.service.exporter.support.OsgiServiceFactoryBean;
import org.eclipse.gemini.blueprint.service.importer.support.OsgiServiceCollectionProxyFactoryBean;
import org.eclipse.gemini.blueprint.service.importer.support.OsgiServiceProxyFactoryBean;
import org.eclipse.gemini.blueprint.util.OsgiBundleUtils;
import org.eclipse.gemini.blueprint.util.OsgiStringUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.Version;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.CachedIntrospectionResults;

public class ContextLoaderListener
implements BundleActivator {
    protected final Log log = LogFactory.getLog(this.getClass());
    private long bundleId;
    private ExtenderConfiguration extenderConfiguration;
    private NamespaceManager nsManager;
    private BundleContext bundleContext;
    private SynchronousBundleListener contextListener;
    private SynchronousBundleListener nsListener;
    private final Object monitor = new Object();
    private volatile boolean isClosed = false;
    private Version extenderVersion;
    private volatile OsgiBundleApplicationContextEventMulticaster multicaster;
    private volatile LifecycleManager lifecycleManager;
    private volatile VersionMatcher versionMatcher;
    private volatile OsgiContextProcessor processor;
    private volatile ListListenerAdapter osgiListeners;

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.bundleId = context.getBundle().getBundleId();
        this.extenderVersion = OsgiBundleUtils.getBundleVersion((Bundle)context.getBundle());
        this.log.info((Object)("Starting [" + this.bundleContext.getBundle().getSymbolicName() + "] bundle v.[" + this.extenderVersion + "]"));
        this.versionMatcher = new DefaultVersionMatcher(this.getManagedBundleExtenderVersionHeader(), this.extenderVersion);
        this.processor = this.createContextProcessor();
        this.initJavaBeansCache();
        this.nsManager = new NamespaceManager(context);
        this.initNamespaceHandlers(this.bundleContext);
        this.extenderConfiguration = this.initExtenderConfiguration(this.bundleContext);
        this.initListenerService();
        this.lifecycleManager = new LifecycleManager(this.extenderConfiguration, this.versionMatcher, this.createContextConfigFactory(), this.processor, this.getTypeCompatibilityChecker(), this.bundleContext);
        this.initStartedBundles(this.bundleContext);
    }

    protected ExtenderConfiguration initExtenderConfiguration(BundleContext bundleContext) {
        return new ExtenderConfiguration(bundleContext, this.log);
    }

    protected OsgiContextProcessor createContextProcessor() {
        return new NoOpOsgiContextProcessor();
    }

    protected TypeCompatibilityChecker getTypeCompatibilityChecker() {
        return null;
    }

    protected String getManagedBundleExtenderVersionHeader() {
        return "SpringExtender-Version";
    }

    protected void initNamespaceHandlers(BundleContext context) {
        Bundle[] previousBundles;
        this.nsManager = new NamespaceManager(context);
        boolean nsResolved = !Boolean.getBoolean("org.eclipse.gemini.blueprint.ns.bundles.started");
        this.nsListener = new NamespaceBundleLister(nsResolved);
        context.addBundleListener((BundleListener)this.nsListener);
        for (Bundle bundle : previousBundles = context.getBundles()) {
            if (nsResolved && OsgiBundleUtils.isBundleResolved((Bundle)bundle) || !nsResolved && OsgiBundleUtils.isBundleActive((Bundle)bundle) || this.bundleId == bundle.getBundleId()) {
                this.maybeAddNamespaceHandlerFor(bundle, false);
                continue;
            }
            if (!OsgiBundleUtils.isBundleLazyActivated((Bundle)bundle)) continue;
            this.maybeAddNamespaceHandlerFor(bundle, true);
        }
        this.nsManager.afterPropertiesSet();
    }

    protected void initStartedBundles(BundleContext bundleContext) {
        this.contextListener = new ContextBundleListener();
        bundleContext.addBundleListener((BundleListener)this.contextListener);
        Bundle[] previousBundles = bundleContext.getBundles();
        for (int i = 0; i < previousBundles.length; ++i) {
            if (!OsgiBundleUtils.isBundleActive((Bundle)previousBundles[i])) continue;
            try {
                this.lifecycleManager.maybeCreateApplicationContextFor(previousBundles[i]);
                continue;
            }
            catch (Throwable e) {
                this.log.warn((Object)("Cannot start bundle " + OsgiStringUtils.nullSafeSymbolicName((Bundle)previousBundles[i]) + " due to"), e);
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }
        this.log.info((Object)("Stopping [" + this.bundleContext.getBundle().getSymbolicName() + "] bundle v.[" + this.extenderVersion + "]"));
        this.destroyJavaBeansCache();
        if (this.contextListener != null) {
            this.bundleContext.removeBundleListener((BundleListener)this.contextListener);
            this.contextListener = null;
        }
        if (this.nsListener != null) {
            this.bundleContext.removeBundleListener((BundleListener)this.nsListener);
            this.nsListener = null;
        }
        this.lifecycleManager.destroy();
        this.nsManager.destroy();
        if (this.multicaster != null) {
            this.multicaster.removeAllListeners();
            this.multicaster = null;
        }
        this.osgiListeners.destroy();
        this.osgiListeners = null;
        this.extenderConfiguration.destroy();
    }

    private void initJavaBeansCache() {
        Class[] classes = new Class[]{OsgiServiceFactoryBean.class, OsgiServiceProxyFactoryBean.class, OsgiServiceCollectionProxyFactoryBean.class};
        CachedIntrospectionResults.acceptClassLoader((ClassLoader)OsgiStringUtils.class.getClassLoader());
        for (Class clazz : classes) {
            BeanUtils.getPropertyDescriptors((Class)clazz);
        }
    }

    private void destroyJavaBeansCache() {
        CachedIntrospectionResults.clearClassLoader((ClassLoader)OsgiStringUtils.class.getClassLoader());
    }

    protected void maybeAddNamespaceHandlerFor(Bundle bundle, boolean isLazy) {
        if (this.handlerBundleMatchesExtenderVersion(bundle)) {
            this.nsManager.maybeAddNamespaceHandlerFor(bundle, isLazy);
        }
    }

    protected void maybeRemoveNameSpaceHandlerFor(Bundle bundle) {
        if (this.handlerBundleMatchesExtenderVersion(bundle)) {
            this.nsManager.maybeRemoveNameSpaceHandlerFor(bundle);
        }
    }

    private boolean handlerBundleMatchesExtenderVersion(Bundle bundle) {
        if (!this.versionMatcher.matchVersion(bundle)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Ignoring handler bundle " + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle) + "] due to mismatch in expected extender version"));
            }
            return false;
        }
        return true;
    }

    protected ApplicationContextConfigurationFactory createContextConfigFactory() {
        return new DefaultApplicationContextConfigurationFactory();
    }

    protected void initListenerService() {
        this.multicaster = this.extenderConfiguration.getEventMulticaster();
        this.addApplicationListener(this.multicaster);
        this.multicaster.addApplicationListener(this.extenderConfiguration.getContextEventListener());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Initialization of OSGi listeners service completed...");
        }
    }

    protected void addApplicationListener(OsgiBundleApplicationContextEventMulticaster multicaster) {
        this.osgiListeners = new ListListenerAdapter(this.bundleContext);
        this.osgiListeners.afterPropertiesSet();
        multicaster.addApplicationListener((OsgiBundleApplicationContextListener)this.osgiListeners);
    }

    private class ContextBundleListener
    extends BaseListener {
        private ContextBundleListener() {
        }

        protected void handleEvent(BundleEvent event) {
            Bundle bundle = event.getBundle();
            if (bundle.getBundleId() == ContextLoaderListener.this.bundleId) {
                return;
            }
            switch (event.getType()) {
                case 512: {
                    try {
                        bundle.loadClass("org.osgi.service.blueprint.container.BlueprintContainer");
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 2: {
                    ContextLoaderListener.this.lifecycleManager.maybeCreateApplicationContextFor(bundle);
                    break;
                }
                case 256: {
                    if (OsgiBundleUtils.isSystemBundle((Bundle)bundle)) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)"System bundle stopping");
                        }
                        ContextLoaderListener.this.shutdown();
                        break;
                    }
                    ContextLoaderListener.this.lifecycleManager.maybeCloseApplicationContextFor(bundle);
                    break;
                }
            }
        }
    }

    private class NamespaceBundleLister
    extends BaseListener {
        private final boolean resolved;

        NamespaceBundleLister(boolean resolvedBundles) {
            this.resolved = resolvedBundles;
        }

        protected void handleEvent(BundleEvent event) {
            Bundle bundle = event.getBundle();
            switch (event.getType()) {
                case 32: {
                    if (!this.resolved) break;
                    ContextLoaderListener.this.maybeAddNamespaceHandlerFor(bundle, false);
                    break;
                }
                case 512: {
                    if (this.resolved) break;
                    this.push(bundle);
                    ContextLoaderListener.this.maybeAddNamespaceHandlerFor(bundle, true);
                    break;
                }
                case 2: {
                    if (this.resolved || this.pop(bundle)) break;
                    ContextLoaderListener.this.maybeAddNamespaceHandlerFor(bundle, false);
                    break;
                }
                case 4: {
                    this.pop(bundle);
                    ContextLoaderListener.this.maybeRemoveNameSpaceHandlerFor(bundle);
                    break;
                }
            }
        }
    }

    private abstract class BaseListener
    implements SynchronousBundleListener {
        static final int LAZY_ACTIVATION_EVENT_TYPE = 512;
        protected final Log log = LogFactory.getLog(this.getClass());
        protected Map<Bundle, Object> lazyBundleCache = new WeakHashMap<Bundle, Object>();
        private final Object VALUE = new Object();

        private BaseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void push(Bundle bundle) {
            Map<Bundle, Object> map = this.lazyBundleCache;
            synchronized (map) {
                this.lazyBundleCache.put(bundle, this.VALUE);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean pop(Bundle bundle) {
            Map<Bundle, Object> map = this.lazyBundleCache;
            synchronized (map) {
                return this.lazyBundleCache.remove(bundle) != null;
            }
        }

        public void bundleChanged(BundleEvent event) {
            boolean trace = this.log.isTraceEnabled();
            if (ContextLoaderListener.this.isClosed) {
                if (trace) {
                    this.log.trace((Object)"Listener is closed; events are being ignored");
                }
                return;
            }
            if (trace) {
                this.log.trace((Object)("Processing bundle event [" + OsgiStringUtils.nullSafeToString((BundleEvent)event) + "] for bundle [" + OsgiStringUtils.nullSafeSymbolicName((Bundle)event.getBundle()) + "]"));
            }
            try {
                this.handleEvent(event);
            }
            catch (Exception ex) {
                this.log.warn((Object)("Got exception while handling event " + event), (Throwable)ex);
            }
        }

        protected abstract void handleEvent(BundleEvent var1);
    }
}

