/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.deployer.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarFile;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.nano.deployer.NanoDeployerLogEvents;
import org.eclipse.virgo.nano.deployer.SimpleDeployer;
import org.eclipse.virgo.nano.deployer.StandardDeploymentIdentity;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentIdentity;
import org.eclipse.virgo.nano.deployer.util.BundleInfosUpdater;
import org.eclipse.virgo.nano.deployer.util.BundleLocationUtil;
import org.eclipse.virgo.nano.deployer.util.StatusFileModificator;
import org.eclipse.virgo.util.io.FileCopyUtils;
import org.eclipse.virgo.util.io.IOUtils;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.BundleManifestFactory;
import org.eclipse.virgo.util.osgi.manifest.FragmentHost;
import org.eclipse.virgo.util.osgi.manifest.parse.BundleManifestParseException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleDeployer
implements SimpleDeployer {
    private static final String KERNEL_HOME_PROP = "org.eclipse.virgo.kernel.home";
    private static final String JAR = "jar";
    private static final boolean STATUS_ERROR = false;
    private static final boolean STATUS_OK = true;
    private static final char SLASH = '/';
    private static final String PICKUP_DIR = "pickup";
    private static final String FRAGMEN_HOST_HEADER = "Fragment-Host";
    private final EventLogger eventLogger;
    private final long largeFileCopyTimeout = 30000L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BundleContext bundleContext;
    private final BundleInfosUpdater bundleInfosUpdater;
    private final PackageAdmin packageAdmin;
    private final File workBundleInstallLocation;
    private final File kernelHomeFile;
    private final File pickupDir;

    public BundleDeployer(BundleContext bundleContext, PackageAdmin packageAdmin, EventLogger eventLogger) {
        this.eventLogger = eventLogger;
        this.bundleContext = bundleContext;
        this.packageAdmin = packageAdmin;
        String kernelHome = System.getProperty(KERNEL_HOME_PROP);
        if (kernelHome != null) {
            this.kernelHomeFile = new File(kernelHome);
            if (!this.kernelHomeFile.exists()) {
                throw new IllegalStateException("Required location '" + this.kernelHomeFile.getAbsolutePath() + "' does not exist. Check the value of the '" + KERNEL_HOME_PROP + "' propery");
            }
        } else {
            throw new IllegalStateException("Missing value for required property 'org.eclipse.virgo.kernel.home'");
        }
        File bundlesInfoFile = new File(this.kernelHomeFile, "configuration/org.eclipse.equinox.simpleconfigurator/bundles.info");
        this.bundleInfosUpdater = new BundleInfosUpdater(bundlesInfoFile, this.kernelHomeFile);
        this.pickupDir = new File(this.kernelHomeFile, PICKUP_DIR);
        String thisBundleName = this.bundleContext.getBundle().getSymbolicName();
        String staging = "staging";
        this.workBundleInstallLocation = new File(this.kernelHomeFile, "work" + File.separator + thisBundleName + File.separator + staging);
    }

    private Boolean createInstallationFolder() {
        if (!this.workBundleInstallLocation.exists() && !this.workBundleInstallLocation.mkdirs()) {
            this.logger.error("Failed to create staging directory '" + this.workBundleInstallLocation.getAbsolutePath() + "' for bundle deployment.");
            return false;
        }
        return true;
    }

    private boolean validateUri(URI uri) {
        if (!this.canWrite(uri)) {
            this.logger.error("Cannot open the file " + uri + " for writing. The configured timeout is " + 30000L + ".");
            return false;
        }
        return true;
    }

    private Boolean isFragment(FragmentHost hostHolder) {
        if (hostHolder != null && hostHolder.getBundleSymbolicName() != null) {
            return true;
        }
        return false;
    }

    private Boolean isFragment(Bundle bundle) {
        Enumeration keys = bundle.getHeaders().keys();
        while (keys.hasMoreElements()) {
            if (!((String)keys.nextElement()).equalsIgnoreCase(FRAGMEN_HOST_HEADER)) continue;
            return true;
        }
        return false;
    }

    private void refreshHosts(FragmentHost hostHolder, Bundle fragment) {
        try {
            Bundle[] hosts = this.packageAdmin.getBundles(hostHolder.getBundleSymbolicName(), null);
            if (hosts != null) {
                this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_REFRESHING_HOST, new Object[]{fragment.getSymbolicName(), fragment.getVersion()});
                this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_REFRESHING_HOST, new Object[]{fragment.getSymbolicName(), fragment.getVersion()});
                this.packageAdmin.refreshPackages(hosts);
                this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_REFRESHED_HOST, new Object[]{fragment.getSymbolicName(), fragment.getVersion()});
            }
        }
        catch (Exception e) {
            this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_REFRESH_HOST_ERROR, (Throwable)e, new Object[]{fragment.getSymbolicName(), fragment.getVersion()});
        }
    }

    private void updateBundleInfo(Bundle bundle, File stagedFile, Boolean isFragment) {
        try {
            URI location = BundleLocationUtil.getRelativisedURI(this.kernelHomeFile, stagedFile);
            if (this.bundleInfosUpdater != null && this.bundleInfosUpdater.isAvailable()) {
                BundleInfosUpdater.registerToBundlesInfo(bundle, location.toString(), isFragment);
            }
        }
        catch (Exception ex) {
            this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_PERSIST_ERROR, (Throwable)ex, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
        }
    }

    @Override
    public boolean install(URI uri) {
        long lastModified;
        String jarName;
        block4: {
            this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_INSTALLING, new Object[]{new File(uri).toString()});
            jarName = this.extractDecodedJarNameFromString(uri.toString());
            lastModified = new File(uri).lastModified();
            StatusFileModificator.deleteStatusFile(jarName, this.pickupDir);
            try {
                if (this.validateUri(uri) && this.createInstallationFolder().booleanValue()) break block4;
                this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_INSTALLING_ERROR, new Object[]{uri});
                StatusFileModificator.createStatusFile(jarName, this.pickupDir, "deploy", false, -1L, lastModified);
                return false;
            }
            catch (Exception e) {
                this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_INSTALLING_ERROR, (Throwable)e, new Object[]{uri});
                StatusFileModificator.createStatusFile(jarName, this.pickupDir, "deploy", false, -1L, lastModified);
                return false;
            }
        }
        File stagedFile = this.getStagedFile(uri);
        FileCopyUtils.copy((File)new File(uri), (File)stagedFile);
        Bundle installed = this.bundleContext.installBundle(BundleLocationUtil.createInstallLocation(this.kernelHomeFile, stagedFile));
        FragmentHost hostHolder = this.getFragmentHostFromDeployedBundleIfExsiting(stagedFile);
        this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_INSTALLED, new Object[]{installed.getSymbolicName(), installed.getVersion()});
        if (this.isFragment(hostHolder).booleanValue()) {
            this.refreshHosts(hostHolder, installed);
            this.updateBundleInfo(installed, stagedFile, true);
        }
        StatusFileModificator.createStatusFile(jarName, this.pickupDir, "deploy", false, installed.getBundleId(), lastModified);
        return true;
    }

    @Override
    public boolean start(URI uri) {
        Bundle installedBundle = this.getInstalledBundle(uri);
        String jarName = this.extractDecodedJarNameFromString(uri.toString());
        long lastModified = new File(uri).lastModified();
        StatusFileModificator.deleteStatusFile(jarName, this.pickupDir);
        File stagedFile = this.getStagedFile(uri);
        if (installedBundle != null) {
            this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_STARTING, new Object[]{installedBundle.getSymbolicName(), installedBundle.getVersion()});
            try {
                if (!this.isFragment(installedBundle).booleanValue()) {
                    installedBundle.start();
                    this.updateBundleInfo(installedBundle, stagedFile, false);
                    this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_STARTED, new Object[]{installedBundle.getSymbolicName(), installedBundle.getVersion()});
                } else if (this.logger.isWarnEnabled()) {
                    this.logger.warn("The installed bundle for the given url [" + uri + "] is a fragment bundle. Start operation for this url will not be executed.");
                }
            }
            catch (Exception e) {
                this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_STARTING_ERROR, (Throwable)e, new Object[]{installedBundle.getSymbolicName(), installedBundle.getVersion()});
                StatusFileModificator.createStatusFile(jarName, this.pickupDir, "deploy", false, -1L, lastModified);
                return false;
            }
        }
        StatusFileModificator.createStatusFile(jarName, this.pickupDir, "deploy", true, installedBundle.getBundleId(), lastModified);
        return true;
    }

    @Override
    public boolean deploy(URI path) {
        File stagedFile;
        long lastModified;
        String jarName;
        File deployedFile;
        block14: {
            this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_INSTALLING, new Object[]{new File(path).toString()});
            deployedFile = new File(path);
            jarName = this.extractDecodedJarNameFromString(path.toString());
            lastModified = deployedFile.lastModified();
            StatusFileModificator.deleteStatusFile(jarName, this.pickupDir);
            if (!this.canWrite(path)) {
                this.logger.error("Cannot open the file " + path + " for writing. The configured timeout is " + 30000L + ".");
                this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_INSTALLING_ERROR, new Object[]{path});
                StatusFileModificator.createStatusFile(jarName, this.pickupDir, "deploy", false, -1L, lastModified);
                return false;
            }
            stagedFile = null;
            try {
                if (this.workBundleInstallLocation.exists() || this.workBundleInstallLocation.mkdirs()) break block14;
                this.logger.error("Failed to create staging directory '" + this.workBundleInstallLocation.getAbsolutePath() + "' for bundle deployment.");
                this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_INSTALLING_ERROR, new Object[]{path});
                StatusFileModificator.createStatusFile(jarName, this.pickupDir, "deploy", false, -1L, lastModified);
                return false;
            }
            catch (Exception e) {
                this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_INSTALLING_ERROR, (Throwable)e, new Object[]{path});
                StatusFileModificator.createStatusFile(jarName, this.pickupDir, "deploy", false, -1L, lastModified);
                return false;
            }
        }
        stagedFile = this.getStagedFile(path);
        FileCopyUtils.copy((File)deployedFile, (File)stagedFile);
        Bundle installed = this.bundleContext.installBundle(BundleLocationUtil.createInstallLocation(this.kernelHomeFile, stagedFile));
        FragmentHost hostHolder = this.getFragmentHostFromDeployedBundleIfExsiting(stagedFile);
        this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_INSTALLED, new Object[]{installed.getSymbolicName(), installed.getVersion()});
        if (hostHolder != null && hostHolder.getBundleSymbolicName() != null) {
            try {
                Bundle[] hosts = this.packageAdmin.getBundles(hostHolder.getBundleSymbolicName(), null);
                if (hosts != null) {
                    this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_REFRESHING_HOST, new Object[]{installed.getSymbolicName(), installed.getVersion()});
                    this.packageAdmin.refreshPackages(hosts);
                    this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_REFRESHED_HOST, new Object[]{installed.getSymbolicName(), installed.getVersion()});
                }
            }
            catch (Exception e) {
                this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_REFRESH_HOST_ERROR, (Throwable)e, new Object[]{installed.getSymbolicName(), installed.getVersion()});
            }
        } else {
            this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_STARTING, new Object[]{installed.getSymbolicName(), installed.getVersion()});
            try {
                installed.start();
            }
            catch (Exception e) {
                this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_STARTING_ERROR, (Throwable)e, new Object[]{installed.getSymbolicName(), installed.getVersion()});
                StatusFileModificator.createStatusFile(jarName, this.pickupDir, "deploy", false, -1L, lastModified);
                return false;
            }
            this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_STARTED, new Object[]{installed.getSymbolicName(), installed.getVersion()});
        }
        try {
            if (this.bundleInfosUpdater != null && this.bundleInfosUpdater.isAvailable()) {
                String bundlesInfoLocation = BundleLocationUtil.getRelativisedURI(this.kernelHomeFile, stagedFile).toString();
                BundleInfosUpdater.registerToBundlesInfo(installed, bundlesInfoLocation, hostHolder != null && hostHolder.getBundleSymbolicName() != null);
            }
        }
        catch (Exception e) {
            this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_PERSIST_ERROR, (Throwable)e, new Object[]{installed.getSymbolicName(), installed.getVersion()});
        }
        StatusFileModificator.createStatusFile(jarName, this.pickupDir, "deploy", true, installed.getBundleId(), lastModified);
        return true;
    }

    private FragmentHost getFragmentHostFromDeployedBundleIfExsiting(File stagedFile) {
        try {
            JarFile bundleJar = new JarFile(stagedFile);
            BundleManifest manifest = BundleManifestFactory.createBundleManifest((Reader)new InputStreamReader(bundleJar.getInputStream(bundleJar.getEntry("META-INF/MANIFEST.MF"))));
            return manifest.getFragmentHost();
        }
        catch (IOException ioe) {
            this.logger.error("Failed to extract the fragment host header from file '" + stagedFile.getAbsolutePath() + "'.", (Throwable)ioe);
            return null;
        }
        catch (BundleManifestParseException bundleManifestParseException) {
            return null;
        }
    }

    @Override
    public boolean update(URI path) {
        File updatedFile = new File(path);
        String jarName = this.extractDecodedJarNameFromString(path.toString());
        long lastModified = updatedFile.lastModified();
        File matchingStagedFile = new File(this.workBundleInstallLocation, this.extractJarFileNameFromString(path.toString()));
        StatusFileModificator.deleteStatusFile(jarName, this.pickupDir);
        if (!this.canWrite(path)) {
            this.logger.error("Cannot open the file [" + path + "] for writing. Timeout is [" + 30000L + "].");
            this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_UPDATING_ERROR, new Object[]{path});
            StatusFileModificator.createStatusFile(jarName, this.pickupDir, "deploy", false, -1L, lastModified);
            return false;
        }
        Bundle bundle = this.bundleContext.getBundle(BundleLocationUtil.createInstallLocation(this.kernelHomeFile, matchingStagedFile));
        if (bundle != null) {
            try {
                FileCopyUtils.copy((File)updatedFile, (File)matchingStagedFile);
                this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_UPDATING, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
                bundle.update();
                if (this.packageAdmin != null) {
                    this.packageAdmin.refreshPackages(new Bundle[]{bundle});
                    this.logger.info("Update of file with path '" + path + "' is successful.");
                }
                this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_UPDATED, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
            }
            catch (Exception e) {
                this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_UPDATE_ERROR, (Throwable)e, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
                StatusFileModificator.createStatusFile(jarName, this.pickupDir, "deploy", false, -1L, lastModified);
                return false;
            }
        } else {
            this.deploy(path);
        }
        StatusFileModificator.createStatusFile(jarName, this.pickupDir, "deploy", true, bundle.getBundleId(), lastModified);
        return true;
    }

    @Override
    public boolean undeploy(Bundle bundle) {
        if (bundle != null) {
            String bundleLocation = bundle.getLocation();
            File stagingFileToDelete = new File(bundleLocation.substring("reference:file:".length()));
            String jarName = this.extractDecodedJarNameFromString(bundleLocation);
            StatusFileModificator.deleteStatusFile(jarName, this.pickupDir);
            FragmentHost hostHolder = this.getFragmentHostFromDeployedBundleIfExsiting(stagingFileToDelete);
            try {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Removing bundle '" + bundle.getSymbolicName() + "' version '" + bundle.getVersion() + "' from bundles.info.");
                }
                if (this.bundleInfosUpdater != null && this.bundleInfosUpdater.isAvailable()) {
                    String bundlesInfoLocation = BundleLocationUtil.getRelativisedURI(this.kernelHomeFile, stagingFileToDelete).toString();
                    BundleInfosUpdater.unregisterToBundlesInfo(bundle, bundlesInfoLocation, hostHolder != null && hostHolder.getBundleSymbolicName() != null);
                    this.logger.info("Successfully removed bundle '" + bundle.getSymbolicName() + "' version '" + bundle.getVersion() + "' from bundles.info.");
                } else {
                    this.logger.error("BundleInfosUpdater not available. Failed to remove bundle '" + bundle.getSymbolicName() + "' version '" + bundle.getVersion() + "' from bundles.info.");
                }
            }
            catch (Exception e) {
                this.logger.warn("Failed to unregister bundle '" + bundle.getSymbolicName() + "' version '" + bundle.getVersion() + "'", (Throwable)e);
            }
            try {
                if (hostHolder == null) {
                    this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_STOPPING, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
                    bundle.stop();
                    this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_STOPPED, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
                }
                this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_UNINSTALLING, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
                bundle.uninstall();
                this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_UNINSTALLED, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
                if (!stagingFileToDelete.delete()) {
                    this.logger.warn("Could not delete staging file '" + stagingFileToDelete.getAbsolutePath() + "'");
                }
            }
            catch (BundleException e) {
                this.eventLogger.log((LogEvent)NanoDeployerLogEvents.NANO_UNDEPLOY_ERROR, (Throwable)e, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
                StatusFileModificator.createStatusFile(jarName, this.pickupDir, "undeploy", false, -1L, -1L);
                return false;
            }
            StatusFileModificator.createStatusFile(jarName, this.pickupDir, "undeploy", true, -1L, -1L);
        }
        return true;
    }

    @Override
    public boolean canServeFileType(String fileType) {
        return JAR.equals(fileType);
    }

    private Bundle getInstalledBundle(URI uri) {
        return this.bundleContext.getBundle(BundleLocationUtil.createInstallLocation(this.kernelHomeFile, this.getStagedFile(uri)));
    }

    private File getStagedFile(URI uri) {
        File matchingStagingBundle = new File(this.workBundleInstallLocation, this.extractJarFileNameFromString(uri.toString()));
        return matchingStagingBundle;
    }

    @Override
    public boolean isDeployed(URI path) {
        return this.bundleContext.getBundle(BundleLocationUtil.createInstallLocation(this.kernelHomeFile, this.getStagedFile(path))) != null;
    }

    @Override
    public boolean isOfflineUpdated(URI path) {
        String jarName = this.extractDecodedJarNameFromString(path.toString());
        File deployFile = new File(path);
        long deployFileLastModified = deployFile.lastModified();
        return deployFileLastModified != StatusFileModificator.getLastModifiedFromStatusFile(jarName, this.pickupDir);
    }

    private String extractDecodedJarNameFromString(String path) {
        String jarName = path.substring(path.lastIndexOf(47) + 1, path.length() - 4);
        return URLDecoder.decode(jarName);
    }

    @Override
    public DeploymentIdentity getDeploymentIdentity(URI path) {
        File matchingStagingBundle = this.getStagedFile(path);
        Bundle bundle = this.bundleContext.getBundle(BundleLocationUtil.createInstallLocation(this.kernelHomeFile, matchingStagingBundle));
        if (bundle == null) {
            return null;
        }
        return new StandardDeploymentIdentity(JAR, bundle.getSymbolicName(), bundle.getVersion().toString());
    }

    private boolean canWrite(URI path) {
        int tries = -1;
        boolean isWritable = false;
        long timeout = 30000L / 500L;
        while ((long)tries < timeout) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(new File(path));
                isWritable = true;
            }
            catch (FileNotFoundException e) {
                block7: {
                    try {
                        if (!this.logger.isInfoEnabled()) break block7;
                        this.logger.info("File is still locked.", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fis);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Closeable)fis);
            }
            IOUtils.closeQuietly((Closeable)fis);
            break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                this.logger.error("InterruptedException occurred.", (Throwable)e);
            }
            ++tries;
        }
        return isWritable;
    }

    private String extractJarFileNameFromString(String path) {
        String jarName = path.substring(path.lastIndexOf(47) + 1);
        return jarName;
    }

    @Override
    public boolean isDeployFileValid(File file) {
        JarFile jarFile = null;
        try {
            try {
                jarFile = new JarFile(file);
            }
            catch (IOException iOException) {
                this.logger.error("The deployed file '" + file.getAbsolutePath() + "' is an invalid zip file.");
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
                catch (IOException iOException2) {}
                return false;
            }
        }
        catch (Throwable throwable) {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (jarFile != null) {
                jarFile.close();
            }
        }
        catch (IOException iOException) {}
        return true;
    }

    @Override
    public List<String> getAcceptedFileTypes() {
        ArrayList<String> types = new ArrayList<String>();
        types.add(JAR);
        return types;
    }
}

