/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.javamail.store.nntp;

import java.io.File;
import java.io.PrintStream;
import java.util.Iterator;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import org.apache.geronimo.javamail.store.nntp.NNTPRootFolder;
import org.apache.geronimo.javamail.store.nntp.newsrc.NNTPNewsrc;
import org.apache.geronimo.javamail.store.nntp.newsrc.NNTPNewsrcFile;
import org.apache.geronimo.javamail.store.nntp.newsrc.NNTPNewsrcGroup;
import org.apache.geronimo.javamail.transport.nntp.NNTPConnection;
import org.apache.geronimo.mail.util.SessionUtil;

public class NNTPStore
extends Store {
    protected static final String NNTP_AUTH = "auth";
    protected static final String NNTP_PORT = "port";
    protected static final String NNTP_NEWSRC = "newsrc";
    protected static final String protocol = "nntp";
    protected static final int DEFAULT_NNTP_PORT = 119;
    protected NNTPConnection connection;
    protected NNTPNewsrc newsrc;
    protected NNTPRootFolder root;
    protected PrintStream debugStream;

    public NNTPStore(Session session, URLName urlName) {
        super(session, urlName);
        this.debugStream = session.getDebugOut();
    }

    public Folder getDefaultFolder() throws MessagingException {
        this.checkConnectionStatus();
        if (this.root == null) {
            return new NNTPRootFolder(this, this.connection.getHost(), this.connection.getWelcomeString());
        }
        return this.root;
    }

    public Folder getFolder(String name) throws MessagingException {
        return this.getDefaultFolder().getFolder(name);
    }

    public Folder getFolder(URLName url) throws MessagingException {
        return this.getDefaultFolder().getFolder(url.getFile());
    }

    protected synchronized boolean protocolConnect(String host, int port, String username, String password) throws MessagingException {
        boolean mustAuthenticate;
        if (this.debug) {
            this.debugOut("Connecting to server " + host + ":" + port + " for user " + username);
        }
        if ((mustAuthenticate = this.getBooleanProperty(NNTP_AUTH, false)) && (username == null || password == null)) {
            return false;
        }
        if (port == -1) {
            port = this.getIntProperty(NNTP_PORT, 119);
        }
        this.connection = new NNTPConnection(protocol, this.session, host, port, username, password, this.debug);
        this.connection.connect();
        String newsrcFile = this.getProperty(NNTP_NEWSRC);
        File source = null;
        if (newsrcFile != null) {
            source = new File(newsrcFile);
        } else {
            String home = SessionUtil.getProperty("user.home");
            source = new File(home, newsrcFile = ".newsrc-" + host);
            if (!source.exists()) {
                source = new File(home, ".newsrc");
            }
        }
        this.newsrc = new NNTPNewsrcFile(source);
        this.newsrc.load();
        return true;
    }

    public void close() throws MessagingException {
        super.close();
        this.newsrc.close();
        this.connection.close();
        this.connection = null;
    }

    private void checkConnectionStatus() throws MessagingException {
        if (!this.isConnected()) {
            throw new MessagingException("Not connected ");
        }
    }

    void debugOut(String message) {
        this.debugStream.println("NNTPTransport DEBUG: " + message);
    }

    void debugOut(String message, Throwable e) {
        this.debugOut("Received exception -> " + message);
        this.debugOut("Exception message -> " + e.getMessage());
        e.printStackTrace(this.debugStream);
    }

    NNTPConnection getConnection() {
        return this.connection;
    }

    Session getSession() {
        return this.session;
    }

    Iterator getNewsrcGroups() {
        return this.newsrc.getGroups();
    }

    NNTPNewsrcGroup getNewsrcGroup(String name) {
        return this.newsrc.getGroup(name);
    }

    String getProperty(String name) {
        String fullName = "mail.nntp." + name;
        return this.session.getProperty(fullName);
    }

    String getProperty(String name, String defaultValue) {
        String fullName = "mail.nntp." + name;
        return SessionUtil.getProperty(this.session, fullName, defaultValue);
    }

    int getIntProperty(String name, int defaultValue) {
        String fullName = "mail.nntp." + name;
        return SessionUtil.getIntProperty(this.session, fullName, defaultValue);
    }

    boolean getBooleanProperty(String name, boolean defaultValue) {
        String fullName = "mail.nntp." + name;
        return SessionUtil.getBooleanProperty(this.session, fullName, defaultValue);
    }
}

