/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.loader;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.openejb.loader.ClassPath;

public abstract class BasicURLClassPath
implements ClassPath {
    private Field ucpField;

    public static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    protected void addJarToPath(URL jar, URLClassLoader loader) throws Exception {
        Object cp = this.getURLClassPath(loader);
        Method addURLMethod = this.getAddURLMethod(loader);
        addURLMethod.invoke(cp, (Object[])new URL[]{jar});
    }

    private Method getAddURLMethod(final URLClassLoader loader) {
        return AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    Object cp = BasicURLClassPath.this.getURLClassPath(loader);
                    Class<?> clazz = cp.getClass();
                    return clazz.getDeclaredMethod("addURL", URL.class);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
    }

    protected void addJarsToPath(File dir, URLClassLoader loader) throws Exception {
        if (dir == null || !dir.exists()) {
            return;
        }
        String[] jarNames = dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar") || name.endsWith(".zip");
            }
        });
        URL[] jars = new URL[jarNames.length];
        for (int j = 0; j < jarNames.length; ++j) {
            jars[j] = new File(dir, jarNames[j]).toURI().toURL();
        }
        Object cp = this.getURLClassPath(loader);
        Method addURLMethod = this.getAddURLMethod(loader);
        for (URL jar : jars) {
            addURLMethod.invoke(cp, (Object[])new URL[]{jar});
        }
    }

    protected Object getURLClassPath(URLClassLoader loader) throws Exception {
        return this.getUcpField().get(loader);
    }

    private Field getUcpField() throws Exception {
        if (this.ucpField == null) {
            this.ucpField = AccessController.doPrivileged(new PrivilegedAction<Field>(){

                @Override
                public Field run() {
                    Field ucp = null;
                    try {
                        ucp = URLClassLoader.class.getDeclaredField("ucp");
                        ucp.setAccessible(true);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    return ucp;
                }
            });
        }
        return this.ucpField;
    }
}

