/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import java.io.File;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.install.artifact.internal.AbstractArtifactStore;
import org.eclipse.virgo.kernel.install.artifact.internal.ArtifactStore;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.util.io.PathReference;

final class GenerationalArtifactStore
extends AbstractArtifactStore
implements ArtifactStore {
    private final PathReference baseDirectory;
    private long generation;
    private final String baseName;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    GenerationalArtifactStore(PathReference basePathReference) {
        super(basePathReference);
        try {
            this.baseDirectory = basePathReference.getParent();
            this.baseName = basePathReference.getName();
            long recoveredGeneration = GenerationalArtifactStore.recoverLastGeneration(this.baseDirectory);
            this.generation = recoveredGeneration == -1L ? 0L : recoveredGeneration;
            PathReference currentPathReference = GenerationalArtifactStore.getGenerationPath(this.generation, this.baseDirectory, this.baseName);
            if (recoveredGeneration == -1L) {
                currentPathReference.getParent().createDirectory();
                currentPathReference.delete(true);
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static long recoverLastGeneration(PathReference baseDirectory) {
        try {
            try {
                GenerationalArtifactStore.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_0);
                long lastGeneration = -1L;
                File file = baseDirectory.toFile();
                String[] children = file.list();
                if (children != null) {
                    String[] stringArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String child = stringArray[n2];
                        try {
                            long childGeneration = Long.parseLong(child);
                            if (childGeneration > lastGeneration) {
                                lastGeneration = childGeneration;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {}
                        ++n2;
                    }
                }
                long l = lastGeneration;
                GenerationalArtifactStore.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_0);
                return l;
            }
            catch (Throwable throwable) {
                GenerationalArtifactStore.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PathReference getCurrentPath() {
        try {
            Object object = this.monitor;
            synchronized (object) {
                return this.getGenerationPath(this.generation);
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        try {
            try {
                GenerationalArtifactStore.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
                Object object = this.monitor;
                synchronized (object) {
                    if (this.generation != 0L) {
                        this.getSavedPath().delete(true);
                    }
                    ++this.generation;
                    super.save();
                }
                GenerationalArtifactStore.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
                return;
            }
            catch (Throwable throwable) {
                GenerationalArtifactStore.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restore() {
        try {
            try {
                GenerationalArtifactStore.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_2);
                Object object = this.monitor;
                synchronized (object) {
                    super.restore();
                    --this.generation;
                }
                GenerationalArtifactStore.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_2);
                return;
            }
            catch (Throwable throwable) {
                GenerationalArtifactStore.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    protected PathReference getSavedPath() {
        try {
            return this.getGenerationPath(this.generation - 1L);
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private PathReference getGenerationPath(long generation) {
        try {
            return GenerationalArtifactStore.getGenerationPath(generation, this.baseDirectory, this.baseName);
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private static PathReference getGenerationPath(long generation, PathReference baseDirectory, String baseName) {
        try {
            return baseDirectory.newChild(Long.toString(generation)).newChild(baseName);
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static {
        Factory factory = new Factory("GenerationalArtifactStore.java", Class.forName("org.eclipse.virgo.kernel.install.artifact.internal.GenerationalArtifactStore"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "recoverLastGeneration", "org.eclipse.virgo.kernel.install.artifact.internal.GenerationalArtifactStore", "org.eclipse.virgo.util.io.PathReference:", "baseDirectory:", "", "long"), 56);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "save", "org.eclipse.virgo.kernel.install.artifact.internal.GenerationalArtifactStore", "", "", "", "void"), 87);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "restore", "org.eclipse.virgo.kernel.install.artifact.internal.GenerationalArtifactStore", "", "", "", "void"), 101);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.install.artifact.internal.GenerationalArtifactStore");
    }
}

