/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.enterprise.security;

import java.lang.reflect.Field;
import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.UUID;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.apache.catalina.Realm;
import org.apache.catalina.Wrapper;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.security.AbstractSecurityService;
import org.apache.openejb.spi.CallerPrincipal;

public class StandardSecurityService
extends AbstractSecurityService {
    private Wrapper wrapper;
    protected static final ThreadLocal<LinkedList<Subject>> runAsStack = new ThreadLocal<LinkedList<Subject>>(){

        @Override
        protected LinkedList<Subject> initialValue() {
            return new LinkedList<Subject>();
        }
    };

    public Object enterWebApp(Wrapper wrapper, Principal principal, String runAs) {
        this.wrapper = wrapper;
        AbstractSecurityService.Identity newIdentity = null;
        if (principal != null) {
            Subject newSubject = this.createSubject(wrapper.getRealm(), principal);
            newIdentity = new AbstractSecurityService.Identity(newSubject, null);
        }
        AbstractSecurityService.Identity oldIdentity = (AbstractSecurityService.Identity)clientIdentity.get();
        WebAppState webAppState = new WebAppState(oldIdentity, runAs != null);
        clientIdentity.set(newIdentity);
        if (runAs != null) {
            Subject runAsSubject = this.createRunAsSubject(runAs);
            runAsStack.get().addFirst(runAsSubject);
        }
        return webAppState;
    }

    public void exitWebApp(Object state) {
        if (state instanceof WebAppState) {
            WebAppState webAppState = (WebAppState)state;
            clientIdentity.set(webAppState.oldIdentity);
            if (webAppState.hadRunAs) {
                runAsStack.get().removeFirst();
            }
        }
        this.wrapper = null;
    }

    protected Subject createSubject(Realm realm, Principal principal) {
        if (realm == null) {
            throw new NullPointerException("realm is null");
        }
        if (principal == null) {
            throw new NullPointerException("tomcatPrincipal is null");
        }
        TomcatUserWrapper tomcatUser = new TomcatUserWrapper(realm, principal);
        HashSet<TomcatUserWrapper> principals = new HashSet<TomcatUserWrapper>();
        principals.add(tomcatUser);
        Subject subject = new Subject(true, principals, new HashSet(), new HashSet());
        return subject;
    }

    protected Subject createRunAsSubject(String role) {
        if (role == null) {
            return null;
        }
        RunAsRole runAsRole = new RunAsRole(role);
        HashSet<RunAsRole> principals = new HashSet<RunAsRole>();
        principals.add(runAsRole);
        return new Subject(true, principals, new HashSet(), new HashSet());
    }

    public Set<String> getLogicalRoles(Principal[] principals, Set<String> logicalRoles) {
        LinkedHashSet<String> roles = new LinkedHashSet<String>(logicalRoles.size());
        Iterator<String> iterator = logicalRoles.iterator();
        block0: while (iterator.hasNext()) {
            String role;
            String logicalRole = role = iterator.next();
            Principal[] principalArray = principals;
            int n = principals.length;
            int n2 = 0;
            while (n2 < n) {
                RunAsRole runAsRole;
                String name;
                Principal principal = principalArray[n2];
                if (principal instanceof TomcatUserWrapper) {
                    TomcatUserWrapper user = (TomcatUserWrapper)principal;
                    if (user.getRealm().hasRole(this.wrapper, user.getTomcatPrincipal(), logicalRole)) {
                        roles.add(logicalRole);
                        continue block0;
                    }
                } else if (principal instanceof RunAsRole && logicalRole.equals(name = (runAsRole = (RunAsRole)principal).getName())) {
                    roles.add(logicalRole);
                }
                ++n2;
            }
        }
        return roles;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isCallerInRole(String role) {
        if (role == null) {
            throw new IllegalArgumentException("Role must not be null");
        }
        ThreadContext threadContext = ThreadContext.getThreadContext();
        AbstractSecurityService.SecurityContext securityContext = (AbstractSecurityService.SecurityContext)threadContext.get(AbstractSecurityService.SecurityContext.class);
        try {
            TomcatUserWrapper user;
            Field field = securityContext.getClass().getDeclaredField("subject");
            field.setAccessible(true);
            Set<TomcatUserWrapper> users = ((Subject)field.get(securityContext)).getPrincipals(TomcatUserWrapper.class);
            boolean inRole = false;
            Iterator<TomcatUserWrapper> iterator = users.iterator();
            do {
                if (!iterator.hasNext()) {
                    return false;
                }
                user = iterator.next();
            } while (!(inRole = this.wrapper.getRealm().hasRole(this.wrapper, user.getTomcatPrincipal(), role)));
            return true;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return false;
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {}
        return false;
    }

    public UUID login(String arg0, String arg1, String arg2) throws LoginException {
        return null;
    }

    protected static class RunAsRole
    implements Principal {
        private final String roleName;

        public RunAsRole(String roleName) {
            this.roleName = roleName;
        }

        @Override
        public String getName() {
            return this.roleName;
        }

        @Override
        public String toString() {
            return "[RunAsRole: " + this.roleName + "]";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RunAsRole runAsRole = (RunAsRole)o;
            return this.roleName.equals(runAsRole.roleName);
        }

        @Override
        public int hashCode() {
            return this.roleName.hashCode();
        }
    }

    @CallerPrincipal
    protected static class TomcatUserWrapper
    implements Principal {
        private final Realm realm;
        private final Principal tomcatPrincipal;

        public TomcatUserWrapper(Realm realm, Principal tomcatPrincipal) {
            this.realm = realm;
            this.tomcatPrincipal = tomcatPrincipal;
        }

        public Realm getRealm() {
            return this.realm;
        }

        public Principal getTomcatPrincipal() {
            return this.tomcatPrincipal;
        }

        @Override
        public String getName() {
            return this.tomcatPrincipal.getName();
        }

        @Override
        public String toString() {
            return "[TomcatUser: " + this.tomcatPrincipal + "]";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TomcatUserWrapper user = (TomcatUserWrapper)o;
            return this.realm.equals(user.realm) && this.tomcatPrincipal.equals(user.tomcatPrincipal);
        }

        @Override
        public int hashCode() {
            int result = this.realm.hashCode();
            result = 31 * result + this.tomcatPrincipal.hashCode();
            return result;
        }
    }

    private static class WebAppState {
        private final AbstractSecurityService.Identity oldIdentity;
        private final boolean hadRunAs;

        public WebAppState(AbstractSecurityService.Identity oldIdentity, boolean hadRunAs) {
            this.oldIdentity = oldIdentity;
            this.hadRunAs = hadRunAs;
        }
    }
}

