/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.finder;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.xbean.asm.AnnotationVisitor;
import org.apache.xbean.asm.Attribute;
import org.apache.xbean.asm.ClassReader;
import org.apache.xbean.asm.ClassVisitor;
import org.apache.xbean.asm.FieldVisitor;
import org.apache.xbean.asm.MethodVisitor;
import org.apache.xbean.asm.Type;
import org.apache.xbean.asm.commons.EmptyVisitor;
import org.apache.xbean.asm.signature.SignatureVisitor;
import org.apache.xbean.finder.Annotated;
import org.apache.xbean.finder.IAnnotationFinder;
import org.apache.xbean.finder.MetaAnnotatedClass;
import org.apache.xbean.finder.MetaAnnotatedField;
import org.apache.xbean.finder.MetaAnnotatedMethod;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.util.Classes;
import org.apache.xbean.finder.util.SingleLinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationFinder
implements IAnnotationFinder {
    private final Set<Class<? extends Annotation>> metaroots = new HashSet<Class<? extends Annotation>>();
    private final Map<String, List<Info>> annotated = new HashMap<String, List<Info>>();
    protected final Map<String, ClassInfo> classInfos = new HashMap<String, ClassInfo>();
    protected final Map<String, ClassInfo> originalInfos = new HashMap<String, ClassInfo>();
    private final List<String> classesNotLoaded = new ArrayList<String>();
    private final int ASM_FLAGS = 7;
    private final Archive archive;
    private final boolean checkRuntimeAnnotation;

    private AnnotationFinder(AnnotationFinder parent, Iterable<String> classNames) {
        ClassInfo info;
        this.archive = new SubArchive(classNames);
        this.checkRuntimeAnnotation = parent.checkRuntimeAnnotation;
        this.metaroots.addAll(parent.metaroots);
        for (Class<? extends Annotation> clazz : this.metaroots) {
            info = parent.classInfos.get(clazz.getName());
            if (info == null) continue;
            this.readClassDef(info);
        }
        for (String string : classNames) {
            info = parent.classInfos.get(string);
            if (info == null) continue;
            this.readClassDef(info);
        }
        this.resolveAnnotations(parent, new ArrayList<String>());
        for (ClassInfo classInfo : this.classInfos.values()) {
            if (!this.isMetaRoot(classInfo)) continue;
            try {
                this.metaroots.add(classInfo.get());
            }
            catch (ClassNotFoundException e) {
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        for (Class clazz : this.metaroots) {
            List<Info> infoList = this.annotated.get(clazz.getName());
            for (Info info2 : infoList) {
                String className = info2.getName() + "$$";
                ClassInfo i = parent.classInfos.get(className);
                if (i == null) continue;
                this.readClassDef(i);
            }
        }
    }

    public AnnotationFinder(Archive archive, boolean checkRuntimeAnnotation) {
        this.archive = archive;
        this.checkRuntimeAnnotation = checkRuntimeAnnotation;
        for (Archive.Entry entry : archive) {
            String className = entry.getName();
            try {
                this.readClassDef(entry.getBytecode());
            }
            catch (NoClassDefFoundError e) {
                throw new NoClassDefFoundError("Could not fully load class: " + className + "\n due to:" + e.getMessage());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.originalInfos.putAll(this.classInfos);
    }

    public AnnotationFinder(Archive archive) {
        this(archive, true);
    }

    public boolean hasMetaAnnotations() {
        return this.metaroots.size() > 0;
    }

    private void readClassDef(ClassInfo info) {
        this.classInfos.put(info.name, info);
        this.index(info);
        this.index(info.constructors);
        this.index(info.methods);
        this.index(info.fields);
    }

    private void resolveAnnotations(AnnotationFinder parent, List<String> scanned) {
        ArrayList<String> annotations = new ArrayList<String>(this.annotated.keySet());
        for (String annotation : annotations) {
            ClassInfo info;
            if (scanned.contains(annotation) || (info = parent.classInfos.get(annotation)) == null) continue;
            this.readClassDef(info);
        }
        if (this.annotated.keySet().size() != annotations.size()) {
            this.resolveAnnotations(parent, annotations);
        }
    }

    private void index(List<? extends Info> infos) {
        for (Info info : infos) {
            this.index(info);
        }
    }

    private void index(Info i) {
        for (AnnotationInfo annotationInfo : i.getAnnotations()) {
            this.index(annotationInfo, i);
        }
    }

    @Override
    public List<String> getAnnotatedClassNames() {
        return new ArrayList<String>(this.originalInfos.keySet());
    }

    public Archive getArchive() {
        return this.archive;
    }

    public AnnotationFinder link() {
        this.enableFindSubclasses();
        this.enableFindImplementations();
        this.enableMetaAnnotations();
        return this;
    }

    public AnnotationFinder enableMetaAnnotations() {
        this.resolveAnnotations(new ArrayList<String>());
        this.linkMetaAnnotations();
        return this;
    }

    public AnnotationFinder enableFindImplementations() {
        for (ClassInfo classInfo : this.classInfos.values().toArray(new ClassInfo[this.classInfos.size()])) {
            this.linkInterfaces(classInfo);
        }
        return this;
    }

    public AnnotationFinder enableFindSubclasses() {
        for (ClassInfo classInfo : this.classInfos.values().toArray(new ClassInfo[this.classInfos.size()])) {
            this.linkParent(classInfo);
        }
        return this;
    }

    private void resolveAnnotations(List<String> scanned) {
        ArrayList<String> annotations = new ArrayList<String>(this.annotated.keySet());
        for (String annotation : annotations) {
            if (scanned.contains(annotation)) continue;
            this.readClassDef(annotation);
        }
        if (this.annotated.keySet().size() != annotations.size()) {
            this.resolveAnnotations(annotations);
        }
    }

    private void linkMetaAnnotations() {
        for (ClassInfo classInfo : this.classInfos.values()) {
            if (!this.isMetaRoot(classInfo)) continue;
            try {
                this.metaroots.add(classInfo.get());
            }
            catch (ClassNotFoundException e) {
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        for (Class clazz : this.metaroots) {
            List<Info> infoList = this.annotated.get(clazz.getName());
            for (Info info : infoList) {
                this.readClassDef(info.getName() + "$$");
            }
        }
    }

    private boolean isMetaRoot(ClassInfo classInfo) {
        if (!classInfo.isAnnotation()) {
            return false;
        }
        if (classInfo.getName().equals("javax.annotation.Metatype")) {
            return true;
        }
        if (this.isSelfAnnotated(classInfo, "Metatype")) {
            return true;
        }
        if (this.isSelfAnnotated(classInfo, "Metaroot")) {
            return false;
        }
        for (AnnotationInfo annotationInfo : classInfo.getAnnotations()) {
            ClassInfo annotation = this.classInfos.get(annotationInfo.getName());
            if (annotation == null) {
                return false;
            }
            if (annotation.getName().equals("javax.annotation.Metaroot")) {
                return true;
            }
            if (!this.isSelfAnnotated(annotation, "Metaroot")) continue;
            return true;
        }
        return false;
    }

    private boolean isSelfAnnotated(ClassInfo classInfo, String metatype) {
        if (!classInfo.isAnnotation()) {
            return false;
        }
        String name = classInfo.getName();
        if (!this.hasName(name, metatype)) {
            return false;
        }
        for (AnnotationInfo info : classInfo.getAnnotations()) {
            if (!info.getName().equals(name)) continue;
            return true;
        }
        return true;
    }

    private boolean hasName(String className, String simpleName) {
        return className.equals(simpleName) || className.endsWith("." + simpleName) || className.endsWith("$" + simpleName);
    }

    private void linkParent(ClassInfo classInfo) {
        if (classInfo.superType == null) {
            return;
        }
        if (classInfo.superType.equals("java.lang.Object")) {
            return;
        }
        ClassInfo parentInfo = classInfo.superclassInfo;
        if (parentInfo == null) {
            parentInfo = this.classInfos.get(classInfo.superType);
            if (parentInfo == null) {
                if (classInfo.clazz != null) {
                    this.readClassDef(classInfo.clazz.getSuperclass());
                } else {
                    this.readClassDef(classInfo.superType);
                }
                parentInfo = this.classInfos.get(classInfo.superType);
                if (parentInfo == null) {
                    return;
                }
                this.linkParent(parentInfo);
            }
            classInfo.superclassInfo = parentInfo;
        }
        if (!parentInfo.subclassInfos.contains(classInfo)) {
            parentInfo.subclassInfos.add(classInfo);
        }
    }

    private void linkInterfaces(ClassInfo classInfo) {
        ArrayList<ClassInfo> infos = new ArrayList<ClassInfo>();
        if (classInfo.clazz != null) {
            Class<?>[] interfaces;
            for (Class<?> clazz : interfaces = classInfo.clazz.getInterfaces()) {
                ClassInfo interfaceInfo = this.classInfos.get(clazz.getName());
                if (interfaceInfo == null) {
                    this.readClassDef(clazz);
                }
                if ((interfaceInfo = this.classInfos.get(clazz.getName())) == null) continue;
                infos.add(interfaceInfo);
            }
        } else {
            for (String className : classInfo.interfaces) {
                ClassInfo interfaceInfo = this.classInfos.get(className);
                if (interfaceInfo == null) {
                    this.readClassDef(className);
                }
                if ((interfaceInfo = this.classInfos.get(className)) == null) continue;
                infos.add(interfaceInfo);
            }
        }
        for (ClassInfo info : infos) {
            this.linkInterfaces(info);
        }
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
        List<Info> infos = this.annotated.get(annotation.getName());
        return infos != null && !infos.isEmpty();
    }

    @Override
    public List<String> getClassesNotLoaded() {
        return Collections.unmodifiableList(this.classesNotLoaded);
    }

    @Override
    public List<Package> findAnnotatedPackages(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        ArrayList<Package> packages = new ArrayList<Package>();
        List<Info> infos = this.getAnnotationInfos(annotation.getName());
        for (Info info : infos) {
            if (!(info instanceof PackageInfo)) continue;
            PackageInfo packageInfo = (PackageInfo)info;
            try {
                Package pkg = packageInfo.get();
                if (this.checkRuntimeAnnotation && !pkg.isAnnotationPresent(annotation)) continue;
                packages.add(pkg);
            }
            catch (ClassNotFoundException e) {
                this.classesNotLoaded.add(packageInfo.getName());
            }
        }
        return packages;
    }

    @Override
    public List<Class<?>> findAnnotatedClasses(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        ArrayList classes = new ArrayList();
        List<Info> infos = this.getAnnotationInfos(annotation.getName());
        for (Info info : infos) {
            if (!(info instanceof ClassInfo)) continue;
            ClassInfo classInfo = (ClassInfo)info;
            try {
                Class<?> clazz = classInfo.get();
                if (this.checkRuntimeAnnotation && !clazz.isAnnotationPresent(annotation)) continue;
                classes.add(clazz);
            }
            catch (ClassNotFoundException e) {
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return classes;
    }

    @Override
    public List<Annotated<Class<?>>> findMetaAnnotatedClasses(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        Set<Class<?>> classes = this.findMetaAnnotatedClasses(annotation, new HashSet());
        ArrayList list = new ArrayList();
        for (Class<?> clazz : classes) {
            if (Annotation.class.isAssignableFrom(clazz) && AnnotationFinder.isMetaAnnotation(clazz)) continue;
            list.add(new MetaAnnotatedClass(clazz));
        }
        return list;
    }

    private static boolean isMetaAnnotation(Class<? extends Annotation> clazz) {
        for (Annotation annotation : clazz.getDeclaredAnnotations()) {
            if (!AnnotationFinder.isMetatypeAnnotation(annotation.annotationType())) continue;
            return true;
        }
        return false;
    }

    private static boolean isMetatypeAnnotation(Class<? extends Annotation> type) {
        if (AnnotationFinder.isSelfAnnotated(type, "Metatype")) {
            return true;
        }
        for (Annotation annotation : type.getAnnotations()) {
            if (!AnnotationFinder.isSelfAnnotated(annotation.annotationType(), "Metaroot")) continue;
            return true;
        }
        return false;
    }

    private static boolean isSelfAnnotated(Class<? extends Annotation> type, String name) {
        return type.isAnnotationPresent(type) && type.getSimpleName().equals(name) && AnnotationFinder.validTarget(type);
    }

    private static boolean validTarget(Class<? extends Annotation> type) {
        Target target = type.getAnnotation(Target.class);
        if (target == null) {
            return false;
        }
        ElementType[] targets = target.value();
        return targets.length == 1 && targets[0] == ElementType.ANNOTATION_TYPE;
    }

    private Set<Class<?>> findMetaAnnotatedClasses(Class<? extends Annotation> annotation, Set<Class<?>> classes) {
        List<Info> infos = this.getAnnotationInfos(annotation.getName());
        for (Info info : infos) {
            if (!(info instanceof ClassInfo)) continue;
            ClassInfo classInfo = (ClassInfo)info;
            try {
                String meta;
                Class<?> clazz = classInfo.get();
                if (classes.contains(clazz)) continue;
                if (!this.checkRuntimeAnnotation || clazz.isAnnotationPresent(annotation)) {
                    classes.add(clazz);
                }
                if ((meta = info.getMetaAnnotationName()) == null) continue;
                classes.addAll(this.findMetaAnnotatedClasses(clazz, classes));
            }
            catch (ClassNotFoundException e) {
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return classes;
    }

    @Override
    public List<Class<?>> findInheritedAnnotatedClasses(Class<? extends Annotation> annotation) {
        boolean annClassFound;
        this.classesNotLoaded.clear();
        ArrayList classes = new ArrayList();
        List<Info> infos = this.getAnnotationInfos(annotation.getName());
        for (Info info : infos) {
            try {
                if (!(info instanceof ClassInfo)) continue;
                classes.add(((ClassInfo)info).get());
            }
            catch (ClassNotFoundException cnfe) {}
        }
        ArrayList<ClassInfo> tempClassInfos = new ArrayList<ClassInfo>(this.classInfos.values());
        do {
            annClassFound = false;
            for (int pos = 0; pos < tempClassInfos.size(); ++pos) {
                ClassInfo classInfo = (ClassInfo)tempClassInfos.get(pos);
                try {
                    String superType = classInfo.getSuperType();
                    for (Class clazz : classes) {
                        if (!superType.equals(clazz.getName())) continue;
                        classes.add(classInfo.get());
                        tempClassInfos.remove(pos);
                        annClassFound = true;
                        break;
                    }
                    List<String> interfces = classInfo.getInterfaces();
                    block9: for (String interfce : interfces) {
                        for (Class clazz : classes) {
                            if (!interfce.replaceFirst("<.*>", "").equals(clazz.getName())) continue;
                            classes.add(classInfo.get());
                            tempClassInfos.remove(pos);
                            annClassFound = true;
                            continue block9;
                        }
                    }
                    continue;
                }
                catch (ClassNotFoundException e) {
                    this.classesNotLoaded.add(classInfo.getName());
                    continue;
                }
                catch (NoClassDefFoundError e) {
                    this.classesNotLoaded.add(classInfo.getName());
                }
            }
        } while (annClassFound);
        return classes;
    }

    @Override
    public List<Method> findAnnotatedMethods(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        ArrayList<ClassInfo> seen = new ArrayList<ClassInfo>();
        ArrayList<Method> methods = new ArrayList<Method>();
        List<Info> infos = this.getAnnotationInfos(annotation.getName());
        for (Info info : infos) {
            MethodInfo methodInfo;
            ClassInfo classInfo;
            if (!(info instanceof MethodInfo) || info.getName().equals("<init>") || seen.contains(classInfo = (methodInfo = (MethodInfo)info).getDeclaringClass())) continue;
            seen.add(classInfo);
            try {
                Class<?> clazz = classInfo.get();
                for (Method method : clazz.getDeclaredMethods()) {
                    if (this.checkRuntimeAnnotation && !method.isAnnotationPresent(annotation)) continue;
                    methods.add(method);
                }
            }
            catch (ClassNotFoundException e) {
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return methods;
    }

    @Override
    public List<Annotated<Method>> findMetaAnnotatedMethods(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        Set<Method> methods = this.findMetaAnnotatedMethods(annotation, new HashSet<Method>(), new HashSet<String>());
        ArrayList<Annotated<Method>> targets = new ArrayList<Annotated<Method>>();
        for (Method method : methods) {
            targets.add(new MetaAnnotatedMethod(method));
        }
        return targets;
    }

    private Set<Method> findMetaAnnotatedMethods(Class<? extends Annotation> annotation, Set<Method> methods, Set<String> seen) {
        List<Info> infos = this.getAnnotationInfos(annotation.getName());
        for (Info info : infos) {
            String meta = info.getMetaAnnotationName();
            if (meta != null) {
                Class<?> clazz;
                if (meta.equals(annotation.getName()) || !seen.add(meta)) continue;
                ClassInfo metaInfo = this.classInfos.get(meta);
                try {
                    clazz = metaInfo.get();
                }
                catch (ClassNotFoundException e) {
                    this.classesNotLoaded.add(metaInfo.getName());
                    continue;
                }
                this.findMetaAnnotatedMethods(clazz, methods, seen);
                continue;
            }
            if (!(info instanceof MethodInfo) || ((MethodInfo)info).isConstructor()) continue;
            MethodInfo methodInfo = (MethodInfo)info;
            ClassInfo classInfo = methodInfo.getDeclaringClass();
            try {
                Class<?> clazz = classInfo.get();
                for (Method method : clazz.getDeclaredMethods()) {
                    if (this.checkRuntimeAnnotation && !method.isAnnotationPresent(annotation)) continue;
                    methods.add(method);
                }
            }
            catch (ClassNotFoundException e) {
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return methods;
    }

    @Override
    public List<Annotated<Field>> findMetaAnnotatedFields(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        Set<Field> fields = this.findMetaAnnotatedFields(annotation, new HashSet<Field>(), new HashSet<String>());
        ArrayList<Annotated<Field>> targets = new ArrayList<Annotated<Field>>();
        for (Field field : fields) {
            targets.add(new MetaAnnotatedField(field));
        }
        return targets;
    }

    private Set<Field> findMetaAnnotatedFields(Class<? extends Annotation> annotation, Set<Field> fields, Set<String> seen) {
        List<Info> infos = this.getAnnotationInfos(annotation.getName());
        for (Info info : infos) {
            String meta = info.getMetaAnnotationName();
            if (meta != null) {
                Class<?> clazz;
                if (meta.equals(annotation.getName()) || !seen.add(meta)) continue;
                ClassInfo metaInfo = this.classInfos.get(meta);
                try {
                    clazz = metaInfo.get();
                }
                catch (ClassNotFoundException e) {
                    this.classesNotLoaded.add(metaInfo.getName());
                    continue;
                }
                this.findMetaAnnotatedFields(clazz, fields, seen);
                continue;
            }
            if (!(info instanceof FieldInfo)) continue;
            FieldInfo fieldInfo = (FieldInfo)info;
            ClassInfo classInfo = fieldInfo.getDeclaringClass();
            try {
                Class<?> clazz = classInfo.get();
                for (Field field : clazz.getDeclaredFields()) {
                    if (this.checkRuntimeAnnotation && !field.isAnnotationPresent(annotation)) continue;
                    fields.add(field);
                }
            }
            catch (ClassNotFoundException e) {
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return fields;
    }

    @Override
    public List<Constructor> findAnnotatedConstructors(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        ArrayList<ClassInfo> seen = new ArrayList<ClassInfo>();
        ArrayList<Constructor> constructors = new ArrayList<Constructor>();
        List<Info> infos = this.getAnnotationInfos(annotation.getName());
        for (Info info : infos) {
            MethodInfo methodInfo;
            ClassInfo classInfo;
            if (!(info instanceof MethodInfo) || !info.getName().equals("<init>") || seen.contains(classInfo = (methodInfo = (MethodInfo)info).getDeclaringClass())) continue;
            seen.add(classInfo);
            try {
                Class<?> clazz = classInfo.get();
                for (Constructor<?> constructor : clazz.getConstructors()) {
                    if (this.checkRuntimeAnnotation && !constructor.isAnnotationPresent(annotation)) continue;
                    constructors.add(constructor);
                }
            }
            catch (ClassNotFoundException e) {
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return constructors;
    }

    @Override
    public List<Field> findAnnotatedFields(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        ArrayList<ClassInfo> seen = new ArrayList<ClassInfo>();
        ArrayList<Field> fields = new ArrayList<Field>();
        List<Info> infos = this.getAnnotationInfos(annotation.getName());
        for (Info info : infos) {
            FieldInfo fieldInfo;
            ClassInfo classInfo;
            if (!(info instanceof FieldInfo) || seen.contains(classInfo = (fieldInfo = (FieldInfo)info).getDeclaringClass())) continue;
            seen.add(classInfo);
            try {
                Class<?> clazz = classInfo.get();
                for (Field field : clazz.getDeclaredFields()) {
                    if (this.checkRuntimeAnnotation && !field.isAnnotationPresent(annotation)) continue;
                    fields.add(field);
                }
            }
            catch (ClassNotFoundException e) {
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return fields;
    }

    @Override
    public List<Class<?>> findClassesInPackage(String packageName, boolean recursive) {
        this.classesNotLoaded.clear();
        ArrayList classes = new ArrayList();
        for (ClassInfo classInfo : this.classInfos.values()) {
            try {
                if (recursive && classInfo.getPackageName().startsWith(packageName)) {
                    classes.add(classInfo.get());
                    continue;
                }
                if (!classInfo.getPackageName().equals(packageName)) continue;
                classes.add(classInfo.get());
            }
            catch (ClassNotFoundException e) {
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return classes;
    }

    @Override
    public <T> List<Class<? extends T>> findSubclasses(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("class cannot be null");
        }
        this.classesNotLoaded.clear();
        ClassInfo classInfo = this.classInfos.get(clazz.getName());
        ArrayList<Class<? extends T>> found = new ArrayList<Class<? extends T>>();
        if (classInfo == null) {
            return found;
        }
        this.findSubclasses(classInfo, found, clazz);
        return found;
    }

    private <T> void findSubclasses(ClassInfo classInfo, List<Class<? extends T>> found, Class<T> clazz) {
        for (ClassInfo subclassInfo : classInfo.subclassInfos) {
            try {
                found.add(subclassInfo.get().asSubclass(clazz));
            }
            catch (ClassNotFoundException e) {
                this.classesNotLoaded.add(subclassInfo.getName());
            }
            this.findSubclasses(subclassInfo, found, clazz);
        }
    }

    private <T> List<Class<? extends T>> _findSubclasses(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("class cannot be null");
        }
        ArrayList<Class<T>> classes = new ArrayList<Class<T>>();
        for (ClassInfo classInfo : this.classInfos.values()) {
            try {
                if (!clazz.getName().equals(classInfo.superType) || !clazz.isAssignableFrom(classInfo.get())) continue;
                classes.add(classInfo.get().asSubclass(clazz));
                classes.addAll(this._findSubclasses(classInfo.get().asSubclass(clazz)));
            }
            catch (ClassNotFoundException e) {
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return classes;
    }

    @Override
    public <T> List<Class<? extends T>> findImplementations(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("class cannot be null");
        }
        if (!clazz.isInterface()) {
            new IllegalArgumentException("class must be an interface");
        }
        this.classesNotLoaded.clear();
        String interfaceName = clazz.getName();
        List<ClassInfo> infos = this.collectImplementations(interfaceName);
        ArrayList<Class<T>> classes = new ArrayList<Class<T>>();
        for (ClassInfo info : infos) {
            try {
                Class<?> impl = info.get();
                if (!clazz.isAssignableFrom(impl)) continue;
                classes.add(impl);
                classes.addAll(this._findSubclasses(impl));
            }
            catch (ClassNotFoundException e) {
                this.classesNotLoaded.add(info.getName());
            }
        }
        return classes;
    }

    private List<ClassInfo> collectImplementations(String interfaceName) {
        ArrayList<ClassInfo> infos = new ArrayList<ClassInfo>();
        for (ClassInfo classInfo : this.classInfos.values()) {
            if (!classInfo.interfaces.contains(interfaceName)) continue;
            infos.add(classInfo);
            try {
                Class<?> clazz = classInfo.get();
                if (!clazz.isInterface() || clazz.isAnnotation()) continue;
                infos.addAll(this.collectImplementations(classInfo.name));
            }
            catch (ClassNotFoundException ignore) {}
        }
        return infos;
    }

    protected List<Info> getAnnotationInfos(String name) {
        List<Info> infos = this.annotated.get(name);
        if (infos != null) {
            return infos;
        }
        return Collections.EMPTY_LIST;
    }

    protected List<Info> initAnnotationInfos(String name) {
        List<Info> infos = this.annotated.get(name);
        if (infos == null) {
            infos = new SingleLinkedList<Info>();
            this.annotated.put(name, infos);
        }
        return infos;
    }

    protected void readClassDef(String className) {
        if (this.classInfos.containsKey(className)) {
            return;
        }
        try {
            this.readClassDef(this.archive.getBytecode(className));
        }
        catch (Exception e) {
            if (className.endsWith("$$")) {
                return;
            }
            this.classesNotLoaded.add(className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readClassDef(InputStream in) throws IOException {
        try {
            ClassReader classReader = new ClassReader(in);
            classReader.accept((ClassVisitor)new InfoBuildingVisitor(), 7);
        }
        finally {
            in.close();
        }
    }

    protected void readClassDef(Class clazz) {
        ArrayList<Annotatable> infos = new ArrayList<Annotatable>();
        Package aPackage = clazz.getPackage();
        if (aPackage != null) {
            PackageInfo info = new PackageInfo(aPackage);
            for (AnnotationInfo annotationInfo : info.getAnnotations()) {
                List<Info> annotationInfos = this.initAnnotationInfos(annotationInfo.getName());
                if (annotationInfos.contains(info)) continue;
                annotationInfos.add(info);
            }
        }
        ClassInfo classInfo = new ClassInfo(clazz);
        infos.add(classInfo);
        this.classInfos.put(clazz.getName(), classInfo);
        for (Method method : clazz.getDeclaredMethods()) {
            infos.add(new MethodInfo(classInfo, method));
        }
        for (Executable executable : clazz.getConstructors()) {
            infos.add(new MethodInfo(classInfo, (Constructor)executable));
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
            infos.add(new FieldInfo(classInfo, (Field)accessibleObject));
        }
        for (Info info : infos) {
            for (AnnotationInfo annotationInfo : info.getAnnotations()) {
                List<Info> annotationInfos = this.initAnnotationInfos(annotationInfo.getName());
                annotationInfos.add(info);
            }
        }
    }

    public AnnotationFinder select(Class<?> ... clazz) {
        String[] names = new String[clazz.length];
        int i = 0;
        for (Class<?> name : clazz) {
            names[i++] = name.getName();
        }
        return new AnnotationFinder(this, Arrays.asList(names));
    }

    public AnnotationFinder select(String ... clazz) {
        return new AnnotationFinder(this, Arrays.asList(clazz));
    }

    public AnnotationFinder select(Iterable<String> clazz) {
        return new AnnotationFinder(this, clazz);
    }

    private void index(AnnotationInfo annotationInfo, Info info) {
        this.initAnnotationInfos(annotationInfo.getName()).add(info);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Annotatable {
        private final List<AnnotationInfo> annotations = new ArrayList<AnnotationInfo>();

        public Annotatable(AnnotatedElement element) {
            for (Annotation annotation : this.getAnnotations(element)) {
                this.annotations.add(new AnnotationInfo(annotation.annotationType().getName()));
            }
        }

        public Annotatable() {
        }

        public Annotation[] getDeclaredAnnotations() {
            return new Annotation[0];
        }

        public List<AnnotationInfo> getAnnotations() {
            return this.annotations;
        }

        public String getMetaAnnotationName() {
            return null;
        }

        private Annotation[] getAnnotations(AnnotatedElement element) {
            try {
                return element.getAnnotations();
            }
            catch (LinkageError e) {
                return element.getAnnotations();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AnnotationInfo
    extends Annotatable
    implements Info {
        private final String name;

        public AnnotationInfo(Annotation annotation) {
            this(annotation.getClass().getName());
        }

        public AnnotationInfo(Class<? extends Annotation> annotation) {
            this.name = annotation.getName().intern();
        }

        public AnnotationInfo(String name) {
            name = Type.getType((String)name).getClassName();
            this.name = name.intern();
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ClassInfo
    extends Annotatable
    implements Info {
        private String name;
        private final List<MethodInfo> methods;
        private final List<MethodInfo> constructors;
        private String superType;
        private ClassInfo superclassInfo;
        private final List<ClassInfo> subclassInfos;
        private final List<String> interfaces;
        private final List<FieldInfo> fields;
        private Class<?> clazz;

        public ClassInfo(Class clazz) {
            super(clazz);
            this.methods = new SingleLinkedList<MethodInfo>();
            this.constructors = new SingleLinkedList<MethodInfo>();
            this.subclassInfos = new SingleLinkedList<ClassInfo>();
            this.interfaces = new SingleLinkedList<String>();
            this.fields = new SingleLinkedList<FieldInfo>();
            this.clazz = clazz;
            this.name = clazz.getName();
            Class superclass = clazz.getSuperclass();
            this.superType = superclass != null ? superclass.getName() : null;
            for (Class<?> intrface : clazz.getInterfaces()) {
                this.interfaces.add(intrface.getName());
            }
        }

        public ClassInfo(String name, String superType) {
            this.methods = new SingleLinkedList<MethodInfo>();
            this.constructors = new SingleLinkedList<MethodInfo>();
            this.subclassInfos = new SingleLinkedList<ClassInfo>();
            this.interfaces = new SingleLinkedList<String>();
            this.fields = new SingleLinkedList<FieldInfo>();
            this.name = name;
            this.superType = superType;
        }

        @Override
        public String getMetaAnnotationName() {
            ClassInfo info;
            for (AnnotationInfo info2 : this.getAnnotations()) {
                for (Class metaroot : AnnotationFinder.this.metaroots) {
                    if (!info2.getName().equals(metaroot.getName())) continue;
                    return this.name;
                }
            }
            if (this.name.endsWith("$$") && (info = AnnotationFinder.this.classInfos.get(this.name.substring(0, this.name.length() - 2))) != null) {
                return info.getMetaAnnotationName();
            }
            return null;
        }

        public String getPackageName() {
            return this.name.indexOf(".") > 0 ? this.name.substring(0, this.name.lastIndexOf(".")) : "";
        }

        public List<MethodInfo> getConstructors() {
            return this.constructors;
        }

        public List<String> getInterfaces() {
            return this.interfaces;
        }

        public List<FieldInfo> getFields() {
            return this.fields;
        }

        public List<MethodInfo> getMethods() {
            return this.methods;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String getSuperType() {
            return this.superType;
        }

        public boolean isAnnotation() {
            return "java.lang.Object".equals(this.superType) && this.interfaces.size() == 1 && "java.lang.annotation.Annotation".equals(this.interfaces.get(0));
        }

        public Class<?> get() throws ClassNotFoundException {
            if (this.clazz != null) {
                return this.clazz;
            }
            try {
                String fixedName = this.name.replaceFirst("<.*>", "");
                this.clazz = AnnotationFinder.this.archive.loadClass(fixedName);
                return this.clazz;
            }
            catch (ClassNotFoundException notFound) {
                AnnotationFinder.this.classesNotLoaded.add(this.name);
                throw notFound;
            }
        }

        public String toString() {
            return this.name;
        }
    }

    public class FieldInfo
    extends Annotatable
    implements Info {
        private final String name;
        private final String type;
        private final ClassInfo declaringClass;
        private Field field;

        public FieldInfo(ClassInfo info, Field field) {
            super(field);
            this.declaringClass = info;
            this.name = field.getName();
            this.type = field.getType().getName();
            this.field = field;
        }

        public FieldInfo(ClassInfo declaringClass, String name, String type) {
            this.declaringClass = declaringClass;
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public ClassInfo getDeclaringClass() {
            return this.declaringClass;
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return this.declaringClass + "#" + this.name;
        }

        public String getMetaAnnotationName() {
            return this.declaringClass.getMetaAnnotationName();
        }

        public Annotation[] getDeclaredAnnotations() {
            super.getDeclaredAnnotations();
            try {
                return ((AnnotatedElement)((Object)this.get())).getDeclaredAnnotations();
            }
            catch (ClassNotFoundException e) {
                return super.getDeclaredAnnotations();
            }
        }

        public Member get() throws ClassNotFoundException {
            if (this.field == null) {
                this.field = this.toField();
            }
            return this.field;
        }

        private Field toField() throws ClassNotFoundException {
            Class<?> clazz = this.declaringClass.get();
            try {
                return clazz.getDeclaredField(this.name);
            }
            catch (NoSuchFieldException e) {
                throw new IllegalStateException(this.name, e);
            }
        }
    }

    public static class GenericAwareInfoBuildingVisitor
    implements SignatureVisitor {
        private Info info;
        private TYPE type;
        private STATE state;
        private static boolean debug = false;

        public GenericAwareInfoBuildingVisitor() {
        }

        public GenericAwareInfoBuildingVisitor(TYPE type, Info info) {
            this.type = type;
            this.info = info;
            this.state = STATE.BEGIN;
        }

        public void visitFormalTypeParameter(String s) {
            if (debug) {
                System.out.println(" s=" + s);
            }
            switch (this.state) {
                case BEGIN: {
                    ((ClassInfo)this.info).name = ((ClassInfo)this.info).name + ("<" + s);
                }
            }
            this.state = STATE.FORMAL_TYPE_PARAM;
        }

        public SignatureVisitor visitClassBound() {
            if (debug) {
                System.out.println(" visitClassBound()");
            }
            return this;
        }

        public SignatureVisitor visitInterfaceBound() {
            if (debug) {
                System.out.println(" visitInterfaceBound()");
            }
            return this;
        }

        public SignatureVisitor visitSuperclass() {
            if (debug) {
                System.out.println(" visitSuperclass()");
            }
            this.state = STATE.SUPERCLASS;
            return this;
        }

        public SignatureVisitor visitInterface() {
            if (debug) {
                System.out.println(" visitInterface()");
            }
            ((ClassInfo)this.info).getInterfaces().add("");
            this.state = STATE.INTERFACE;
            return this;
        }

        public SignatureVisitor visitParameterType() {
            if (debug) {
                System.out.println(" visitParameterType()");
            }
            return this;
        }

        public SignatureVisitor visitReturnType() {
            if (debug) {
                System.out.println(" visitReturnType()");
            }
            return this;
        }

        public SignatureVisitor visitExceptionType() {
            if (debug) {
                System.out.println(" visitExceptionType()");
            }
            return this;
        }

        public void visitBaseType(char c) {
            if (debug) {
                System.out.println(" visitBaseType(" + c + ")");
            }
        }

        public void visitTypeVariable(String s) {
            if (debug) {
                System.out.println(" visitTypeVariable(" + s + ")");
            }
        }

        public SignatureVisitor visitArrayType() {
            if (debug) {
                System.out.println(" visitArrayType()");
            }
            return this;
        }

        public void visitClassType(String s) {
            if (debug) {
                System.out.println(" visitClassType(" + s + ")");
            }
            switch (this.state) {
                case INTERFACE: {
                    List<String> interfces = ((ClassInfo)this.info).getInterfaces();
                    int idx = interfces.size() - 1;
                    String interfce = interfces.get(idx);
                    interfce = interfce.length() == 0 ? this.javaName(s) : interfce + this.javaName(s);
                    interfces.set(idx, interfce);
                    break;
                }
                case SUPERCLASS: {
                    if (s.equals("java/lang/Object")) break;
                    ((ClassInfo)this.info).superType = this.javaName(s);
                }
            }
        }

        public void visitInnerClassType(String s) {
            if (debug) {
                System.out.println(" visitInnerClassType(" + s + ")");
            }
        }

        public void visitTypeArgument() {
            if (debug) {
                System.out.println(" visitTypeArgument()");
            }
            switch (this.state) {
                case INTERFACE: {
                    List<String> interfces = ((ClassInfo)this.info).getInterfaces();
                    int idx = interfces.size() - 1;
                    String interfce = interfces.get(idx);
                    interfce = interfce + "<";
                    interfces.set(idx, interfce);
                }
            }
        }

        public SignatureVisitor visitTypeArgument(char c) {
            if (debug) {
                System.out.println(" visitTypeArgument(" + c + ")");
            }
            switch (this.state) {
                case INTERFACE: {
                    List<String> interfces = ((ClassInfo)this.info).getInterfaces();
                    int idx = interfces.size() - 1;
                    String interfce = interfces.get(idx);
                    interfce = interfce + "<";
                    interfces.set(idx, interfce);
                }
            }
            return this;
        }

        public void visitEnd() {
            if (debug) {
                System.out.println(" visitEnd()");
            }
            switch (this.state) {
                case INTERFACE: {
                    List<String> interfces = ((ClassInfo)this.info).getInterfaces();
                    int idx = interfces.size() - 1;
                    String interfce = interfces.get(idx);
                    interfce = interfce + ">";
                    interfces.set(idx, interfce);
                    break;
                }
                case FORMAL_TYPE_PARAM: {
                    String name = ((ClassInfo)this.info).name;
                    if (!name.contains("<")) break;
                    ((ClassInfo)this.info).name = ((ClassInfo)this.info).name + ">";
                }
            }
            this.state = STATE.END;
        }

        private String javaName(String name) {
            return name == null ? null : name.replace('/', '.');
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum STATE {
            BEGIN,
            END,
            SUPERCLASS,
            INTERFACE,
            FORMAL_TYPE_PARAM;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum TYPE {
            CLASS;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Info {
        public String getMetaAnnotationName();

        public String getName();

        public List<AnnotationInfo> getAnnotations();

        public Annotation[] getDeclaredAnnotations();
    }

    public class InfoBuildingVisitor
    extends EmptyVisitor {
        private Info info;

        public InfoBuildingVisitor() {
        }

        public InfoBuildingVisitor(Info info) {
            this.info = info;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if (name.endsWith("package-info")) {
                this.info = new PackageInfo(this.javaName(name));
            } else {
                ClassInfo classInfo = new ClassInfo(this.javaName(name), this.javaName(superName));
                for (String interfce : interfaces) {
                    classInfo.getInterfaces().add(this.javaName(interfce));
                }
                this.info = classInfo;
                AnnotationFinder.this.classInfos.put(classInfo.getName(), classInfo);
            }
        }

        private String javaName(String name) {
            return name == null ? null : name.replace('/', '.');
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            super.visitInnerClass(name, outerName, innerName, access);
        }

        public void visitAttribute(Attribute attribute) {
            super.visitAttribute(attribute);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AnnotationInfo annotationInfo = new AnnotationInfo(desc);
            this.info.getAnnotations().add(annotationInfo);
            AnnotationFinder.this.index(annotationInfo, this.info);
            return new InfoBuildingVisitor(annotationInfo);
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            ClassInfo classInfo = (ClassInfo)this.info;
            FieldInfo fieldInfo = new FieldInfo(classInfo, name, desc);
            classInfo.getFields().add(fieldInfo);
            return new InfoBuildingVisitor(fieldInfo);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            ClassInfo classInfo = (ClassInfo)this.info;
            MethodInfo methodInfo = new MethodInfo(classInfo, name, desc);
            classInfo.getMethods().add(methodInfo);
            return new InfoBuildingVisitor(methodInfo);
        }

        public AnnotationVisitor visitParameterAnnotation(int param, String desc, boolean visible) {
            MethodInfo methodInfo = (MethodInfo)this.info;
            List<AnnotationInfo> annotationInfos = methodInfo.getParameterAnnotations(param);
            AnnotationInfo annotationInfo = new AnnotationInfo(desc);
            annotationInfos.add(annotationInfo);
            return new InfoBuildingVisitor(annotationInfo);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MethodInfo
    extends Annotatable
    implements Info {
        private final ClassInfo declaringClass;
        private final String descriptor;
        private final String name;
        private final List<List<AnnotationInfo>> parameterAnnotations;
        private Member method;

        public MethodInfo(ClassInfo info, Constructor constructor) {
            super(constructor);
            this.parameterAnnotations = new ArrayList<List<AnnotationInfo>>();
            this.declaringClass = info;
            this.name = "<init>";
            this.descriptor = null;
        }

        public MethodInfo(ClassInfo info, Method method) {
            super(method);
            this.parameterAnnotations = new ArrayList<List<AnnotationInfo>>();
            this.declaringClass = info;
            this.name = method.getName();
            this.descriptor = method.getReturnType().getName();
            this.method = method;
        }

        public MethodInfo(ClassInfo declarignClass, String name, String descriptor) {
            this.parameterAnnotations = new ArrayList<List<AnnotationInfo>>();
            this.declaringClass = declarignClass;
            this.name = name;
            this.descriptor = descriptor;
        }

        @Override
        public String getMetaAnnotationName() {
            return this.declaringClass.getMetaAnnotationName();
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            super.getDeclaredAnnotations();
            try {
                return ((AnnotatedElement)((Object)this.get())).getDeclaredAnnotations();
            }
            catch (ClassNotFoundException e) {
                return super.getDeclaredAnnotations();
            }
        }

        public boolean isConstructor() {
            return this.getName().equals("<init>");
        }

        public List<List<AnnotationInfo>> getParameterAnnotations() {
            return this.parameterAnnotations;
        }

        public List<AnnotationInfo> getParameterAnnotations(int index) {
            if (index >= this.parameterAnnotations.size()) {
                for (int i = this.parameterAnnotations.size(); i <= index; ++i) {
                    ArrayList annotationInfos = new ArrayList();
                    this.parameterAnnotations.add(i, annotationInfos);
                }
            }
            return this.parameterAnnotations.get(index);
        }

        @Override
        public String getName() {
            return this.name;
        }

        public ClassInfo getDeclaringClass() {
            return this.declaringClass;
        }

        public String toString() {
            return this.declaringClass + "@" + this.name;
        }

        public Member get() throws ClassNotFoundException {
            if (this.method == null) {
                this.method = this.toMethod();
            }
            return this.method;
        }

        private Method toMethod() throws ClassNotFoundException {
            org.apache.xbean.asm.commons.Method method = new org.apache.xbean.asm.commons.Method(this.name, this.descriptor);
            Class<?> clazz = this.declaringClass.get();
            ArrayList<Class> parameterTypes = new ArrayList<Class>();
            for (Type type : method.getArgumentTypes()) {
                String paramType = type.getClassName();
                try {
                    parameterTypes.add(Classes.forName(paramType, clazz.getClassLoader()));
                }
                catch (ClassNotFoundException cnfe) {
                    throw new IllegalStateException("Parameter class could not be loaded for type " + paramType, cnfe);
                }
            }
            Class[] parameters = parameterTypes.toArray(new Class[parameterTypes.size()]);
            IllegalStateException noSuchMethod = null;
            while (clazz != null) {
                try {
                    return clazz.getDeclaredMethod(this.name, parameters);
                }
                catch (NoSuchMethodException e) {
                    if (noSuchMethod == null) {
                        noSuchMethod = new IllegalStateException("Callback method does not exist: " + clazz.getName() + "." + this.name, e);
                    }
                    clazz = clazz.getSuperclass();
                }
            }
            throw noSuchMethod;
        }
    }

    public class PackageInfo
    extends Annotatable
    implements Info {
        private final String name;
        private final ClassInfo info;
        private final Package pkg;

        public PackageInfo(Package pkg) {
            super(pkg);
            this.pkg = pkg;
            this.name = pkg.getName();
            this.info = null;
        }

        public PackageInfo(String name) {
            this.info = new ClassInfo(name, null);
            this.name = name;
            this.pkg = null;
        }

        public String getName() {
            return this.name;
        }

        public Package get() throws ClassNotFoundException {
            return this.pkg != null ? this.pkg : this.info.get().getPackage();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PackageInfo that = (PackageInfo)o;
            return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SubArchive
    implements Archive {
        private List<Archive.Entry> classes = new ArrayList<Archive.Entry>();

        public SubArchive(String ... classes) {
            for (String name : classes) {
                this.classes.add(new E(name));
            }
        }

        public SubArchive(Iterable<String> classes) {
            for (String name : classes) {
                this.classes.add(new E(name));
            }
        }

        @Override
        public InputStream getBytecode(String className) throws IOException, ClassNotFoundException {
            return AnnotationFinder.this.archive.getBytecode(className);
        }

        @Override
        public Class<?> loadClass(String className) throws ClassNotFoundException {
            return AnnotationFinder.this.archive.loadClass(className);
        }

        @Override
        public Iterator<Archive.Entry> iterator() {
            return this.classes.iterator();
        }

        public class E
        implements Archive.Entry {
            private final String name;

            public E(String name) {
                this.name = name;
            }

            public String getName() {
                return this.name;
            }

            public InputStream getBytecode() throws IOException {
                return new ByteArrayInputStream(new byte[0]);
            }
        }
    }
}

