/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.model.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.model.IListChangeListener;
import org.eclipse.persistence.jpa.jpql.model.ISelectExpressionStateObjectBuilder;
import org.eclipse.persistence.jpa.jpql.model.query.AbstractSelectClauseStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.FromClauseStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.ListHolderStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.ResultVariableStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.SelectStatementStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObjectVisitor;
import org.eclipse.persistence.jpa.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.jpql.util.iterator.CloneListIterator;
import org.eclipse.persistence.jpa.jpql.util.iterator.IterableListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectClauseStateObject
extends AbstractSelectClauseStateObject
implements ListHolderStateObject<StateObject> {
    private ISelectExpressionStateObjectBuilder builder;
    private List<StateObject> items;
    public static final String SELECT_ITEMS_LIST = "selectItems";

    public SelectClauseStateObject(SelectStatementStateObject parent) {
        super(parent);
    }

    @Override
    public void accept(StateObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void addChildren(List<StateObject> children) {
        super.addChildren(children);
        children.addAll(this.items);
    }

    public ResultVariableStateObject addItem(StateObject stateObject, String resultVariable) {
        ResultVariableStateObject item = new ResultVariableStateObject(this, stateObject, false, resultVariable);
        this.addItem((StateObject)item);
        return item;
    }

    @Override
    public StateObject addItem(String jpqlFragment) {
        Object item = this.buildStateObject(jpqlFragment, "select_expression");
        this.addItem((StateObject)item);
        return item;
    }

    public ResultVariableStateObject addItem(String jpqlFragment, String resultVariable) {
        ResultVariableStateObject item = new ResultVariableStateObject(this);
        item.parse(jpqlFragment);
        item.setResultVariable(resultVariable);
        this.addItem((StateObject)item);
        return item;
    }

    @Override
    public <S extends StateObject> S addItem(S item) {
        this.getChangeSupport().addItem(this, this.items, SELECT_ITEMS_LIST, this.parent(item));
        return item;
    }

    public ResultVariableStateObject addItemAs(StateObject stateObject, String resultVariable) {
        ResultVariableStateObject item = new ResultVariableStateObject(this, stateObject, true, resultVariable);
        this.addItem((StateObject)item);
        return item;
    }

    public ResultVariableStateObject addItemAs(String jpqlFragment, String resultVariable) {
        ResultVariableStateObject item = new ResultVariableStateObject(this);
        item.addAs();
        item.parse(jpqlFragment);
        item.setResultVariable(resultVariable);
        this.addItem((StateObject)item);
        return item;
    }

    @Override
    public void addItems(List<? extends StateObject> items) {
        this.getChangeSupport().addItems(this, this.items, SELECT_ITEMS_LIST, this.parent(items));
    }

    @Override
    public void addListChangeListener(String listName, IListChangeListener<StateObject> listener) {
        this.getChangeSupport().addListChangeListener(listName, listener);
    }

    protected boolean areChildrenEquivalent(SelectClauseStateObject stateObject) {
        int size = this.itemsSize();
        if (size != stateObject.itemsSize()) {
            return false;
        }
        int index = size;
        while (--index >= 0) {
            StateObject child2;
            StateObject child1 = this.getItem(index);
            if (child1.isEquivalent(child2 = stateObject.getItem(index))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canMoveDown(StateObject item) {
        return this.getChangeSupport().canMoveDown(this.items, item);
    }

    @Override
    public boolean canMoveUp(StateObject item) {
        return this.getChangeSupport().canMoveUp(this.items, item);
    }

    public ISelectExpressionStateObjectBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = this.getQueryBuilder().buildStateObjectBuilder(this);
        }
        return this.builder;
    }

    @Override
    public SelectClause getExpression() {
        return (SelectClause)super.getExpression();
    }

    @Override
    public FromClauseStateObject getFromClause() {
        return (FromClauseStateObject)super.getFromClause();
    }

    @Override
    public StateObject getItem(int index) {
        return this.items.get(index);
    }

    @Override
    public SelectStatementStateObject getParent() {
        return (SelectStatementStateObject)super.getParent();
    }

    @Override
    public boolean hasItems() {
        return this.items.size() > 0;
    }

    @Override
    public boolean hasSelectItem() {
        return this.hasItems();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.items = new ArrayList<StateObject>();
    }

    @Override
    public boolean isEquivalent(StateObject stateObject) {
        return super.isEquivalent(stateObject) && this.areChildrenEquivalent((SelectClauseStateObject)stateObject);
    }

    @Override
    public IterableListIterator<StateObject> items() {
        return new CloneListIterator<StateObject>(this.items);
    }

    @Override
    public int itemsSize() {
        return this.items.size();
    }

    @Override
    public StateObject moveDown(StateObject item) {
        this.getChangeSupport().moveDown(this, this.items, SELECT_ITEMS_LIST, item);
        return item;
    }

    @Override
    public StateObject moveUp(StateObject item) {
        this.getChangeSupport().moveUp(this, this.items, SELECT_ITEMS_LIST, item);
        return item;
    }

    @Override
    public void parse(String jpqlFragment) {
        List stateObjects = this.buildStateObjects(jpqlFragment, "select_clause_select_expression");
        this.addItems(stateObjects);
    }

    @Override
    public void removeItem(StateObject stateObject) {
        this.getChangeSupport().removeItem(this, this.items, SELECT_ITEMS_LIST, stateObject);
    }

    @Override
    public void removeItems(Collection<StateObject> items) {
        this.getChangeSupport().removeItems(this, this.items, SELECT_ITEMS_LIST, items);
    }

    @Override
    public void removeListChangeListener(String listName, IListChangeListener<StateObject> listener) {
        this.getChangeSupport().removeListChangeListener(listName, listener);
    }

    public void setExpression(SelectClause expression) {
        super.setExpression(expression);
    }

    public void setItems(List<StateObject> stateObjects) {
        this.builder = null;
        this.getChangeSupport().replaceItems(this, this.items, SELECT_ITEMS_LIST, stateObjects);
    }

    @Override
    protected void toTextInternal(Appendable writer) throws IOException {
        writer.append("SELECT");
        if (this.hasDistinct()) {
            writer.append(' ');
            writer.append("DISTINCT");
        }
        if (this.hasItems()) {
            writer.append(' ');
            this.toStringItems(writer, this.items, true);
        }
    }
}

