/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.template;

import java.io.Serializable;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.rwt.internal.protocol.StylesUtil;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.rap.rwt.remote.JsonMapping;
import org.eclipse.rap.rwt.template.Position;
import org.eclipse.rap.rwt.template.Template;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Cell<T extends Cell>
implements Serializable {
    private static final String PROPERTY_TYPE = "type";
    private static final String PROPERTY_LEFT = "left";
    private static final String PROPERTY_TOP = "top";
    private static final String PROPERTY_RIGHT = "right";
    private static final String PROPERTY_BOTTOM = "bottom";
    private static final String PROPERTY_WIDTH = "width";
    private static final String PROPERTY_HEIGHT = "height";
    private static final String PROPERTY_BINDING_INDEX = "bindingIndex";
    private static final String PROPERTY_SELECTABLE = "selectable";
    private static final String PROPERTY_NAME = "name";
    private static final String PROPERTY_FOREGROUND = "foreground";
    private static final String PROPERTY_BACKGROUND = "background";
    private static final String PROPERTY_FONT = "font";
    private static final String PROPERTY_H_ALIGNMENT = "horizontalAlignment";
    private static final String PROPERTY_V_ALIGNMENT = "verticalAlignment";
    private final String type;
    private String name;
    private int bindingIndex;
    private boolean isSelectable;
    private Color foreground;
    private Color background;
    private Font font;
    private Position left;
    private Position right;
    private Position top;
    private Position bottom;
    private Integer width;
    private Integer height;
    private int horizontalAlignment = 0;
    private int verticalAlignment = 0;

    public Cell(Template template, String type) {
        ParamCheck.notNull(template, "template");
        ParamCheck.notNullOrEmpty(type, PROPERTY_TYPE);
        this.type = type;
        this.bindingIndex = -1;
        template.addCell(this);
    }

    String getType() {
        return this.type;
    }

    public T setName(String name) {
        ParamCheck.notNullOrEmpty(name, PROPERTY_NAME);
        this.name = name;
        return this.getThis();
    }

    String getName() {
        return this.name;
    }

    public T setBindingIndex(int index) {
        this.bindingIndex = index;
        return this.getThis();
    }

    int getBindingIndex() {
        return this.bindingIndex;
    }

    public T setSelectable(boolean selectable) {
        this.isSelectable = selectable;
        return this.getThis();
    }

    boolean isSelectable() {
        return this.isSelectable;
    }

    public T setForeground(Color color) {
        this.foreground = color;
        return this.getThis();
    }

    Color getForeground() {
        return this.foreground;
    }

    public T setBackground(Color color) {
        this.background = color;
        return this.getThis();
    }

    Color getBackground() {
        return this.background;
    }

    public T setFont(Font font) {
        this.font = font;
        return this.getThis();
    }

    Font getFont() {
        return this.font;
    }

    public T setLeft(int offset) {
        return this.setLeft(0.0f, offset);
    }

    public T setLeft(float percentage, int offset) {
        this.checkHorizontalParameters(this.right, this.width);
        Cell.checkPercentage(percentage);
        this.left = new Position(percentage, offset);
        return this.getThis();
    }

    Position getLeft() {
        return this.left;
    }

    public T setRight(int offset) {
        return this.setRight(0.0f, offset);
    }

    public T setRight(float percentage, int offset) {
        this.checkHorizontalParameters(this.left, this.width);
        Cell.checkPercentage(percentage);
        this.right = new Position(percentage, offset);
        return this.getThis();
    }

    Position getRight() {
        return this.right;
    }

    public T setTop(int offset) {
        return this.setTop(0.0f, offset);
    }

    public T setTop(float percentage, int offset) {
        this.checkVerticalParameters(this.bottom, this.height);
        Cell.checkPercentage(percentage);
        this.top = new Position(percentage, offset);
        return this.getThis();
    }

    Position getTop() {
        return this.top;
    }

    public T setBottom(int offset) {
        return this.setBottom(0.0f, offset);
    }

    public T setBottom(float percentage, int offset) {
        this.checkVerticalParameters(this.top, this.height);
        Cell.checkPercentage(percentage);
        this.bottom = new Position(percentage, offset);
        return this.getThis();
    }

    Position getBottom() {
        return this.bottom;
    }

    public T setWidth(int width) {
        this.checkHorizontalParameters(this.left, this.right);
        this.width = width;
        return this.getThis();
    }

    Integer getWidth() {
        return this.width;
    }

    public T setHeight(int height) {
        this.checkVerticalParameters(this.top, this.bottom);
        this.height = height;
        return this.getThis();
    }

    Integer getHeight() {
        return this.height;
    }

    public T setHorizontalAlignment(int alignment) {
        this.horizontalAlignment = alignment;
        return this.getThis();
    }

    int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public T setVerticalAlignment(int alignment) {
        this.verticalAlignment = alignment;
        return this.getThis();
    }

    int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    protected JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add(PROPERTY_TYPE, this.type);
        if (this.left != null) {
            jsonObject.add(PROPERTY_LEFT, this.left.toJson());
        }
        if (this.right != null) {
            jsonObject.add(PROPERTY_RIGHT, this.right.toJson());
        }
        if (this.top != null) {
            jsonObject.add(PROPERTY_TOP, this.top.toJson());
        }
        if (this.bottom != null) {
            jsonObject.add(PROPERTY_BOTTOM, this.bottom.toJson());
        }
        if (this.width != null) {
            jsonObject.add(PROPERTY_WIDTH, this.width);
        }
        if (this.height != null) {
            jsonObject.add(PROPERTY_HEIGHT, this.height);
        }
        if (this.bindingIndex != -1) {
            jsonObject.add(PROPERTY_BINDING_INDEX, this.bindingIndex);
        }
        if (this.isSelectable) {
            jsonObject.add(PROPERTY_SELECTABLE, this.isSelectable);
        }
        if (this.name != null) {
            jsonObject.add(PROPERTY_NAME, this.name);
        }
        if (this.foreground != null) {
            jsonObject.add(PROPERTY_FOREGROUND, JsonMapping.toJson(this.foreground));
        }
        if (this.background != null) {
            jsonObject.add(PROPERTY_BACKGROUND, JsonMapping.toJson(this.background));
        }
        if (this.font != null) {
            jsonObject.add(PROPERTY_FONT, JsonMapping.toJson(this.font));
        }
        if (this.horizontalAlignment != 0) {
            jsonObject.add(PROPERTY_H_ALIGNMENT, Cell.hAlignmentToString(this.horizontalAlignment));
        }
        if (this.verticalAlignment != 0) {
            jsonObject.add(PROPERTY_V_ALIGNMENT, Cell.vAlignmentToString(this.verticalAlignment));
        }
        return jsonObject;
    }

    private T getThis() {
        return (T)this;
    }

    private void checkHorizontalParameters(Object value1, Object value2) {
        if (value1 != null && value2 != null) {
            throw new IllegalStateException("Can only set two horizontal attributes");
        }
    }

    private void checkVerticalParameters(Object value1, Object value2) {
        if (value1 != null && value2 != null) {
            throw new IllegalStateException("Can only set two vertical attributes");
        }
    }

    private static void checkPercentage(float percentage) {
        if (percentage < 0.0f || percentage > 100.0f) {
            throw new IllegalArgumentException("Percentage out of range: " + percentage);
        }
    }

    private static String hAlignmentToString(int alignment) {
        int style = Cell.translate(Cell.translate(alignment, 1, 16384), 0x1000008, 131072);
        String[] styles = StylesUtil.filterStyles(style, "LEFT", "RIGHT", "CENTER");
        if (styles.length != 0) {
            return styles[0];
        }
        return null;
    }

    private static String vAlignmentToString(int alignment) {
        int style = Cell.translate(Cell.translate(alignment, 1, 128), 0x1000008, 1024);
        String[] styles = StylesUtil.filterStyles(style, "TOP", "BOTTOM", "CENTER");
        if (styles.length != 0) {
            return styles[0];
        }
        return null;
    }

    private static int translate(int style, int from, int to) {
        return (style & from) == from ? to : style;
    }
}

