/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.userregion.internal;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.virgo.kernel.userregion.internal.ServiceScopingStrategy;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.service.EventHook;
import org.osgi.framework.hooks.service.FindHook;

final class ServiceScopingRegistryHook
implements FindHook,
EventHook {
    private final ServiceScopingStrategy serviceScopingStrategy;

    public ServiceScopingRegistryHook(ServiceScopingStrategy serviceScopingStrategy) {
        this.serviceScopingStrategy = serviceScopingStrategy;
    }

    public void find(BundleContext context, String name, String filter, boolean allServices, Collection references) {
        this.serviceScopingStrategy.scopeReferences(references, context, name, filter);
    }

    public void event(ServiceEvent event, Collection contexts) {
        ServiceReference ref = event.getServiceReference();
        Iterator iterator = contexts.iterator();
        while (iterator.hasNext()) {
            BundleContext context = (BundleContext)iterator.next();
            if (this.serviceScopingStrategy.isPotentiallyVisible(ref, context)) continue;
            iterator.remove();
        }
    }
}

