/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.tomcat.support;

import java.util.Set;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.eclipse.virgo.util.math.Sets;
import org.eclipse.virgo.web.tomcat.support.ApplicationNameTrackingDelegate;

public final class ApplicationNameTrackingListener
implements ContainerListener,
LifecycleListener {
    private static final Set<String> BEFORE_EVENTS = Sets.asSet((Object[])new String[]{"beforeSessionCreated", "beforeSessionDestroyed", "beforeSessionAttributeRemoved", "beforeSessionAttributeReplaced", "beforeSessionAttributeAdded"});
    private static final Set<String> AFTER_EVENTS = Sets.asSet((Object[])new String[]{"afterSessionCreated", "afterSessionDestroyed", "afterSessionAttributeRemoved", "afterSessionAttributeReplaced", "afterSessionAttributeAdded"});
    private final ApplicationNameTrackingDelegate delegate = ApplicationNameTrackingDelegate.getInstance();

    public void containerEvent(ContainerEvent event) {
        Container container = event.getContainer();
        String type = event.getType();
        if (container instanceof Host) {
            this.handleHostContainerEvents(event, type);
        } else if (container instanceof Context) {
            this.handleContextContainerEvents(container, type);
        }
    }

    private void handleHostContainerEvents(ContainerEvent event, String type) {
        Object data = event.getData();
        if (data instanceof Context) {
            Context child = (Context)data;
            if ("addChild".equals(type)) {
                child.addContainerListener((ContainerListener)this);
            } else if ("removeChild".equals(type)) {
                child.removeContainerListener((ContainerListener)this);
            }
        }
    }

    private void handleContextContainerEvents(Container container, String type) {
        if (BEFORE_EVENTS.contains(type)) {
            Context context = (Context)container;
            this.delegate.setApplicationNameForContextPath(context.getPath());
        } else if (AFTER_EVENTS.contains(type)) {
            this.delegate.clearName();
        }
    }

    public void lifecycleEvent(LifecycleEvent event) {
        Object source = event.getSource();
        if (source instanceof Host) {
            Host host = (Host)source;
            if ("before_start".equals(event.getType())) {
                host.addContainerListener((ContainerListener)this);
            } else if ("after_stop".equals(event.getType())) {
                host.removeContainerListener((ContainerListener)this);
            }
        }
    }
}

