/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.resource.LibraryInfo;
import com.sun.faces.application.resource.ResourceHelper;
import com.sun.faces.application.resource.VersionInfo;
import com.sun.faces.util.FacesLogger;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;

public class ResourceInfo {
    private static final Logger LOGGER = FacesLogger.RESOURCE.getLogger();
    private static final String COMPRESSED_CONTENT_DIRECTORY = "jsf-compressed";
    String name;
    String libraryName;
    String localePrefix;
    boolean cacheTimestamp;
    boolean isDevStage;
    VersionInfo version;
    ResourceHelper helper;
    LibraryInfo library;
    String path;
    String compressedPath;
    boolean compressible;
    boolean supportsEL;
    private volatile long lastModified = Long.MIN_VALUE;

    public ResourceInfo(LibraryInfo library, String name, VersionInfo version, boolean compressible, boolean supportsEL, boolean isDevStage, boolean cacheTimestamp) {
        this.name = name;
        this.version = version;
        this.helper = library.getHelper();
        this.library = library;
        this.libraryName = library.getName();
        this.localePrefix = library.getLocalePrefix();
        this.compressible = compressible;
        this.supportsEL = supportsEL;
        this.isDevStage = isDevStage;
        this.cacheTimestamp = !isDevStage && cacheTimestamp;
        this.initPath(isDevStage);
    }

    ResourceInfo(String name, VersionInfo version, String localePrefix, ResourceHelper helper, boolean compressible, boolean supportsEL, boolean isDevStage, boolean cacheTimestamp) {
        this.name = name;
        this.version = version;
        this.localePrefix = localePrefix;
        this.helper = helper;
        this.compressible = compressible;
        this.supportsEL = supportsEL;
        this.isDevStage = isDevStage;
        this.cacheTimestamp = !isDevStage && cacheTimestamp;
        this.initPath(isDevStage);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ResourceInfo other = (ResourceInfo)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.libraryName == null ? other.libraryName != null : !this.libraryName.equals(other.libraryName)) {
            return false;
        }
        if (this.localePrefix == null ? other.localePrefix != null : !this.localePrefix.equals(other.localePrefix)) {
            return false;
        }
        if (!(this.version == other.version || this.version != null && this.version.equals(other.version))) {
            return false;
        }
        if (!(this.library == other.library || this.library != null && this.library.equals(other.library))) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 97 * hash + (this.libraryName != null ? this.libraryName.hashCode() : 0);
        hash = 97 * hash + (this.localePrefix != null ? this.localePrefix.hashCode() : 0);
        hash = 97 * hash + (this.version != null ? this.version.hashCode() : 0);
        hash = 97 * hash + (this.library != null ? this.library.hashCode() : 0);
        hash = 97 * hash + (this.path != null ? this.path.hashCode() : 0);
        return hash;
    }

    public String getName() {
        return this.name;
    }

    public VersionInfo getVersion() {
        return this.version;
    }

    public ResourceHelper getHelper() {
        return this.helper;
    }

    public LibraryInfo getLibraryInfo() {
        return this.library;
    }

    public String getLocalePrefix() {
        return this.localePrefix;
    }

    public String getPath() {
        return this.path;
    }

    public String getCompressedPath() {
        return this.compressedPath;
    }

    public boolean isCompressable() {
        return this.compressible;
    }

    public boolean supportsEL() {
        return this.supportsEL;
    }

    public void disableEL() {
        this.supportsEL = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastModified(FacesContext ctx) {
        if (this.cacheTimestamp) {
            if (this.lastModified == Long.MIN_VALUE) {
                ResourceInfo resourceInfo = this;
                synchronized (resourceInfo) {
                    if (this.lastModified == Long.MIN_VALUE) {
                        this.lastModified = this.helper.getLastModified(this, ctx);
                    }
                }
            }
            return this.lastModified;
        }
        return this.helper.getLastModified(this, ctx);
    }

    public String toString() {
        return "ResourceInfo{name='" + this.name + '\'' + ", version='" + (this.version != null ? this.version : "NONE") + '\'' + ", libraryName='" + this.libraryName + '\'' + ", libraryVersion='" + (this.library != null ? this.library.getVersion() : "NONE") + '\'' + ", localePrefix='" + (this.localePrefix != null ? this.localePrefix : "NONE") + '\'' + ", path='" + this.path + '\'' + ", compressible='" + this.compressible + '\'' + ", compressedPath=" + this.compressedPath + '}';
    }

    private void initPath(boolean isDevStage) {
        StringBuilder sb = new StringBuilder(32);
        if (this.library != null) {
            sb.append(this.library.getPath());
        } else {
            sb.append(this.helper.getBaseResourcePath());
        }
        if (this.library == null && this.localePrefix != null) {
            sb.append('/').append(this.localePrefix);
        }
        if (isDevStage && "javax.faces".equals(this.libraryName) && "jsf.js".equals(this.name)) {
            sb.append('/').append("jsf-uncompressed.js");
        } else {
            sb.append('/').append(this.name);
        }
        if (this.version != null) {
            sb.append('/').append(this.version.getVersion());
            String extension = this.version.getExtension();
            if (extension != null) {
                sb.append('.').append(extension);
            }
        }
        this.path = sb.toString();
        if (this.compressible && !this.supportsEL) {
            FacesContext ctx = FacesContext.getCurrentInstance();
            File servletTmpDir = (File)ctx.getExternalContext().getApplicationMap().get("javax.servlet.context.tempdir");
            if (servletTmpDir == null || !servletTmpDir.isDirectory()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "File ({0}) referenced by javax.servlet.context.tempdir attribute is null, or was is not a directory.  Compression for {1} will be unavailable.", new Object[]{servletTmpDir == null ? "null" : servletTmpDir.toString(), this.path});
                }
                this.compressible = false;
            } else {
                String tPath = this.path.charAt(0) == '/' ? this.path : '/' + this.path;
                File newDir = new File(servletTmpDir, COMPRESSED_CONTENT_DIRECTORY + tPath);
                try {
                    if (!newDir.exists()) {
                        if (newDir.mkdirs()) {
                            this.compressedPath = newDir.getCanonicalPath();
                        } else {
                            this.compressible = false;
                            if (LOGGER.isLoggable(Level.WARNING)) {
                                LOGGER.log(Level.WARNING, "jsf.application.resource.unable_to_create_compression_directory", newDir.getCanonicalPath());
                            }
                        }
                    } else {
                        this.compressedPath = newDir.getCanonicalPath();
                    }
                }
                catch (Exception e) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, e.toString(), e);
                    }
                    this.compressible = false;
                }
            }
        }
    }
}

